(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    174232,       4373]*)
(*NotebookOutlinePosition[    177920,       4479]*)
(*  CellTagsIndexPosition[    177824,       4472]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The Season Package (by Ekkehart Schlicht)", "Title",
  CellTags->"b:0"],

Cell[TextData[{
  "Revision 2 of June 2006. Revised February 2017, prepared for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1.\n "
}], "Text",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"b:0"],

Cell[TextData[{
  "\nThe package implements Schlicht's (1984) seasonal adjustment method. It \
decomposes a time series ",
  Cell[BoxData[
      \(TraditionalForm\`x\_t, \ \(\(t\)\(\ \)\(\[Element]\)\(\ \)\({1,  \
... , T}\)\(\ \)\)\)]],
  "into a trend ",
  Cell[BoxData[
      \(TraditionalForm\`y\_t, \ \(\(t\)\(\ \)\(\[Element]\)\(\ \)\({1,  \
... , T}\)\(\ \)\)\)]],
  ", a seasonal component ",
  Cell[BoxData[
      \(TraditionalForm\`z\_t, \ \(\(t\)\(\ \)\(\[Element]\)\(\ \)\({1,  \
... , T}\)\(\ \)\)\)]],
  ", and an irregular component ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t, \ \(\(t\)\(\ \)\(\[Element]\)\(\ \)\({1,  \
... , T}\)\(\ \)\)\)]],
  "such that ",
  Cell[BoxData[
      \(TraditionalForm\`x\_t = 
        y\_t + z\_t + u\_t\ for\ all\ \ \(\(t\)\(.\)\(\ \)\)\)]],
  "The method uses non-parametric splines. It combines the trend filter \
proposed by Leser (1961),  known as the HP-Filter filter, the seasonal filter \
proposed by Schlicht and Pauly (1983) and the orthogonal parametrization \
proposed by Schlicht (1984, 2005). For the treatment of missing observations \
and structural breaks, see Schlicht(2009). In contrast to prevailing methods, \
the method used here is based on an explicit statistical model (state-space). \
Season is appropriate for smoothing time series with higher than annual \
frequency.  Season is inappropriate for smoothing annual data or \
deseasonalized time series; for this, use the HPFilter package by Johannes \
Ludsteck. \n  \nThis package provides the following functions for seasonal \
adjustment:"
}], "Text",
  CellTags->"b:0"],

Cell[TextData[{
  "Season[",
  StyleBox["x,s",
    FontSlant->"Italic"],
  "]  splits the series ",
  StyleBox["x",
    FontSlant->"Italic"],
  " into trend, seasonal component, and irregular component, using estimated \
optimum smoothing parameters.\nSeason[",
  StyleBox["x,s,",
    FontSlant->"Italic"],
  "\[Alpha],\[Gamma]] splits the series ",
  StyleBox["x",
    FontSlant->"Italic"],
  " into trend, seasonal component, and irregular component, using the \
smoothing parameters \[Alpha] and \[Gamma]. \n\n",
  StyleBox["Both versions of Season[ ] return a list {{", "Commentary"],
  StyleBox["x,y", "Commentary",
    FontSlant->"Italic"],
  StyleBox[",", "Commentary"],
  StyleBox["z,u", "Commentary",
    FontSlant->"Italic"],
  StyleBox["},{\[Alpha],\[Gamma]},", "Commentary"],
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^2\)]],
  StyleBox["} where ", "Commentary"],
  StyleBox["x", "Commentary",
    FontSlant->"Italic"],
  StyleBox[" is the input series, ", "Commentary"],
  StyleBox["y", "Commentary",
    FontSlant->"Italic"],
  StyleBox[" is the trend, ", "Commentary"],
  StyleBox["z ", "Commentary",
    FontSlant->"Italic"],
  StyleBox["is the seasonal component, ", "Commentary"],
  StyleBox["u", "Commentary",
    FontSlant->"Italic"],
  StyleBox[" is the irregular component, \[Alpha] and \[Gamma] are the \
smoothing parameters used and ", "Commentary"],
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^2\)]],
  StyleBox[" is the variance of the irregular component..\n", "Commentary"],
  "\nLL[",
  StyleBox["x,s,",
    FontSlant->"Italic"],
  "\[Alpha],\[Gamma]] give the log likelihood of the constellation {",
  StyleBox["x,s",
    FontSlant->"Italic"],
  ",\[Alpha],\[Gamma]}.\n\nLLPlot[",
  StyleBox["x,s",
    FontSlant->"Italic"],
  ", {",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Alpha]", 
            StyleBox["max",
              FontSlant->"Italic"]], "}"}], TraditionalForm]]],
  ",{ ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["max",
            FontSlant->"Italic"]], TraditionalForm]]],
  "}] plots the log likelihood for the range {\[Alpha],\[Gamma]}\[Element][",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Alpha]", 
            StyleBox["max",
              FontSlant->"Italic"]], "]"}], TraditionalForm]]],
  "\[Times][",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["max",
            FontSlant->"Italic"]], TraditionalForm]]],
  "].\n"
}], "DefinitionBox",
  CellTags->{"i:1", "b:0"}],

Cell[TextData[{
  "The method needs the time series ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "and the length of the season ",
  StyleBox["s ",
    FontSlant->"Italic"],
  "as an input (",
  StyleBox["e.g",
    FontSlant->"Italic"],
  ". ",
  StyleBox["s",
    FontSlant->"Italic"],
  "=",
  StyleBox["4 ",
    FontSlant->"Italic"],
  "for quarterly data or ",
  StyleBox["s",
    FontSlant->"Italic"],
  "=",
  StyleBox["12",
    FontSlant->"Italic"],
  " for monthly data). The function Season[",
  StyleBox["x,s",
    FontSlant->"Italic"],
  "] computes smoothing parameters \[Alpha] and \[Gamma] by a maximum \
likelihood method and splits the time series, using these weights. \
Alternatively, the parameters can be provided in Season[",
  StyleBox["x,s",
    FontSlant->"Italic"],
  ",\[Alpha],\[Gamma]]. The parameter \[Alpha] controls the smoothness of the \
trend - the larger \[Alpha], the smoother the trend. The parameter \[Gamma] \
controls the rigidity of the seasonal pattern - the larger \[Gamma], the more \
time-invariant is the seasonal pattern. Both parameters interact: Increasing \
\[Alpha] while keeping \[Gamma] constant will shift some variabilty from the \
trend to the seasonal component, for example (and the rest to the irregular \
component). \n\nThe method assumes that trend, season and irregular component \
are ",
  StyleBox["additive",
    FontSlant->"Italic"],
  " components of the time series. For some time series, such as trended time \
series, a ",
  StyleBox["multiplicative",
    FontSlant->"Italic"],
  " formulation is preferable. In this case, take the logarithms of the \
original data as the input.\n\n",
  StyleBox["Instructions: Place the package season5.m in ", "Notebook"],
  StyleBox[Cell[TextData[StyleBox[ButtonBox["$UserBaseDirectory",
    ButtonData:>"paclet:ref/$UserBaseDirectory"],
    ButtonBoxOptions -> {BaseStyle -> "Link"}]], "Notebook"], "Notebook"],
  StyleBox["\\Applications\\Season (usually \
C:\\Users\\<username>\\AppData\\Roaming\\", "Notebook"],
  StyleBox["Mathematica", "Notebook",
    FontSlant->"Italic"],
  StyleBox["\n\\Applications\\\" and evaluate the following cells.\n", 
    "Notebook"],
  "\nTo obtain information of the available functions, such as Season[], \
evaluate it with a question mark, like ",
  StyleBox["?Season. ",
    FontFamily->"Courier New"],
  StyleBox["The list of of functions in the package season5.m  can be \
obtained by opening in ",
    FontFamily->"Times New Roman"],
  StyleBox["Mathematica",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[" and click on \"",
    FontFamily->"Times New Roman"],
  StyleBox["Functions",
    FontFamily->"Segoe UI"],
  StyleBox["\".",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell["This loads the package", "MathCaption",
  CellTags->"b:0"],

Cell[BoxData[
    \(<< Season5`\)], "Input",
  CellTags->"b:0"],

Cell["\<\
Here is a series with 128 elements - the time series of monthly Gereman \
unemployment rates for 1992:01 through 2002:08.\
\>", "MathCaption",
  CellTags->"b:0"],

Cell[BoxData[
    RowBox[{
      RowBox[{"x", "=", 
        RowBox[{
          StyleBox["{",
            FontFamily->"Courier New",
            FontWeight->"Medium",
            FontSlant->"Plain",
            FontColor->GrayLevel[0],
            FontVariations->{"Underline"->False,
            "StrikeThrough"->False}], 
          
          StyleBox[\(8.3, 8.2, 7.7, 7.6, 7.4, 7.3, 7.8, 7.7, 7.5, 7.6, 7.7, 
            8.1, 9, 9, 8.7, 8.6, 8.4, 8.5, 9.1, 9.1, 8.9, 9.1, 9.2, 9.6, 
            10.5, 10.5, 10.1, 9.9, 9.5, 9.3, 9.6, 9.4, 9.1, 8.9, 8.9, 9.2, 
            10, 10, 9.6, 9.4, 9, 9, 9.4, 9.3, 9.2, 9.2, 9.3, 9.9, 10.8, 11.1, 
            10.8, 10.4, 10, 9.9, 10.2, 10.2, 10.1, 10.1, 10.3, 10.8, 12.2, 
            12.2, 11.7, 11.3, 11.1, 11, 11.4, 11.4, 11.2, 11.2, 11.3, 11.8, 
            12.6, 12.6, 12.1, 11.4, 10.9, 10.5, 10.7, 10.6, 10.3, 10.1, 10.2, 
            10.9, 11.5, 11.6, 11.1, 10.7, 10.2, 10.1, 10.3, 10.3, 10.1, 9.9, 
            10, 10.3, 11, 10.9, 10.6, 9.8, 9.3, 9.1, 9.3, 9.3, 9, 8.9, 8.9, 
            9.3, 10, 10.1, 9.8, 9.5, 9, 8.9, 9.2, 9.2, 9, 9, 9.2, 9.6, 10.4, 
            10.4, 10, 9.7, 9.5, 9.5, 9.7, 9.6\),
            FontFamily->"Courier New",
            FontWeight->"Medium"], 
          StyleBox["}",
            FontFamily->"Courier New",
            FontWeight->"Medium"]}]}], 
      StyleBox[";",
        FontFamily->"Courier New"]}]], "Input",
  CellTags->"b:0"],

Cell[TextData[{
  "The following code calls the decomposition routine for monthly data with \
smoothing parameter values \[Alpha]=100 and \[Gamma]=100 and returns the list \
{{",
  StyleBox["x,y,z,u",
    FontSlant->"Italic"],
  "},{\[Alpha],\[Gamma]}}."
}], "MathCaption",
  CellTags->"b:0"],

Cell[BoxData[
    \(\({{x, y, z, u}, {a, g}, varU} = 
        Season[x, 12, 100, \ 100];\)\)], "Input",
  CellTags->"b:0"],

Cell[TextData[{
  "Here is a plot of the original time series ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "(red)",
  ", the trend ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "(blue)",
  ", and the seasonal component ",
  StyleBox["z ",
    FontSlant->"Italic"],
  "(green)",
  "."
}], "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    \(\(MultipleListPlot[x, y, z\ , PlotJoined \[Rule] True, 
        PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                1]}, {RGBColor[0, 1, 0]}}, 
        SymbolShape \[Rule] None];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<Smoothing parameters: \[Alpha] = \>", 
        a, "\<,  \[Gamma] = \>", g];\)\), "\[IndentingNewLine]", 
    \(\(\(Print[\*"\"\<Implied variances: \!\(\[Sigma]\_u\^2\) = \>\"", \ 
        varU, \ \*"\"\<, \!\(\[Sigma]\_v\^2\) = \>\"", 
        varU/a, \*"\"\<, \!\(\[Sigma]\_w\^2\) = \>\"", 
        varU/g];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellTags->"b:0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00744048 0.0364713 0.0449879 [
[.17262 .02397 -6 -9 ]
[.17262 .02397 6 0 ]
[.32143 .02397 -6 -9 ]
[.32143 .02397 6 0 ]
[.47024 .02397 -6 -9 ]
[.47024 .02397 6 0 ]
[.61905 .02397 -6 -9 ]
[.61905 .02397 6 0 ]
[.76786 .02397 -9 -9 ]
[.76786 .02397 9 0 ]
[.91667 .02397 -9 -9 ]
[.91667 .02397 9 0 ]
[.01131 .12645 -6 -4.5 ]
[.01131 .12645 0 4.5 ]
[.01131 .21642 -6 -4.5 ]
[.01131 .21642 0 4.5 ]
[.01131 .3064 -6 -4.5 ]
[.01131 .3064 0 4.5 ]
[.01131 .39637 -6 -4.5 ]
[.01131 .39637 0 4.5 ]
[.01131 .48635 -12 -4.5 ]
[.01131 .48635 0 4.5 ]
[.01131 .57633 -12 -4.5 ]
[.01131 .57633 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17262 .03647 m
.17262 .04272 L
s
[(20)] .17262 .02397 0 1 Mshowa
.32143 .03647 m
.32143 .04272 L
s
[(40)] .32143 .02397 0 1 Mshowa
.47024 .03647 m
.47024 .04272 L
s
[(60)] .47024 .02397 0 1 Mshowa
.61905 .03647 m
.61905 .04272 L
s
[(80)] .61905 .02397 0 1 Mshowa
.76786 .03647 m
.76786 .04272 L
s
[(100)] .76786 .02397 0 1 Mshowa
.91667 .03647 m
.91667 .04272 L
s
[(120)] .91667 .02397 0 1 Mshowa
.125 Mabswid
.06101 .03647 m
.06101 .04022 L
s
.09821 .03647 m
.09821 .04022 L
s
.13542 .03647 m
.13542 .04022 L
s
.20982 .03647 m
.20982 .04022 L
s
.24702 .03647 m
.24702 .04022 L
s
.28423 .03647 m
.28423 .04022 L
s
.35863 .03647 m
.35863 .04022 L
s
.39583 .03647 m
.39583 .04022 L
s
.43304 .03647 m
.43304 .04022 L
s
.50744 .03647 m
.50744 .04022 L
s
.54464 .03647 m
.54464 .04022 L
s
.58185 .03647 m
.58185 .04022 L
s
.65625 .03647 m
.65625 .04022 L
s
.69345 .03647 m
.69345 .04022 L
s
.73065 .03647 m
.73065 .04022 L
s
.80506 .03647 m
.80506 .04022 L
s
.84226 .03647 m
.84226 .04022 L
s
.87946 .03647 m
.87946 .04022 L
s
.95387 .03647 m
.95387 .04022 L
s
.99107 .03647 m
.99107 .04022 L
s
.25 Mabswid
0 .03647 m
1 .03647 L
s
.02381 .12645 m
.03006 .12645 L
s
[(2)] .01131 .12645 1 0 Mshowa
.02381 .21642 m
.03006 .21642 L
s
[(4)] .01131 .21642 1 0 Mshowa
.02381 .3064 m
.03006 .3064 L
s
[(6)] .01131 .3064 1 0 Mshowa
.02381 .39637 m
.03006 .39637 L
s
[(8)] .01131 .39637 1 0 Mshowa
.02381 .48635 m
.03006 .48635 L
s
[(10)] .01131 .48635 1 0 Mshowa
.02381 .57633 m
.03006 .57633 L
s
[(12)] .01131 .57633 1 0 Mshowa
.125 Mabswid
.02381 .05897 m
.02756 .05897 L
s
.02381 .08146 m
.02756 .08146 L
s
.02381 .10395 m
.02756 .10395 L
s
.02381 .14894 m
.02756 .14894 L
s
.02381 .17144 m
.02756 .17144 L
s
.02381 .19393 m
.02756 .19393 L
s
.02381 .23892 m
.02756 .23892 L
s
.02381 .26141 m
.02756 .26141 L
s
.02381 .2839 m
.02756 .2839 L
s
.02381 .32889 m
.02756 .32889 L
s
.02381 .35139 m
.02756 .35139 L
s
.02381 .37388 m
.02756 .37388 L
s
.02381 .41887 m
.02756 .41887 L
s
.02381 .44136 m
.02756 .44136 L
s
.02381 .46386 m
.02756 .46386 L
s
.02381 .50884 m
.02756 .50884 L
s
.02381 .53134 m
.02756 .53134 L
s
.02381 .55383 m
.02756 .55383 L
s
.02381 .01398 m
.02756 .01398 L
s
.02381 .59882 m
.02756 .59882 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.001 w
.03125 .40987 m
.03869 .40537 L
.04613 .38288 L
.05357 .37838 L
.06101 .36938 L
.06845 .36488 L
.07589 .38738 L
.08333 .38288 L
.09077 .37388 L
.09821 .37838 L
.10565 .38288 L
.1131 .40087 L
.12054 .44136 L
.12798 .44136 L
.13542 .42787 L
.14286 .42337 L
.1503 .41437 L
.15774 .41887 L
.16518 .44586 L
.17262 .44586 L
.18006 .43686 L
.1875 .44586 L
.19494 .45036 L
.20238 .46836 L
.20982 .50884 L
.21726 .50884 L
.2247 .49085 L
.23214 .48185 L
.23958 .46386 L
.24702 .45486 L
.25446 .46836 L
.2619 .45936 L
.26935 .44586 L
.27679 .43686 L
.28423 .43686 L
.29167 .45036 L
.29911 .48635 L
.30655 .48635 L
.31399 .46836 L
.32143 .45936 L
.32887 .44136 L
.33631 .44136 L
.34375 .45936 L
.35119 .45486 L
.35863 .45036 L
.36607 .45036 L
.37351 .45486 L
.38095 .48185 L
.38839 .52234 L
.39583 .53584 L
Mistroke
.40327 .52234 L
.41071 .50435 L
.41815 .48635 L
.4256 .48185 L
.43304 .49535 L
.44048 .49535 L
.44792 .49085 L
.45536 .49085 L
.4628 .49985 L
.47024 .52234 L
.47768 .58532 L
.48512 .58532 L
.49256 .56283 L
.5 .54483 L
.50744 .53584 L
.51488 .53134 L
.52232 .54933 L
.52976 .54933 L
.5372 .54034 L
.54464 .54034 L
.55208 .54483 L
.55952 .56733 L
.56696 .60332 L
.5744 .60332 L
.58185 .58082 L
.58929 .54933 L
.59673 .52684 L
.60417 .50884 L
.61161 .51784 L
.61905 .51334 L
.62649 .49985 L
.63393 .49085 L
.64137 .49535 L
.64881 .52684 L
.65625 .55383 L
.66369 .55833 L
.67113 .53584 L
.67857 .51784 L
.68601 .49535 L
.69345 .49085 L
.70089 .49985 L
.70833 .49985 L
.71577 .49085 L
.72321 .48185 L
.73065 .48635 L
.7381 .49985 L
.74554 .53134 L
.75298 .52684 L
.76042 .51334 L
.76786 .47735 L
Mistroke
.7753 .45486 L
.78274 .44586 L
.79018 .45486 L
.79762 .45486 L
.80506 .44136 L
.8125 .43686 L
.81994 .43686 L
.82738 .45486 L
.83482 .48635 L
.84226 .49085 L
.8497 .47735 L
.85714 .46386 L
.86458 .44136 L
.87202 .43686 L
.87946 .45036 L
.8869 .45036 L
.89435 .44136 L
.90179 .44136 L
.90923 .45036 L
.91667 .46836 L
.92411 .50435 L
.93155 .50435 L
.93899 .48635 L
.94643 .47285 L
.95387 .46386 L
.96131 .46386 L
.96875 .47285 L
.97619 .46836 L
Mfstroke
0 0 1 r
.03125 .3649 m
.03869 .36826 L
.04613 .37167 L
.05357 .37518 L
.06101 .37871 L
.06845 .38221 L
.07589 .38565 L
.08333 .38904 L
.09077 .39242 L
.09821 .3959 L
.10565 .39954 L
.1131 .40349 L
.12054 .40787 L
.12798 .41279 L
.13542 .4183 L
.14286 .42431 L
.1503 .43066 L
.15774 .43713 L
.16518 .44347 L
.17262 .44943 L
.18006 .45486 L
.1875 .45962 L
.19494 .46362 L
.20238 .46683 L
.20982 .46924 L
.21726 .47089 L
.2247 .47179 L
.23214 .47193 L
.23958 .47132 L
.24702 .46999 L
.25446 .46807 L
.2619 .46568 L
.26935 .46305 L
.27679 .46039 L
.28423 .45795 L
.29167 .45595 L
.29911 .45459 L
.30655 .45398 L
.31399 .45417 L
.32143 .45514 L
.32887 .45678 L
.33631 .45902 L
.34375 .46175 L
.35119 .46488 L
.35863 .46833 L
.36607 .47204 L
.37351 .47595 L
.38095 .47998 L
.38839 .48405 L
.39583 .48805 L
Mistroke
.40327 .49188 L
.41071 .49551 L
.41815 .49901 L
.4256 .50251 L
.43304 .50611 L
.44048 .50995 L
.44792 .51408 L
.45536 .51851 L
.4628 .52319 L
.47024 .52804 L
.47768 .5329 L
.48512 .53754 L
.49256 .54187 L
.5 .54587 L
.50744 .54952 L
.51488 .55275 L
.52232 .5555 L
.52976 .55766 L
.5372 .55916 L
.54464 .55989 L
.55208 .55978 L
.55952 .55876 L
.56696 .55679 L
.5744 .55392 L
.58185 .55023 L
.58929 .54594 L
.59673 .54132 L
.60417 .53666 L
.61161 .53224 L
.61905 .52824 L
.62649 .52478 L
.63393 .5219 L
.64137 .51959 L
.64881 .51775 L
.65625 .51622 L
.66369 .51489 L
.67113 .51365 L
.67857 .51243 L
.68601 .51116 L
.69345 .50977 L
.70089 .50818 L
.70833 .50634 L
.71577 .50413 L
.72321 .50149 L
.73065 .4984 L
.7381 .49487 L
.74554 .49097 L
.75298 .48679 L
.76042 .48244 L
.76786 .47801 L
Mistroke
.7753 .47371 L
.78274 .4697 L
.79018 .46607 L
.79762 .46287 L
.80506 .46013 L
.8125 .45785 L
.81994 .45606 L
.82738 .45477 L
.83482 .454 L
.84226 .45375 L
.8497 .45394 L
.85714 .45445 L
.86458 .45522 L
.87202 .4562 L
.87946 .45737 L
.8869 .45869 L
.89435 .46012 L
.90179 .46162 L
.90923 .46317 L
.91667 .46474 L
.92411 .46638 L
.93155 .46811 L
.93899 .46998 L
.94643 .47199 L
.95387 .47409 L
.96131 .47618 L
.96875 .47823 L
.97619 .48024 L
Mfstroke
0 1 0 r
.03125 .07607 m
.03869 .07576 L
.04613 .05639 L
.05357 .04036 L
.06101 .02325 L
.06845 .01735 L
.07589 .03169 L
.08333 .02781 L
.09077 .01756 L
.09821 .01521 L
.10565 .01859 L
.1131 .03766 L
.12054 .07601 L
.12798 .07579 L
.13542 .05648 L
.14286 .04034 L
.1503 .02318 L
.15774 .0173 L
.16518 .0316 L
.17262 .02777 L
.18006 .01756 L
.1875 .01517 L
.19494 .01859 L
.20238 .03772 L
.20982 .07604 L
.21726 .07595 L
.2247 .0567 L
.23214 .04039 L
.23958 .02315 L
.24702 .01726 L
.25446 .03143 L
.2619 .02769 L
.26935 .01755 L
.27679 .01505 L
.28423 .01854 L
.29167 .03777 L
.29911 .07605 L
.30655 .07612 L
.31399 .05693 L
.32143 .04037 L
.32887 .02306 L
.33631 .01718 L
.34375 .03121 L
.35119 .02758 L
.35863 .01753 L
.36607 .01496 L
.37351 .01852 L
.38095 .03791 L
.38839 .07615 L
.39583 .07637 L
Mistroke
.40327 .05724 L
.41071 .04037 L
.41815 .02301 L
.4256 .01708 L
.43304 .03096 L
.44048 .02747 L
.44792 .01748 L
.45536 .01484 L
.4628 .0185 L
.47024 .038 L
.47768 .07623 L
.48512 .07652 L
.49256 .05745 L
.5 .04031 L
.50744 .02296 L
.51488 .01701 L
.52232 .03076 L
.52976 .02743 L
.5372 .01748 L
.54464 .01479 L
.55208 .01856 L
.55952 .03819 L
.56696 .0762 L
.5744 .07661 L
.58185 .05767 L
.58929 .04032 L
.59673 .02291 L
.60417 .01696 L
.61161 .03057 L
.61905 .02737 L
.62649 .01746 L
.63393 .01472 L
.64137 .01857 L
.64881 .03829 L
.65625 .07608 L
.66369 .07657 L
.67113 .05777 L
.67857 .04033 L
.68601 .02288 L
.69345 .01701 L
.70089 .03049 L
.70833 .0274 L
.71577 .01754 L
.72321 .01476 L
.73065 .01867 L
.7381 .03833 L
.74554 .07599 L
.75298 .0765 L
.76042 .05786 L
.76786 .04032 L
Mistroke
.7753 .02286 L
.78274 .01704 L
.79018 .03041 L
.79762 .02737 L
.80506 .01753 L
.8125 .01478 L
.81994 .01871 L
.82738 .03833 L
.83482 .07589 L
.84226 .07642 L
.8497 .05783 L
.85714 .04036 L
.86458 .0229 L
.87202 .01712 L
.87946 .03041 L
.8869 .02735 L
.89435 .01754 L
.90179 .0148 L
.90923 .01877 L
.91667 .03836 L
.92411 .07587 L
.93155 .07637 L
.93899 .05776 L
.94643 .04032 L
.95387 .02293 L
.96131 .0172 L
.96875 .03042 L
.97619 .02732 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool0039oo`08Oc80000000004VOoOombc@800003=]aoogoo01moo`06L/d0000=Fimoog;=0P0000<f
g7ooOol07Goo00MonDP000003E^OOombc@0200000cKLOomoo`0NOol016I0000003KL0Woo00Abc@00
000fg1]oo`08OoU8000000003E^OOombc@800004=]aoogooL/d200000cKLOomoo`0FOol01goiB000
000000eKWglb00<00004019WogooL/d200000cKLOomoo`0?Ool000moo`03001oogoo025oo`03FJ00
4VOo00=oo`05FUIoogooFK9Wo`0QOol01Glb=]aoogooFUH00Woo00=I/VOoOol07Goo00MV@4/oOomo
nFLoOomJEP02Ool00eVbIomoo`0MOol01GoiBUUoogooFUH00Woo00EJEWooOomI/VOo01aoo`03Oc8f
g7oo009oo`07FUIoogooFK9WogooFUH00Woo00=I/VOoOol067oo00=o<SKLOol00Woo00=IX00BIol0
0goo00EJEWooOomI/VOo011oo`003goo00<007ooOol08Woo00Io<P00BcmoogoiBKH2Ool00fI=Fimo
o`0MOol027oiB000000000eKWgoiBKH2Ool00fI=Fimoo`0LOol027oiB00fg7ooL/e;?goiBKH2Ool0
0fI=Fimoo`0NOol01eYFOomonDYIOomonDVf009oo`03ITeKWgoo01]oo`06Oc8fg7ooOomonDVf0Woo
00AVCE^OOoU9]P9oo`03ITeKWgoo01Qoo`03Oc8fg7oo00=oo`06Oc8004/oOomonDVf0Woo00=VCE^O
Ool03goo000?Ool00`00Oomoo`0SOol01GoiIcmoogoiBKH00Woo00=VCE^OOol07Woo00MV@4/oOc8f
g7ooOoU9]P02Ool00fI=Fimoo`0MOol01eVb=J00006fOomonDVf009oo`03ITeKWgoo01ioo`07IT00
0000=]aoogoiBKH00Woo00=VCE^OOol06goo00Io<SKLOomoogoiBKH2Ool016I=FimonDVf0Woo00=V
CE^OOol067oo00=o<SKLOol017oo00EonFLoOomonDVf009oo`03ITeKWgoo00moo`003goo00<007oo
Ool087oo00aoUSFfOomonDPBIomooeV]FimonDPBIolOOol017oiB0eJdSKL0Woo00EI[E^OOoU84VOo
01ioo`03Oc81]Woo00=oo`05FJeKWgoiB19Wo`0NOol01GoiBKIoogoiBKH00Woo00EI[E^OOoU84VOo
01]oo`03FK9W<SKL00=oo`0;FJeKWgoiB19WogooFJeKWgoiB19Wo`0HOol00eVbIc8fg002Ool037nF
=KIoogoiB19WogooFJeKWgoiB19Woa1oo`003goo0P004goo00<3h7ooOol037oo00Abc@00000fg09o
o`03OiHd00000083h1Moo`030n1oogoo00Ioo`03OiHd03KL009oo`04OiHd0000Bcl7Ool00`?POomo
o`0FOol02@?P000004/oOomoUS@0001;?`0@Ool00`?POomoo`0=Ool017;=000004/o0Woo00AoUS@0
0003h1Moo`83h0=oo`03Oc8003KL00=oo`04OiHd0000Bcl2Ool017nF=00004/o17oo00<3h7ooOol0
4Woo00Mo<P00=]aoo`?POombc@0200001cKLOomoognF=00004/o015oo`003goo00<007ooOol02Goo
00<3h7ooOol017oo0P?P00=oo`?P0n003Goo00<3h7ooOol00goo0P?P0Woo0P?P3Goo00<3h7ooOol0
0goo0P?P00=oo`?P0n003Woo00<3h7ooOol00goo0P?P00=oo`?P0n003Woo00<3h7ooOol00goo0P?P
00=oo`?P0n003Woo00<3h7ooOol00goo0P?P00=oo`?P0n003Goo00<3h7ooOol017oo0P?P00=oo`?P
0n003Goo00<3h7ooOol00goo0P?P0Woo0P?P3Goo00<3h7ooOol00goo0P?P00=oo`?P0n003Woo00<3
h7ooOol00goo0P?P00=oo`?P0n003Woo00<3h7ooOol02Goo000?Ool00`00Oomoo`08Ool20n05Ool0
0`?POomoo`02Ool00`?POomoo`0:Ool20n04Ool00`?POomoo`03Ool00`?POomoo`0:Ool20n04Ool0
0`?POomoo`02Ool00`?POomoo`0;Ool20n04Ool00`?POomoo`02Ool00`?POomoo`0;Ool20n04Ool0
0`?POomoo`02Ool00`?POomoo`0:Ool30n04Ool00`?POomoo`02Ool00`?POomoo`0:Ool20n05Ool0
0`?POomoo`02Ool00`?POomoo`0:Ool20n04Ool00`?POomoo`03Ool00`?POomoo`0:Ool20n04Ool0
0`?POomoo`02Ool00`?POomoo`0;Ool20n04Ool00`?POomoo`02Ool00`?POomoo`0;Ool20n0;Ool0
00moo`03001oogoo00Moo`040n1oogoo0n04Ool00`?POomoo`03Ool00`?POomoo`08Ool010?POomo
o`?P0goo00<3h7ooOol017oo00<3h7ooOol027oo00@3h7ooOol3h0=oo`030n1oogoo00=oo`030n1o
ogoo00Uoo`040n1oogoo0n03Ool00`?POomoo`03Ool00`?POomoo`09Ool010?POomoo`?P0goo00<3
h7ooOol00goo00<3h7ooOol027oo00D3h7ooOomoo`?P00=oo`030n1oogoo00=oo`030n1oogoo00Qo
o`040n1oogoo0n04Ool00`?POomoo`03Ool00`?POomoo`08Ool010?POomoo`?P0goo00<3h7ooOol0
17oo00<3h7ooOol027oo00@3h7ooOol3h0=oo`030n1oogoo00=oo`030n1oogoo00Uoo`040n1oogoo
0n03Ool00`?POomoo`03Ool00`?POomoo`09Ool010?POomoo`?P2Woo000?Ool00`00Oomoo`06Ool0
1@?POomoogoo0n000Woo0P?P1Woo00<3h7ooOol01goo00D3h7ooOomoo`?P009oo`030n1oogoo00Eo
o`030n1oogoo00Moo`050n1oogooOol3h002Ool00`?POomoo`04Ool00`?POomoo`08Ool01@?POomo
ogoo0n000Woo00<3h7ooOol017oo00<3h7ooOol027oo00D3h7ooOomoo`?P009oo`030n1oogoo00Ao
o`030n1oogoo00Moo`030n1oogoo009oo`040n1oogoo0n06Ool00`?POomoo`07Ool01@?POomoogoo
0n000Woo0P?P1Woo00<3h7ooOol01goo00D3h7ooOomoo`?P009oo`030n1oogoo00Eoo`030n1oogoo
00Moo`050n1oogooOol3h002Ool00`?POomoo`04Ool00`?POomoo`08Ool01@?POomoogoo0n000Woo
00<3h7ooOol017oo00<3h7ooOol027oo00D3h7ooOomoo`?P009oo`030n1oogoo00Eoo`003goo00<0
07ooOol01Woo00<3h7ooOol00Woo0P?P27oo00<3h7ooOol01goo00<3h7ooOol00Woo0P?P27oo00<3
h7ooOol01goo00<3h7ooOol00Woo0P?P1goo00<3h7ooOol027oo00<3h7ooOol00Woo0P?P1goo00<3
h7ooOol027oo00<3h7ooOol00Woo0P?P1goo00<3h7ooOol01goo00<3h7ooOol00goo0P?P1goo00<3
h7ooOol01goo00<3h7ooOol00Woo0P?P27oo00<3h7ooOol01goo00<3h7ooOol00Woo0P?P27oo00<3
h7ooOol01goo00<3h7ooOol00Woo0P?P1goo00<3h7ooOol027oo00<3h7ooOol00Woo0P?P1goo00<3
h7ooOol027oo00<3h7ooOol00Woo0P?P27oo0008Ool?00000`?P0000000>00000`?P000000050000
0`?P0000000>00000`?P0000000500000`?P0000000=00000`?P0000000600000`?P0000000=0000
0`?P0000000600000`?P0000000=00000`?P0000000500000`?P0000000>00000`?P000000050000
0`?P0000000>00000`?P0000000500000`?P0000000>00000`?P0000000500000`?P0000000=0000
0`?P0000000600000`?P0000000=00000`?P0000000600000`?P0000000=000000moo`03001oogoo
00Eoo`030n1oo`0000Yoo`05001oogooOol3h005Ool00`00Ool3h007Ool00`00Oomoo`06Ool00`?P
Ool00005Ool01@?POomoogoo00002Goo00<007oo0n0027oo00<3h7ooOol01goo00<007ooOol00goo
00D3h7ooOomoo`0000Aoo`030n1oogoo00=oo`03001oogoo00Moo`030n1oogoo00Eoo`030n1oo`00
00Yoo`05001oogooOol3h005Ool00`00Ool3h008Ool00`00Oomoo`05Ool00`?POol00005Ool01@?P
Oomoogoo00002Woo00<007oo0n001goo00<3h7ooOol01goo00<007ooOol00goo00<3h7ooOol00Woo
00D007ooOomoo`?P00Eoo`03001oogoo00Moo`030n1oogoo00Ioo`030n1oo`0000Uoo`03001oogoo
005oo`003goo00<007ooOol01Goo00<3h7ooOol03Woo00<3h7ooOol01Goo00<3h7ooOol01Goo00<0
07ooOol01Woo00<3h7ooOol01Goo00<3h7ooOol03Goo00<3h7ooOol01Woo00<3h7ooOol03Goo00<3
h7ooOol01Woo00<3h7ooOol03Goo00<3h7ooOol01Goo00<3h7ooOol03Woo00<3h7ooOol01Goo00<3
h7ooOol01Woo00<007ooOol01Goo00<3h7ooOol01Goo00<3h7ooOol03Woo00<3h7ooOol01Goo00<3
h7ooOol03Goo00<3h7ooOol01Woo00<3h7ooOol03Goo00<3h7ooOol01Woo00<3h7ooOol03Goo000?
Ool00`00Oomoo`04Ool00`?POomoo`0?Ool00`?POomoo`04Ool00`?POomoo`0?Ool00`?POomoo`04
Ool00`?POomoo`0?Ool00`?POomoo`04Ool00`?POomoo`0>Ool00`?POomoo`05Ool00`?POomoo`0>
Ool00`?POomoo`04Ool00`?POomoo`0?Ool00`?POomoo`04Ool00`?POomoo`0?Ool00`?POomoo`04
Ool00`?POomoo`0?Ool00`?POomoo`04Ool00`?POomoo`0?Ool00`?POomoo`04Ool00`?POomoo`0>
Ool00`?POomoo`05Ool00`?POomoo`0>Ool000moo`03001oogoo00Aoo`030n1oogoo011oo`030n1o
ogoo00=oo`030n1oogoo011oo`030n1oogoo00=oo`030n1oogoo00moo`030n1oogoo00Aoo`030n1o
ogoo00moo`030n1oogoo00Aoo`030n1oogoo00moo`030n1oogoo00=oo`030n1oogoo011oo`030n1o
ogoo00=oo`030n1oogoo011oo`030n1oogoo00=oo`030n1oogoo011oo`030n1oogoo00=oo`030n1o
ogoo00moo`030n1oogoo00Aoo`030n1oogoo00moo`030n1oogoo00Aoo`030n1oogoo00ioo`003goo
00<007ooOol00goo00<3h7ooOol04Goo00<3h7ooOol00Woo00<3h7ooOol04Goo00<3h7ooOol00Woo
00<3h7ooOol047oo00<3h7ooOol00goo00<3h7ooOol047oo00<3h7ooOol00goo00<3h7ooOol047oo
00<3h7ooOol00Woo00<3h7ooOol04Goo00<3h7ooOol00Woo00<3h7ooOol04Goo00<3h7ooOol00Woo
00<3h7ooOol04Goo00<3h7ooOol00Woo00<3h7ooOol047oo00<3h7ooOol00goo00<3h7ooOol047oo
00<3h7ooOol00goo00<3h7ooOol03goo000?Ool00`00Oomoo`03Ool00`?POomoo`0AOol00`?POomo
o`02Ool00`?POomoo`0AOol00`?POomoo`02Ool00`?POomoo`0@Ool00`?POomoo`03Ool00`?POomo
o`0@Ool00`?POomoo`03Ool00`?POomoo`0@Ool00`?POomoo`02Ool00`?POomoo`0AOol00`?POomo
o`02Ool00`?POomoo`0AOol00`?POomoo`02Ool00`?POomoo`0AOol00`?POomoo`02Ool00`?POomo
o`0@Ool00`?POomoo`03Ool00`?POomoo`0@Ool00`?POomoo`03Ool00`?POomoo`0?Ool000moo`80
00Aoo`030n1oogoo015oo`030n1oogoo009oo`030n1oogoo015oo`030n1oogoo009oo`030n1oogoo
015oo`030n1oogoo009oo`030n1oogoo011oo`030n1oogoo009oo`030n1oogoo015oo`030n1oogoo
009oo`030n1oogoo015oo`030n1oogoo009oo`030n1oogoo015oo`030n1oogoo009oo`030n1oogoo
015oo`030n1oogoo009oo`030n1oogoo015oo`030n1oogoo009oo`030n1oogoo011oo`030n1oogoo
009oo`030n1oogoo011oo`003goo00<007ooOol00Woo00<3h7ooOol04Woo00D3h7ooOomoo`?P01Ao
o`050n1oogooOol3h00DOol01@?POomoogoo0n004goo00<3h7ooOol00Woo00<3h7ooOol04Goo00D3
h7ooOomoo`?P01Aoo`050n1oogooOol3h00DOol01@?POomoogoo0n0057oo00D3h7ooOomoo`?P01Ao
o`050n1oogooOol3h00COol00`?POomoo`02Ool00`?POomoo`0@Ool000moo`03001oogoo009oo`03
0n1oogoo01=oo`040n1oogoo0n0EOol010?POomoo`?P57oo00D3h7ooOomoo`?P01Aoo`040n1oogoo
0n0EOol010?POomoo`?P5Goo00@3h7ooOol3h1Eoo`040n1oogoo0n0EOol010?POomoo`?P57oo00D3
h7ooOomoo`?P01Aoo`040n1oogoo0n0COol000moo`05001oogooOol3h00FOol00`?POol3h00FOol0
0`?POol3h00FOol00`?POol3h00EOol010?POomoo`?P5Goo00@3h7ooOol3h1Eoo`040n1oogoo0n0E
Ool010?POomoo`?P5Goo00@3h7ooOol3h1Eoo`040n1oogoo0n0DOol010?POomoo`?P4goo000?Ool0
0`00Ool3h0020n0FOol30n0FOol30n0FOol30n0EOol30n0FOol00`?POol3h00FOol00`?POol3h00F
Ool00`?POol3h00FOol00`?POol3h00FOol00`?POol3h00EOol30n0DOol000moo`03001oogoo07ao
o`83h1Moo`83h1Moo`83h1Moo`83h1Moo`83h2aoo`003goo0P00ogoo47oo000?Ool00`00Oomoo`3o
Ool?Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3o
Ool?Ool000moo`03001oogoo0?moo`moo`003goo0P00ogoo47oo000?Ool00`00Oomoo`3oOol?Ool0
00moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo0006Ool01Wlb00000000019Wo`=o
o`03001oogoo0?moo`moo`001goo00=IX00BIol01Goo00<007ooOol0ogoo3goo0008Ool00glb001;
?`04Ool3003oOol?Ool000Uoo`03OoUW?goo00=oo`03001oogoo0?moo`moo`001Woo00IoUSFfOomo
nDPBIol3Ool00`00Oomoo`3oOol?Ool000Moo`04L/d00000=]`4Ool00`00Oomoo`3oOol?Ool000mo
o`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000mo
o`800?mooa1oo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001o
ogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`800?mo
oa1oo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?mo
o`moo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`800?mooa1oo`00
3goo00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`00
27oo00Abc@0000eKW`=oo`03001oogoo0?moo`moo`002Goo00=o<SKLOol00goo00<007ooOol0ogoo
3goo0006Ool01WoiB000000000eKW`=oo`<00?moo`moo`001goo00AV@4/oOc8fg0Aoo`03001oogoo
0?moo`moo`001goo00AonDP=F]8fg0Aoo`03001oogoo0?moo`moo`0027oo00=oUS@0=]`017oo00<0
07ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<0
07ooOol0ogoo3goo000?Ool2003oOol@Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0
ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0
ogoo3goo000?Ool2003oOol@Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo
000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo
000?Ool2003oOol@Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000?Ool0
0`00Oomoo`3oOol?Ool000Moo`05OoU8000000eKW`03Ool00`00Oomoo`3oOol?Ool000Moo`05IT1;
?gooOoUW?`03Ool00`00Oomoo`3oOol?Ool000Ioo`06OoU803KLOombcD/o0goo0`00ogoo3goo0007
Ool015Vb=J00006f17oo00<007ooOol0ogoo3goo0007Ool00glb0KIoo`05Ool00`00Oomoo`3oOol?
Ool000Qoo`04L/d00000Bcl3Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo
00<007ooOol0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`800?mooa1oo`003goo00<007oo
Ool0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<007oo
Ool0ogoo3goo000?Ool00`00Oomoo`3oOol?Ool000moo`800?mooa1oo`003goo00<007ooOol0ogoo
3goo000?Ool00`00Oomoo`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<007oo01l02Goo
00=l07ooOol0ogoo0goo000?Ool00`00Oomoo`0201l5Ool3O03oOol5Ool000moo`8000=oo`807`9o
o`05O01oogooOoml0005Ool00g`0Oomoo`3kOol000moo`03001oogoo00Aoo`807`Aoo`03O01oogoo
009oo`04O01oog`0O03kOol000moo`03001oogoo00Aoo`04O01oo`0O01l2Ool00g`0Oomoo`02Ool0
1G`0OomoogooO000nWoo000?Ool00`00Oomoo`03Ool00g`0Oomoo`02Ool201l00gooO01oo`02O005
Ool00g`0Oomoo`3gOol000Moo`04IT000000=]`4Ool00`00Oomoo`03Ool00g`0Oomoo`04Ool501l5
Ool00g`0Oomoo`3gOol000Ioo`05OoU:FGooOomJEP04Ool00`00Oomoo`02Ool00g`0Oomoo`0:Ool2
01l4Ool00g`0Oomoo`3fOol000Moo`04FUIoogoiBUT4Ool30002Ool00g`0Oomoo`0<Ool201l2Ool0
0g`0Oomoo`3fOol000Moo`04IT000000=]`4Ool00`00Oomoo`02Ool00g`0Oomoo`0>Ool201l00goo
O01oo`3fOol000Ioo`05OoU9]WooOoU9]P04Ool01@00OomoogooO0004goo0P0Omgoo0007Ool017;=
000004/o17oo00D007ooOomoog`001Aoo`03O0007goo0?Eoo`003goo00@007ooO01l01Eoo`03O01o
o`0O0?Eoo`003goo00<007ooOol05goo00Al07oo01l07`Eoo`03O01oogoo0>]oo`003goo00<007oo
Ool05goo00El07ooOomoo`0O00=oo`03O01oog`00>aoo`003goo0P0067oo00=l07ooOol00Woo00@0
7gooOoml009oo`03O01oogoo0>Uoo`003goo00<007ooOol05goo00=l07ooOol00goo0P0O0goo00=l
07ooOol0jGoo000?Ool00`00Oomoo`0GOol00g`0Oomoo`02Ool2O0000goo01moo`02Ool00g`0Oomo
o`3XOol000moo`03001oogoo01Moo`05O01oogooOoml0004Ool0100OOomoog`0jWoo000?Ool00`00
Oomoo`0HOol017`0Oomoog`01Goo00<07gooO000jWoo000?Ool00`00Oomoo`0HOol00g`0Ooml0007
Ool00`0OO01oo`03Ool00g`0Oomoo`0HOol3O02BOol3O00>Ool00g`0Oomoo`0ROol000moo`8001Uo
o`=l00Qoo`0601ml07ooOoml07oo0W`05goo00Al07ooOoml00aoo`=l085oo`9l009oo`03O01oogoo
00Yoo`=l00Eoo`=l01aoo`003goo00<007ooOol097oo00<07g`0O00017oo00=l07ooOol04goo00=l
07ooOol00Woo00=l07ooOol02Goo00=l07ooO000Ngoo00=l07ooOol00Woo00=l07ooOol00goo00=l
07ooOol02Goo00Al07ooOoml00=oo`05O01oogooOoml000KOol000moo`03001oogoo02Eoo`807`Eo
o`03O01oogoo015oo`03O01oogoo00=oo`03O01oogoo00Qoo`05O01oogooOoml001iOol00g`0Ooml
0003Ool00g`0Oomoo`03Ool00g`0Oomoo`08Ool01G`0OomoogooO0000goo00El07ooOomoog`001]o
o`003goo00<007ooOol09goo00<07gooOol00goo00=l07ooOol047oo00=l07ooOol017oo00=l07oo
Ool01goo00El07ooOomoog`000Aoo`=l079oo`03O01oog`0009oo`03O01oogoo00Eoo`03O01oogoo
009oo`0301moogoo009oo`03O01oogoo009oo`=l00Eoo`03O01oogoo01Qoo`003goo00<007ooOol0
:7oo0P0O0goo00=l07ooOol02goo00El07ooOomoog`000Moo``07`=oo`04O01oog`0O003Ool2O01_
Ool017`0Oomoogoo0g`01Goo1`0O00=oo`0O01l0200O1goo00=l07ooOol067oo000?Ool00`00Oomo
o`0ZOol201l2Ool00g`0Oomoo`09Ool2O003Ool017`0Oomoogoo100O00=oog`0Ool01Woo00=l07oo
Ool00P0O00=oog`0O0001Woo00=l07ooOol0KGoo00=l07ooOol01Goo100O0Woo00=l07ooOol01Woo
00=l07ooOol017oo100O17oo00=l07ooOol05goo000?Ool2000]Ool201l00g`0Oomoo`08Ool01W`0
Oomoog`0Ooml009oo`807`Eoo`03O01oogoo00Aoo`03O01oogoo00=oo`807`Qoo`03O01oogoo06]o
o`03O01oogoo00Aoo`807`Moo`03O01oogoo00Eoo`03O01oogoo00Qoo`@07`03O01oogoo00Uoo`=l
00]oo`003goo00<007ooOol0;Woo0P0O2Goo00Al07ooOoml00@07`Moo`03O01oogoo00Aoo`03O01o
ogoo00Eoo`807`Ioo`03O01oogoo06]oo`03O01oogoo009oo`807`Uoo`03O01oogoo00Aoo`03O01o
ogoo00eoo`L07`Aoo`05O01oogooOoml000:Ool000moo`03001oogoo02moo`03O0007`0O00@07`9o
o`03O0007`0O00807`03O01oogoo00Qoo`03O01oogoo00=oo`03O01oogoo00Qoo`807`Aoo`03O01o
ogoo06]oo`03O01oogoo00807`]oo`03O01oogoo00Aoo`03O01oogoo00ioo`03O01oogoo00=oo`80
7`9oo`05O01oogooOoml0002Ool00g`0Oomoo`05Ool000moo`03001oogoo02moo`03O01oogoo00Ao
o`<07a1oo`03O01oogoo009oo`03O01oogoo00Yoo`807`9oo`03O01oogoo06Yoo`04O01oo`0O01l>
Ool00g`0Oomoo`02Ool00g`0Oomoo`0?Ool00g`0Oomoo`05Ool401l3Ool2O008Ool000moo`03001o
ogoo02moo`03O01oogoo00Eoo`03O01oogoo00moo`05O01oogooOoml000?Ool201l00gooO01oo`1Z
Ool201l@Ool00g`0Oomoo`02Ool00g`0Oomoo`0?Ool00g`0Oomoo`05Ool017`0Oomoogoo100O2Goo
000027oiB000000000eKWgooL/d200000cKLOomoo`02Ool00`00Oomoo`0`Ool00g`0Oomoo`04Ool0
0g`0Oomoo`0?Ool01G`0OomoogooO0004Goo0P0O37oo00=l07ooOol0D7oo00=l07ooOol01goo0P0O
00=l07ooOol03goo00El07ooOomoog`001=oo`03O01oogoo00Aoo`03O01oogoo00Eoo`807`Moo`00
0Woo00=o<SKLOol00Woo00EJEWooOomI/VOo00=oo`03001oogoo031oo`03O01oogoo00=oo`03O01o
ogoo015oo`03O01oog`001=oo`03O0007`0O00Uoo`9l055oo`03O01oog`000Moo`0401moogooO00B
Ool017`0Oomoog`04goo00=l07ooOol00goo00=l07ooOol03goo0002Ool01Wlb=]aoogooOoU9]P9o
o`03ITeKWgoo009oo`<0031oo`03O01oogoo00=oo`03O01oogoo015oo`=l01=oo`03O01oogoo00<0
7`Eoo`04O01oogooO01?Ool01G`0OomoogooO0001Goo00@07gooOoml01=oo`03O01oog`001Aoo`03
O01oogoo00=oo`03O01oogoo00moo`000Woo00Io<SKLOomoogoiBKH2Ool00fI=Fimoo`02Ool00`00
Oomoo`0`Ool00g`0Oomoo`02Ool00g`0Oomoo`0XOol00g`0Oomoo`03Ool201l3Ool017`0Oomoog`0
17oo0g`0<Goo00=l07ooOol03Goo00=l07ooOol00goo00=l07ooOol00goo00=l07ooOol00P0O0goo
00=l07ooOol04Woo0W`057oo00=l07ooOol00Woo00=l07ooOol047oo000017ooFK9W<SKL0goo00EI
[E^OOoU84VOo00=oo`03001oogoo031oo`03O01oogoo009oo`03O01oogoo02Uoo`03O01oogoo00Ao
o`807`03O01oogoo009oo`Al00=oo`03O01oogoo02eoo`04O01oog`0O00;Ool2O0000gooO01oo`02
Ool00g`0Oomoo`04Ool00g`001l07`05Ool00g`0Oomoo`0XOol00g`0Oomoo`02Ool00g`0Oomoo`0@
Ool00004Oomo<P00=]`3Ool017nF=00004/o17oo00<007ooOol0<7oo00El07ooOomoog`002aoo`03
O01oogoo00Ioo`807`]oo`03O01oogoo02]oo`05O01oogooOoml000;Ool017`0Oomoogoo0g`01Woo
0P0O00=l07ooOol017oo00=l07ooOol0:Goo00Al07ooOoml01=oo`003goo00<007ooOol0<Goo00Al
07ooOoml02aoo`03O01oogoo00Eoo`03O01oogoo00807`Uoo`03O01oogoo02Yoo`03O01oogoo009o
o`03O01oogoo00Qoo`03O01oogoo00Ioo`D07`9oo`03O01oogoo00Aoo`03O01oogoo02Uoo`04O01o
ogooO00COol000moo`03001oogoo035oo`03O01oog`002eoo`03O01oogoo00Eoo`03O01oogoo009o
o`807`Qoo`03O01oogoo02Uoo`03O01oogoo00=oo`03O01oogoo00Moo`03O01oogoo00Aoo`807`Mo
o`03O01oogoo00=oo`03O01oogoo02Yoo`=l01Aoo`003goo0P00<Woo0g`0;Goo00=l07ooOol01Goo
00=l07ooOol017oo0P0O1Woo00=l07ooOol08goo00=l07ooOol00Woo00=l07ooOol017oo00=l07oo
Ool01goo00=l000O01l0100O2Woo00=l07ooOol00Woo00=l07ooOol0@Goo000?Ool00`00Oomoo`1Q
Ool00g`0Oomoo`04Ool00g`0Oomoo`07Ool201l4Ool00g`0Oomoo`0SOol2O002Ool2O006Ool00g`0
Oomoo`02Ool601l@Ool00g`0Oomoo`02Ool00g`0Oomoo`11Ool000moo`03001oogoo069oo`03O01o
ogoo00=oo`03O01oogoo00Uoo`807`9oo`03O01oogoo029oo`03O01oogoo009l00Qoo`03O0007`0O
00807`Aoo`03O01oogoo00moo`05O01oogooOoml0014Ool000moo`03001oogoo069oo`03O01oogoo
009oo`03O01oogoo00aoo`0401moogooO00SOol00g`0Oomoo`07Ool401l00g`0Oomoo`05Ool00g`0
Oomoo`0?Ool01G`0OomoogooO000A7oo000?Ool00`00Oomoo`1ROol00g`0Oomoo`02Ool00g`0Oomo
o`0=Ool00`0OOoml000ROol00g`0Oomoo`06Ool201l4Ool00g`0Oomoo`04Ool00g`0Oomoo`0AOol0
0g`0Ooml0015Ool000moo`03001oogoo06=oo`04O01oogooO00AOol201lROol00g`0Oomoo`03Ool3
01l6Ool00g`0Oomoo`04Ool00g`0Oomoo`0AOol00g`0Ooml0015Ool000moo`8006Aoo`03O01oog`0
01=oo`03O0007`0O00Uoo`9l01Eoo`04O01oogooOol201l9Ool00g`0Oomoo`03Ool00g`0Oomoo`0B
Ool2O016Ool000moo`03001oogoo06Aoo`03O01oogoo019oo`04O01oogoo01l6Ool2O0000gooO01o
o`0COol01G`0Oomoogoo01l037oo00=l07ooOol00Woo00=l07ooOol0FWoo000?Ool00`00Oomoo`1i
Ool01G`0Oomoogoo01l017oo00=l07ooOol00Woo00=l07ooOol04Goo00Al07ooOol07`eoo`03O01o
ogoo009oo`03O01oogoo05Yoo`003goo00<007ooOol0NWoo00Al07ooOomoo`807`9oo`03O01oogoo
009oo`03O01oogoo009oo`=l00aoo`03O0007`0O00ioo`05O01oogooOoml001MOol000moo`03001o
ogoo07Yoo`03O01oogoo00=oo`807`Ioo`04O01oogooO003Ool2O009Ool201l@Ool01G`0Oomoogoo
O000GGoo000?Ool00`00Oomoo`1jOol00g`0Oomoo`04Ool017`001l07`0O0goo0g`01Goo00=l07oo
Ool01Goo0P0O00=l07ooOol047oo00Al07ooOoml05eoo`003goo0P00Ngoo00=l07ooOol00goo00=l
07ooOol00Woo0P0O2Woo00=l07ooOol00Woo0P0O0Woo00=l07ooOol047oo00Al07ooOoml05eoo`00
3goo00<007ooOol0NWoo00=l07ooOol00goo00=l07ooOol017oo100O1Woo00=l07ooOol00P0O17oo
00=l07ooOol04Goo0W`0GWoo000?Ool00`00Oomoo`1jOol00g`0Oomoo`02Ool00g`0Oomoo`09Ool9
01l5Ool00g`0Oomoo`0COol00g`0Oomoo`1LOol000moo`03001oogoo07Yoo`03O01oogoo009oo`03
O01oogoo011oo`03O01oogoo00Aoo`03O01oogoo079oo`003goo00<007ooOol0NWoo00=l07ooOol0
0Woo00=l07ooOol047oo00=l07ooOol017oo00=l07ooOol0LWoo00001goiB000000000eKWglb00<0
0003019Wogoo009oo`03001oogoo07]oo`04O01oogooO00COol00g`0Oomoo`04Ool00g`0Oomoo`1b
Ool0009oo`03Oc8fg7oo009oo`03FJ004VOo00Eoo`03001oogoo07]oo`04O01oogooO00COol00g`0
Oomoo`03Ool00g`0Oomoo`1cOol0009oo`03Oc8fg7oo00=oo`03Oc8004/o00Aoo`<007]oo`04O01o
ogooO00DOol00g`0Oomoo`02Ool00g`0Oomoo`1cOol0009oo`03Oc8fg7oo00Aoo`03OoUW?goo00=o
o`03001oogoo07]oo`03O01oog`001Eoo`03O01oogoo009oo`03O01oogoo07=oo`0000AooeVbIc8f
g09oo`06OiHe]WooOoU84VOo0goo00<007ooOol0Ngoo0g`05Goo00=l07ooOol00Woo00=l07ooOol0
Lgoo000017ooOc8003KL0goo00Abc@00000fg0Aoo`03001oogoo09=oo`05O01oogooOoml001fOol0
00moo`03001oogoo09=oo`05O01oogooOoml001fOol000moo`03001oogoo09Aoo`04O01oogooO01f
Ool000moo`8009Eoo`03O01oog`007Moo`003goo00<007ooOol0U7oo0g`0Mgoo000?Ool00`00Oomo
o`3oOol?Ool000moo`03001oogoo0?moo`moo`003goo00<007ooOol0ogoo3goo000?Ool00`00Oomo
o`3oOol?Ool00?moob5oo`00\
\>"],
  ImageRangeCache->{{{54.375, 341.375}, {679.875, 502.938}} -> {-33.7533, \
39.0878, 0.483204, 0.0799164}},
  CellTags->"b:0"],

Cell[BoxData[
    InterpretationBox[\("Smoothing parameters: \[Alpha] = \
"\[InvisibleSpace]100\[InvisibleSpace]",  \[Gamma] = "\[InvisibleSpace]100\),
      SequenceForm[ 
      "Smoothing parameters: \[Alpha] = ", 100, ",  \[Gamma] = ", 100],
      Editable->False]], "Print",
  CellTags->"b:0"],

Cell[BoxData[
    InterpretationBox[\("Implied variances: \!\(\[Sigma]\_u\^2\) = "\
\[InvisibleSpace]0.020494753549535956`\[InvisibleSpace]", \
\!\(\[Sigma]\_v\^2\) = "\[InvisibleSpace]0.00020494753549535956`\
\[InvisibleSpace]", \!\(\[Sigma]\_w\^2\) = \
"\[InvisibleSpace]0.00020494753549535956`\),
      SequenceForm[ 
      "Implied variances: \!\(\[Sigma]\_u\^2\) = ", .020494753549535956, 
        ", \!\(\[Sigma]\_v\^2\) = ", .00020494753549535956, 
        ", \!\(\[Sigma]\_w\^2\) = ", .00020494753549535956],
      Editable->False]], "Print",
  CellTags->"b:0"]
}, Open  ]],

Cell[TextData[{
  "If Season is called without smoothing parameters, it computes the optimum \
smoothing parameters by a maximum-likelihood method and returns the list  \
{{",
  StyleBox["x,y,z,u",
    FontSlant->"Italic"],
  "},{\[Alpha],\[Gamma]},",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^2\)]],
  "}."
}], "MathCaption",
  CellTags->"b:0"],

Cell[BoxData[
    \(\({{x, y, z, u}, {a, g}, var} = Season[x, 12];\)\)], "Input",
  CellTags->"b:0"],

Cell[TextData[{
  "Here is a plot of the original time series ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "(red), the trend ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "(blue), and the seasonal component ",
  StyleBox["z ",
    FontSlant->"Italic"],
  "(green). It can be seen that the smoothing parameters are estimated \
smaller than the parameters used in the previous example. In particular, the \
parameter \[Alpha] for the trend is estimated as being quite small, entailing \
a rougher trend."
}], "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    \(\(MultipleListPlot[x, y, z\ , PlotJoined \[Rule] True, 
        PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                1]}, {RGBColor[0, 1, 0]}}, 
        SymbolShape \[Rule] None];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<Smoothing parameters: \[Alpha] = \>", 
        a, "\<,  \[Gamma] = \>", g];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<Estimated variances: \!\(\[Sigma]\_u\^2\) = \>\"", \ 
        varU, \ \*"\"\<, \!\(\[Sigma]\_v\^2\) = \>\"", 
        varU/a, \*"\"\<, \!\(\[Sigma]\_w\^2\) = \>\"", varU/g];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00744048 0.0377255 0.0448884 [
[.17262 .02523 -6 -9 ]
[.17262 .02523 6 0 ]
[.32143 .02523 -6 -9 ]
[.32143 .02523 6 0 ]
[.47024 .02523 -6 -9 ]
[.47024 .02523 6 0 ]
[.61905 .02523 -6 -9 ]
[.61905 .02523 6 0 ]
[.76786 .02523 -9 -9 ]
[.76786 .02523 9 0 ]
[.91667 .02523 -9 -9 ]
[.91667 .02523 9 0 ]
[.01131 .1275 -6 -4.5 ]
[.01131 .1275 0 4.5 ]
[.01131 .21728 -6 -4.5 ]
[.01131 .21728 0 4.5 ]
[.01131 .30706 -6 -4.5 ]
[.01131 .30706 0 4.5 ]
[.01131 .39683 -6 -4.5 ]
[.01131 .39683 0 4.5 ]
[.01131 .48661 -12 -4.5 ]
[.01131 .48661 0 4.5 ]
[.01131 .57639 -12 -4.5 ]
[.01131 .57639 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17262 .03773 m
.17262 .04398 L
s
[(20)] .17262 .02523 0 1 Mshowa
.32143 .03773 m
.32143 .04398 L
s
[(40)] .32143 .02523 0 1 Mshowa
.47024 .03773 m
.47024 .04398 L
s
[(60)] .47024 .02523 0 1 Mshowa
.61905 .03773 m
.61905 .04398 L
s
[(80)] .61905 .02523 0 1 Mshowa
.76786 .03773 m
.76786 .04398 L
s
[(100)] .76786 .02523 0 1 Mshowa
.91667 .03773 m
.91667 .04398 L
s
[(120)] .91667 .02523 0 1 Mshowa
.125 Mabswid
.06101 .03773 m
.06101 .04148 L
s
.09821 .03773 m
.09821 .04148 L
s
.13542 .03773 m
.13542 .04148 L
s
.20982 .03773 m
.20982 .04148 L
s
.24702 .03773 m
.24702 .04148 L
s
.28423 .03773 m
.28423 .04148 L
s
.35863 .03773 m
.35863 .04148 L
s
.39583 .03773 m
.39583 .04148 L
s
.43304 .03773 m
.43304 .04148 L
s
.50744 .03773 m
.50744 .04148 L
s
.54464 .03773 m
.54464 .04148 L
s
.58185 .03773 m
.58185 .04148 L
s
.65625 .03773 m
.65625 .04148 L
s
.69345 .03773 m
.69345 .04148 L
s
.73065 .03773 m
.73065 .04148 L
s
.80506 .03773 m
.80506 .04148 L
s
.84226 .03773 m
.84226 .04148 L
s
.87946 .03773 m
.87946 .04148 L
s
.95387 .03773 m
.95387 .04148 L
s
.99107 .03773 m
.99107 .04148 L
s
.25 Mabswid
0 .03773 m
1 .03773 L
s
.02381 .1275 m
.03006 .1275 L
s
[(2)] .01131 .1275 1 0 Mshowa
.02381 .21728 m
.03006 .21728 L
s
[(4)] .01131 .21728 1 0 Mshowa
.02381 .30706 m
.03006 .30706 L
s
[(6)] .01131 .30706 1 0 Mshowa
.02381 .39683 m
.03006 .39683 L
s
[(8)] .01131 .39683 1 0 Mshowa
.02381 .48661 m
.03006 .48661 L
s
[(10)] .01131 .48661 1 0 Mshowa
.02381 .57639 m
.03006 .57639 L
s
[(12)] .01131 .57639 1 0 Mshowa
.125 Mabswid
.02381 .06017 m
.02756 .06017 L
s
.02381 .08261 m
.02756 .08261 L
s
.02381 .10506 m
.02756 .10506 L
s
.02381 .14995 m
.02756 .14995 L
s
.02381 .17239 m
.02756 .17239 L
s
.02381 .19483 m
.02756 .19483 L
s
.02381 .23972 m
.02756 .23972 L
s
.02381 .26217 m
.02756 .26217 L
s
.02381 .28461 m
.02756 .28461 L
s
.02381 .3295 m
.02756 .3295 L
s
.02381 .35194 m
.02756 .35194 L
s
.02381 .37439 m
.02756 .37439 L
s
.02381 .41928 m
.02756 .41928 L
s
.02381 .44172 m
.02756 .44172 L
s
.02381 .46416 m
.02756 .46416 L
s
.02381 .50905 m
.02756 .50905 L
s
.02381 .5315 m
.02756 .5315 L
s
.02381 .55394 m
.02756 .55394 L
s
.02381 .01528 m
.02756 .01528 L
s
.02381 .59883 m
.02756 .59883 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.001 w
.03125 .4103 m
.03869 .40581 L
.04613 .38337 L
.05357 .37888 L
.06101 .3699 L
.06845 .36541 L
.07589 .38785 L
.08333 .38337 L
.09077 .37439 L
.09821 .37888 L
.10565 .38337 L
.1131 .40132 L
.12054 .44172 L
.12798 .44172 L
.13542 .42825 L
.14286 .42377 L
.1503 .41479 L
.15774 .41928 L
.16518 .44621 L
.17262 .44621 L
.18006 .43723 L
.1875 .44621 L
.19494 .4507 L
.20238 .46865 L
.20982 .50905 L
.21726 .50905 L
.2247 .4911 L
.23214 .48212 L
.23958 .46416 L
.24702 .45519 L
.25446 .46865 L
.2619 .45968 L
.26935 .44621 L
.27679 .43723 L
.28423 .43723 L
.29167 .4507 L
.29911 .48661 L
.30655 .48661 L
.31399 .46865 L
.32143 .45968 L
.32887 .44172 L
.33631 .44172 L
.34375 .45968 L
.35119 .45519 L
.35863 .4507 L
.36607 .4507 L
.37351 .45519 L
.38095 .48212 L
.38839 .52252 L
.39583 .53599 L
Mistroke
.40327 .52252 L
.41071 .50456 L
.41815 .48661 L
.4256 .48212 L
.43304 .49559 L
.44048 .49559 L
.44792 .4911 L
.45536 .4911 L
.4628 .50008 L
.47024 .52252 L
.47768 .58536 L
.48512 .58536 L
.49256 .56292 L
.5 .54496 L
.50744 .53599 L
.51488 .5315 L
.52232 .54945 L
.52976 .54945 L
.5372 .54048 L
.54464 .54048 L
.55208 .54496 L
.55952 .56741 L
.56696 .60332 L
.5744 .60332 L
.58185 .58087 L
.58929 .54945 L
.59673 .52701 L
.60417 .50905 L
.61161 .51803 L
.61905 .51354 L
.62649 .50008 L
.63393 .4911 L
.64137 .49559 L
.64881 .52701 L
.65625 .55394 L
.66369 .55843 L
.67113 .53599 L
.67857 .51803 L
.68601 .49559 L
.69345 .4911 L
.70089 .50008 L
.70833 .50008 L
.71577 .4911 L
.72321 .48212 L
.73065 .48661 L
.7381 .50008 L
.74554 .5315 L
.75298 .52701 L
.76042 .51354 L
.76786 .47763 L
Mistroke
.7753 .45519 L
.78274 .44621 L
.79018 .45519 L
.79762 .45519 L
.80506 .44172 L
.8125 .43723 L
.81994 .43723 L
.82738 .45519 L
.83482 .48661 L
.84226 .4911 L
.8497 .47763 L
.85714 .46416 L
.86458 .44172 L
.87202 .43723 L
.87946 .4507 L
.8869 .4507 L
.89435 .44172 L
.90179 .44172 L
.90923 .4507 L
.91667 .46865 L
.92411 .50456 L
.93155 .50456 L
.93899 .48661 L
.94643 .47314 L
.95387 .46416 L
.96131 .46416 L
.96875 .47314 L
.97619 .46865 L
Mfstroke
0 0 1 r
.03125 .36889 m
.03869 .3691 L
.04613 .37061 L
.05357 .37458 L
.06101 .37978 L
.06845 .38452 L
.07589 .38875 L
.08333 .3922 L
.09077 .39516 L
.09821 .39769 L
.10565 .39953 L
.1131 .40087 L
.12054 .40261 L
.12798 .40597 L
.13542 .41169 L
.14286 .41916 L
.1503 .42804 L
.15774 .43776 L
.16518 .44677 L
.17262 .45393 L
.18006 .45945 L
.1875 .46428 L
.19494 .46731 L
.20238 .46898 L
.20982 .47034 L
.21726 .47201 L
.2247 .47412 L
.23214 .47594 L
.23958 .47614 L
.24702 .47454 L
.25446 .47183 L
.2619 .46831 L
.26935 .46401 L
.27679 .45895 L
.28423 .45445 L
.29167 .45064 L
.29911 .44831 L
.30655 .44816 L
.31399 .4501 L
.32143 .45331 L
.32887 .45642 L
.33631 .45983 L
.34375 .46274 L
.35119 .46526 L
.35863 .46828 L
.36607 .47153 L
.37351 .47541 L
.38095 .48067 L
.38839 .48658 L
.39583 .4937 L
Mistroke
.40327 .49896 L
.41071 .50093 L
.41815 .50113 L
.4256 .5012 L
.43304 .50192 L
.44048 .50435 L
.44792 .50826 L
.45536 .51323 L
.4628 .51975 L
.47024 .52793 L
.47768 .53731 L
.48512 .54202 L
.49256 .54353 L
.5 .5452 L
.50744 .54832 L
.51488 .55156 L
.52232 .55471 L
.52976 .5574 L
.5372 .55982 L
.54464 .56239 L
.55208 .56431 L
.55952 .56516 L
.56696 .56425 L
.5744 .56145 L
.58185 .55612 L
.58929 .54821 L
.59673 .53968 L
.60417 .53134 L
.61161 .52507 L
.61905 .52062 L
.62649 .51747 L
.63393 .51589 L
.64137 .51661 L
.64881 .51838 L
.65625 .51775 L
.66369 .51654 L
.67113 .51463 L
.67857 .51318 L
.68601 .5113 L
.69345 .50997 L
.70089 .5088 L
.70833 .50823 L
.71577 .50747 L
.72321 .50549 L
.73065 .50261 L
.7381 .49836 L
.74554 .49395 L
.75298 .48926 L
.76042 .48419 L
.76786 .47687 L
Mistroke
.7753 .47061 L
.78274 .46619 L
.79018 .46356 L
.79762 .46198 L
.80506 .46004 L
.8125 .45766 L
.81994 .45464 L
.82738 .45227 L
.83482 .45128 L
.84226 .45246 L
.8497 .45474 L
.85714 .45675 L
.86458 .45688 L
.87202 .45701 L
.87946 .45797 L
.8869 .45941 L
.89435 .46124 L
.90179 .4635 L
.90923 .46536 L
.91667 .466 L
.92411 .46607 L
.93155 .46602 L
.93899 .46729 L
.94643 .47105 L
.95387 .47601 L
.96131 .47944 L
.96875 .48023 L
.97619 .47958 L
Mfstroke
0 1 0 r
.03125 .07793 m
.03869 .07455 L
.04613 .05273 L
.05357 .0424 L
.06101 .02636 L
.06845 .01881 L
.07589 .0363 L
.08333 .02913 L
.09077 .01723 L
.09821 .01849 L
.10565 .02093 L
.1131 .03786 L
.12054 .07729 L
.12798 .07471 L
.13542 .05405 L
.14286 .04254 L
.1503 .02539 L
.15774 .01885 L
.16518 .03593 L
.17262 .0293 L
.18006 .01744 L
.1875 .01819 L
.19494 .02059 L
.20238 .03777 L
.20982 .07689 L
.21726 .07555 L
.2247 .05527 L
.23214 .04283 L
.23958 .02495 L
.24702 .01871 L
.25446 .03484 L
.2619 .02904 L
.26935 .01878 L
.27679 .01708 L
.28423 .01991 L
.29167 .03787 L
.29911 .07674 L
.30655 .07686 L
.31399 .05678 L
.32143 .04245 L
.32887 .02414 L
.33631 .01878 L
.34375 .03391 L
.35119 .02876 L
.35863 .01949 L
.36607 .01659 L
.37351 .01887 L
.38095 .03797 L
.38839 .07704 L
.39583 .07847 L
Mistroke
.40327 .05859 L
.41071 .04122 L
.41815 .02402 L
.4256 .01838 L
.43304 .0326 L
.44048 .02911 L
.44792 .01974 L
.45536 .01594 L
.4628 .01858 L
.47024 .03731 L
.47768 .07903 L
.48512 .07928 L
.49256 .05905 L
.5 .03992 L
.50744 .02434 L
.51488 .01783 L
.52232 .03194 L
.52976 .02958 L
.5372 .01951 L
.54464 .01543 L
.55208 .01864 L
.55952 .03948 L
.56696 .07723 L
.5744 .0791 L
.58185 .06058 L
.58929 .04007 L
.59673 .02405 L
.60417 .01739 L
.61161 .03095 L
.61905 .02992 L
.62649 .01993 L
.63393 .01472 L
.64137 .01878 L
.64881 .04148 L
.65625 .07569 L
.66369 .07845 L
.67113 .06097 L
.67857 .04087 L
.68601 .02325 L
.69345 .0181 L
.70089 .03014 L
.70833 .02978 L
.71577 .02012 L
.72321 .01509 L
.73065 .02014 L
.7381 .04071 L
.74554 .07522 L
.75298 .07713 L
.76042 .06229 L
.76786 .04079 L
Mistroke
.7753 .0231 L
.78274 .01837 L
.79018 .02998 L
.79762 .02968 L
.80506 .01954 L
.8125 .01592 L
.81994 .02081 L
.82738 .04062 L
.83482 .07475 L
.84226 .07665 L
.8497 .06081 L
.85714 .04195 L
.86458 .02353 L
.87202 .01903 L
.87946 .0302 L
.8869 .0289 L
.89435 .01902 L
.90179 .01595 L
.90923 .02168 L
.91667 .04058 L
.92411 .0753 L
.93155 .0765 L
.93899 .05934 L
.94643 .04113 L
.95387 .02438 L
.96131 .02032 L
.96875 .0304 L
.97619 .02813 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00<P3oool0203oe9/00000000000000000002K0=Coo`3oool0j[Yb0P00
00000`1b^^X0oooo0?ooo`0O0?ooo`060>ZjLP000000001b0;[Zo`3oool0j[Yb0P0000000`1b^^X0
oooo0?ooo`0M0?ooo`070?ooe02K000000000000LP2jj_l0oooo0>ZjLP020000000307:jjP3oool0
oooo01h0oooo00@0e9/0000000000000L[[Z0P3oool0103Z^W8000000000001b^^XK0?ooo`080?oo
e02K00000000000000000780^^[o0?ooo`3Z^W820000000407:jjP3oool0oooo0>ZjLP80000000<0
L[[Z0?ooo`3oool05P3oool01`3oom@0V`00000000000000001b0;[Zo`3oe9/00`000000100009/0
e?oo0?ooo`3Z^W820000000307:jjP3oool0oooo00l0oooo000?0?ooo`030000003oool0oooo0240
oooo00<0^W800000V`3Dool00`3oool01@2jVkX0oooo0?ooo`2jLY/0e?oo0240oooo00D0omBK07:j
jP3oool0oooo0;ZK^P020?ooo`030;YbV`3Dool0oooo01d0oooo00L0e9/009_Do`3oool0oooD0=CD
o`3oool0^Y^j0080oooo00<0^W:K0=Coo`3oool07@3oool01@3oom@0Vi_D0?ooo`3oool0^Y^j0080
oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`0L0?ooo`030?oDV`1b^^X0oooo0080oooo00L0^Y^j0?oo
o`3oool0^W:K0=Coo`3oool0^Y^j0080oooo00<0^W:K0=Coo`3oool0603oool00`3oe9/0L[[Z0?oo
o`020?ooo`030;Yb000009/0e?oo00<0oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`0@0?ooo`003`3o
ool00`000000oooo0?ooo`0R0?ooo`060?oDV`000000VmCo0?ooo`3oom@0Vg:j0P3oool00`3DVg80
^^[o0?ooo`0M0?ooo`080?ooe02K00000000000000000780^^[o0?ooe02KL[X20?ooo`030=BKLP2j
j_l0oooo01`0oooo00P0oooD09/0001b^^X0oooo0>ZjLP2Ke?l0oooD09]b^P80oooo00<0e9]b0;[Z
o`3oool07P3oool01`2jVkX0oooo0?ooe02KVm@0oooo0?ooe02KL[X00P3oool00`3DVg80^^[o0?oo
o`0K0?ooo`060?oDV`1b^^X0oooo0?ooo`3oom@0Vg:j0P3oool0103DVg80^^[o0?ooe02KL[X20?oo
o`030=BKLP2jj_l0oooo01P0oooo00<0omBK07:jjP3oool00`3oool01P3oe9/0000009_Do`3oool0
oooD09]b^P80oooo00<0e9]b0;[Zo`3oool03`3oool000l0oooo00<000000?ooo`3oool08`3oool0
1@3oom@0e=Co0?ooo`3oom@0Vg:j0080oooo00<0e9]b0;[Zo`3oool07P3oool01`3DV`00VmCo0?oD
V`1b^^X0oooo0?ooe02KL[X00P3oool00`3DVg80^^[o0?ooo`0M0?ooo`070;YbV`1bLP000000001b
^P3oool0oooD09]b^P020?ooo`030=BKLP2jj_l0oooo01h0oooo00L0e9/0000000000000L[[Z0?oo
o`3oom@0Vg:j0080oooo00<0e9]b0;[Zo`3oool06`3oool01P3oe9/0L[[Z0?ooo`3oool0oooD09]b
^P80oooo00@0e9]b0;[Zo`3oom@0Vg:j0P3oool00`3DVg80^^[o0?ooo`0H0?ooo`030?oDV`1b^^X0
oooo00@0oooo00D0oooD0=CDo`3oool0oooD09]b^P020?ooo`030=BKLP2jj_l0oooo00l0oooo000?
0?ooo`030000003oool0oooo0200oooo00`0onZj079b^P3oool0oooD09/0V`3Dool0oooo0;YbLP2j
j_l0oooD09/0V`3DoolO0?ooo`040?ooe02K0780^[ZK07:jjP80oooo00D0^W9b0;[Zo`3oom@0V`2K
0=Coo`0N0?ooo`030?oDV`00L[X0oooo00<0oooo00D0^W9b0;[Zo`3oom@0V`2K0=Coo`0N0?ooo`05
0?ooe02KL[X0oooo0?ooe02KL[X00P3oool01@2jLW80^^[o0?ooe02K09/0e?oo01/0oooo00<0^W:K
0=CDV`1b^^X00`3oool02`2jLW80^^[o0?ooe02K09/0e?oo0?ooo`2jLW80^^[o0?ooe02K09/0e?oo
01P0oooo00<0^W:K0=CDV`1b^^X00P3oool0303oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`3oool0^W9b
0;[Zo`3oom@0V`2K0=Cooa00oooo000?0?ooo`8000008P3oool0103Z^W8000000000001b^^X20?oo
o`040?oZ^P1b0000000009_Dob40oooo00<0onZj0780001b^^X00P3oool0103oj[X0LP000000002K
e?lP0?ooo`090>ZjLP000000000009_Do`3oool0onZj078000000000VmCo0100oooo00<00?l00?oo
o`3oool03@3oool0103Z^W8000000000002Ke?l20?ooo`040?oZ^P1b00000000003o01P0oooo00L0
0?l00?ooo`3oool0oooo0?oDV`000000L[[Z00<0oooo00@0onZj078000000000VmCo0P3oool0103o
j[X0LP000000002Ke?l40?ooo`03003o003oool0oooo0180oooo00<0omBK0000001b^^X00`3oool0
103Z^W8000000000001b^^X20?ooo`040?oZ^P1b0000000009_Doa40oooo000?0?ooo`030000003o
ool0oooo00T0oooo00<00?l00?ooo`3oool0103oool3003o00l0oooo00<00?l00?ooo`3oool00`3o
ool4003o00l0oooo00<00?l00?ooo`3oool00`3oool3003o0100oooo00<00?l00?ooo`3oool00`3o
ool5003o00h0oooo00<00?l00?ooo`3oool01@3oool3003o00h0oooo00<00?l00?ooo`3oool00`3o
ool2003o00030?ooo`00o`000?l000d0oooo00<00?l00?ooo`3oool01@3oool01000o`00oooo003o
0000o`0=0?ooo`03003o003oool0oooo00@0oooo0P00o`000`3oool00?l00?ooo`0=0?ooo`03003o
003oool0oooo00@0oooo00<00?l00?ooo`00o`003`3oool00`00o`00oooo0?ooo`030?ooo`<00?l0
703oool000l0oooo00<000000?ooo`3oool0203oool2003o00D0oooo00@00?l00?ooo`3oool0oooo
0P00o`0<0?ooo`800?l0103oool00`00o`00oooo0?ooo`020?ooo`800?l0303oool2003o00@0oooo
00@00?l00?ooo`3oool0oooo0P00o`0=0?ooo`800?l0103oool00`00o`00oooo0?ooo`020?ooo`03
003o003oool0oooo00/0oooo0P00o`050?ooo`800?l00P3oool00`00o`00oooo0?ooo`0:0?ooo`<0
0?l0103oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00X0oooo0P00o`060?ooo`05
003o003oool0oooo0?ooo`00o`00303oool00`00o`00oooo003o00040?ooo`03003o003oool0oooo
0080oooo00<00?l00?ooo`3oool02@3oool2003o00030?ooo`00o`00oooo00<0oooo00D00?l00?oo
o`3oool0oooo003o000=0?ooo`03003o003oool00?l000<0oooo00@00?l00?ooo`3oool0oooo0P00
o`0>0?ooo`03003o003oool0oooo00T0oooo000?0?ooo`030000003oool0oooo00L0oooo00@00?l0
0?ooo`3oool00?l0103oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00T0oooo00@0
0?l00?ooo`3oool00?l00`3oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0oooo00T0oooo
00@00?l00?ooo`3oool00?l00`3oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00X0
oooo00@00?l00?ooo`3oool00?l00`3oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0oooo
00T0oooo00@00?l00?ooo`3oool00?l00`3oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0
oooo00P0oooo00D00?l00?ooo`3oool0oooo003o00030?ooo`03003o003oool0oooo00<0oooo00<0
0?l00?ooo`3oool0203oool01000o`00oooo0?ooo`00o`040?ooo`03003o003oool0oooo00<0oooo
00<00?l00?ooo`3oool0203oool01000o`00oooo0?ooo`00o`030?ooo`03003o003oool0oooo00<0
oooo00<00?l00?ooo`3oool02@3oool01000o`00oooo0?ooo`00o`030?ooo`03003o003oool0oooo
0080oooo00<00?l00?ooo`3oool02P3oool01000o`00oooo0?ooo`00o`030?ooo`03003o003oool0
oooo0080oooo00<00?l00?ooo`3oool02P3oool2003o00030?ooo`00o`00oooo00T0oooo000?0?oo
o`030000003oool0oooo00L0oooo00@00?l00?ooo`3oool00?l00`3oool00`00o`00oooo0?ooo`04
0?ooo`03003o003oool0oooo00P0oooo00@00?l00?ooo`3oool00?l00P3oool00`00o`00oooo0?oo
o`050?ooo`03003o003oool0oooo00P0oooo00@00?l00?ooo`3oool00?l00P3oool00`00o`00oooo
0?ooo`040?ooo`03003o003oool0oooo00T0oooo00@00?l00?ooo`3oool00?l00P3oool00`00o`00
oooo0?ooo`040?ooo`03003o003oool0oooo00T0oooo00@00?l00?ooo`3oool00?l00P3oool00`00
o`00oooo0?ooo`040?ooo`03003o003oool0oooo00L0oooo00<00?l00?ooo`3oool00P3oool01000
o`00oooo0?ooo`00o`060?ooo`03003o003oool0oooo00L0oooo00D00?l00?ooo`3oool0oooo003o
00020?ooo`800?l01P3oool00`00o`00oooo0?ooo`070?ooo`03003o003oool0oooo0080oooo0`00
o`070?ooo`03003o003oool0oooo00L0oooo00<00?l00?ooo`3oool00P3oool3003o00H0oooo00<0
0?l00?ooo`3oool02@3oool01000o`00oooo0?ooo`3oool3003o00H0oooo00<00?l00?ooo`3oool0
2@3oool01000o`00oooo0?ooo`00o`020?ooo`03003o003oool0oooo00D0oooo000?0?ooo`030000
003oool0oooo00H0oooo00<00?l00?ooo`3oool00P3oool3003o00L0oooo00<00?l00?ooo`3oool0
1`3oool00`00o`00oooo0?ooo`020?ooo`800?l0203oool00`00o`00oooo0?ooo`070?ooo`03003o
003oool0oooo0080oooo0P00o`070?ooo`03003o003oool0oooo00P0oooo00<00?l00?ooo`3oool0
0P3oool2003o00L0oooo00<00?l00?ooo`3oool0203oool00`00o`00oooo0?ooo`020?ooo`800?l0
203oool00`00o`00oooo0?ooo`060?ooo`03003o003oool0oooo00<0oooo0P00o`070?ooo`03003o
003oool0oooo00L0oooo00<00?l00?ooo`3oool00P3oool2003o00P0oooo00<00?l00?ooo`3oool0
1`3oool00`00o`00oooo0?ooo`0<0?ooo`03003o003oool0oooo00L0oooo00<00?l00?ooo`3oool0
2`3oool00`00o`00oooo0?ooo`080?ooo`03003o003oool0oooo00/0oooo00<00?l00?ooo`3oool0
203oool00`00o`00oooo0?ooo`020?ooo`800?l0203oool000l0oooo00<000000?ooo`3oool01P3o
ool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00P0oooo00<00?l00?ooo`3oool01P3o
ool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00P0oooo00<00?l00?ooo`3oool01P3o
ool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00L0oooo00<00?l00?ooo`3oool01`3o
ool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo00L0oooo00<00?l00?ooo`3oool01`3o
ool00`00o`00oooo0?ooo`0<0?ooo`03003o003oool0oooo00D0oooo00<00?l00?ooo`3oool03P3o
ool00`00o`00oooo0?ooo`050?ooo`03003o003oool0oooo00d0oooo00<00?l00?ooo`3oool01P3o
ool00`00o`00oooo0?ooo`0>0?ooo`03003o003oool0oooo00D0oooo00<00?l00?ooo`3oool03@3o
ool00`00o`00oooo0?ooo`070?ooo`03003o003oool0oooo00`0oooo00<00?l00?ooo`3oool01`3o
ool00`00o`00oooo0?ooo`0<0?ooo`00203oool?00000003003o00000000000000h0000000<00?l0
0000000000001@0000000`00o`0000000000000>00000003003o00000000000000D0000000<00?l0
0000000000003@0000000`00o`0000000000000600000003003o00000000000000d0000000<00?l0
0000000000001P0000000`00o`0000000000000=00000003003o00000000000000D0000000<00?l0
0000000000003P0000000`00o`0000000000000500000003003o00000000000000h0000000<00?l0
0000000000001@0000000`00o`0000000000000>00000003003o00000000000000D0000000<00?l0
0000000000003@0000000`00o`0000000000000600000003003o00000000000000d0000000<00?l0
0000000000001P0000000`00o`0000000000000=000000003`3oool00`000000oooo0?ooo`050?oo
o`03003o003oool0000000X0oooo00D000000?ooo`3oool0oooo003o00050?ooo`030000003oool0
0?l000L0oooo00<000000?ooo`3oool01P3oool00`00o`00oooo000000050?ooo`05003o003oool0
oooo0?ooo`0000002@3oool00`000000oooo003o00080?ooo`03003o003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool01@00o`00oooo0?ooo`3oool0000000@0oooo00<00?l00?ooo`3oool0
0`3oool00`000000oooo0?ooo`070?ooo`03003o003oool0oooo00D0oooo00<00?l00?ooo`000000
2P3oool01@000000oooo0?ooo`3oool00?l000D0oooo00<000000?ooo`00o`00203oool00`000000
oooo0?ooo`050?ooo`03003o003oool0000000D0oooo00D00?l00?ooo`3oool0oooo0000000:0?oo
o`030000003oool00?l000L0oooo00<00?l00?ooo`3oool01`3oool00`000000oooo0?ooo`030?oo
o`03003o003oool0oooo0080oooo00D000000?ooo`3oool0oooo003o00050?ooo`030000003oool0
oooo00L0oooo00<00?l00?ooo`3oool01P3oool00`00o`00oooo000000090?ooo`030000003oool0
oooo0040oooo000?0?ooo`030000003oool0oooo00@0oooo00<00?l00?ooo`3oool03`3oool00`00
o`00oooo0?ooo`040?ooo`03003o003oool0oooo00l0oooo00<00?l00?ooo`3oool0103oool00`00
o`00oooo0?ooo`0?0?ooo`03003o003oool0oooo00@0oooo00<00?l00?ooo`3oool03P3oool00`00
o`00oooo0?ooo`050?ooo`03003o003oool0oooo00h0oooo00<00?l00?ooo`3oool0103oool00`00
o`00oooo0?ooo`0?0?ooo`03003o003oool0oooo00@0oooo00<00?l00?ooo`3oool03`3oool00`00
o`00oooo0?ooo`040?ooo`03003o003oool0oooo00l0oooo00<00?l00?ooo`3oool0103oool00`00
o`00oooo0?ooo`0?0?ooo`03003o003oool0oooo00D0oooo00<00?l00?ooo`3oool03@3oool00`00
o`00oooo0?ooo`060?ooo`03003o003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo00@0
oooo00<00?l00?ooo`3oool0403oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0oooo0100
oooo00<00?l00?ooo`3oool00`3oool00`00o`00oooo0?ooo`0?0?ooo`03003o003oool0oooo00@0
oooo00<00?l00?ooo`3oool03`3oool00`00o`00oooo0?ooo`040?ooo`03003o003oool0oooo00l0
oooo00<00?l00?ooo`3oool00`3oool00`00o`00oooo0?ooo`0@0?ooo`03003o003oool0oooo00<0
oooo00<00?l00?ooo`3oool03`3oool00`00o`00oooo0?ooo`040?ooo`03003o003oool0oooo0100
oooo00<00?l00?ooo`3oool00`3oool00`00o`00oooo0?ooo`0?0?ooo`03003o003oool0oooo00@0
oooo00<00?l00?ooo`3oool03`3oool00`00o`00oooo0?ooo`040?ooo`03003o003oool0oooo00h0
oooo000?0?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool04@3oool00`00o`00oooo
0?ooo`020?ooo`03003o003oool0oooo0140oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo
0?ooo`0@0?ooo`03003o003oool0oooo00<0oooo00<00?l00?ooo`3oool0403oool00`00o`00oooo
0?ooo`030?ooo`03003o003oool0oooo0100oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo
0?ooo`0A0?ooo`03003o003oool0oooo00<0oooo00<00?l00?ooo`3oool0403oool00`00o`00oooo
0?ooo`030?ooo`03003o003oool0oooo0100oooo00<00?l00?ooo`3oool00`3oool00`00o`00oooo
0?ooo`0?0?ooo`03003o003oool0oooo00@0oooo00<00?l00?ooo`3oool03`3oool00`00o`00oooo
0?ooo`040?ooo`03003o003oool0oooo00h0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
0?l00?ooo`3oool04@3oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo0140oooo00<0
0?l00?ooo`3oool00P3oool00`00o`00oooo0?ooo`0@0?ooo`03003o003oool0oooo00<0oooo00<0
0?l00?ooo`3oool0403oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0oooo0100oooo00<0
0?l00?ooo`3oool00P3oool00`00o`00oooo0?ooo`0A0?ooo`03003o003oool0oooo0080oooo00<0
0?l00?ooo`3oool04@3oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0oooo0140oooo00<0
0?l00?ooo`3oool00P3oool00`00o`00oooo0?ooo`0@0?ooo`03003o003oool0oooo00<0oooo00<0
0?l00?ooo`3oool0403oool00`00o`00oooo0?ooo`030?ooo`03003o003oool0oooo00l0oooo000?
0?ooo`8000000`3oool00`00o`00oooo0?ooo`0B0?ooo`05003o003oool0oooo0?ooo`00o`00503o
ool01@00o`00oooo0?ooo`3oool00?l001@0oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo
0?ooo`0@0?ooo`03003o003oool0oooo0080oooo00<00?l00?ooo`3oool04@3oool00`00o`00oooo
0?ooo`020?ooo`03003o003oool0oooo0140oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo
0?ooo`0A0?ooo`03003o003oool0oooo0080oooo00<00?l00?ooo`3oool04@3oool00`00o`00oooo
0?ooo`020?ooo`03003o003oool0oooo0140oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo
0?ooo`0@0?ooo`03003o003oool0oooo00<0oooo00<00?l00?ooo`3oool03`3oool000l0oooo00<0
00000?ooo`3oool00P3oool00`00o`00oooo0?ooo`0B0?ooo`05003o003oool0oooo0?ooo`00o`00
503oool01@00o`00oooo0?ooo`3oool00?l001@0oooo00D00?l00?ooo`3oool0oooo003o000C0?oo
o`03003o003oool0oooo0080oooo00<00?l00?ooo`3oool04@3oool01@00o`00oooo0?ooo`3oool0
0?l001@0oooo00<00?l00?ooo`3oool00P3oool00`00o`00oooo0?ooo`0A0?ooo`03003o003oool0
oooo0080oooo00<00?l00?ooo`3oool04@3oool00`00o`00oooo0?ooo`020?ooo`03003o003oool0
oooo0140oooo00D00?l00?ooo`3oool0oooo003o000C0?ooo`03003o003oool0oooo0080oooo00<0
0?l00?ooo`3oool0403oool000l0oooo00<000000?ooo`3oool00P3oool00`00o`00oooo0?ooo`0B
0?ooo`05003o003oool0oooo0?ooo`00o`005@3oool01000o`00oooo0?ooo`00o`0D0?ooo`05003o
003oool0oooo0?ooo`00o`00503oool01000o`00oooo0?ooo`00o`0D0?ooo`05003o003oool0oooo
0?ooo`00o`00503oool01@00o`00oooo0?ooo`3oool00?l001D0oooo00@00?l00?ooo`3oool00?l0
5@3oool01000o`00oooo0?ooo`00o`0D0?ooo`05003o003oool0oooo0?ooo`00o`00503oool01000
o`00oooo0?ooo`00o`0C0?ooo`003`3oool01@000000oooo0?ooo`3oool00?l001H0oooo00<00?l0
0?ooo`00o`005P3oool00`00o`00oooo003o000F0?ooo`03003o003oool00?l001D0oooo00@00?l0
0?ooo`3oool00?l05@3oool01000o`00oooo0?ooo`00o`0E0?ooo`04003o003oool0oooo003o01D0
oooo00@00?l00?ooo`3oool00?l05@3oool01000o`00oooo0?ooo`00o`0E0?ooo`03003o003oool0
0?l001D0oooo00@00?l00?ooo`3oool00?l04`3oool000l0oooo00D000000?ooo`3oool0oooo003o
000F0?ooo`03003o003oool00?l001H0oooo0`00o`0F0?ooo`<00?l05@3oool00`00o`00oooo003o
000F0?ooo`03003o003oool00?l001H0oooo00<00?l00?ooo`00o`005P3oool00`00o`00oooo003o
000F0?ooo`03003o003oool00?l001H0oooo0`00o`0E0?ooo`<00?l0503oool000l0oooo00@00000
0?ooo`00o`000?l05`3oool2003o04T0oooo0P00o`0F0?ooo`<00?l05P3oool3003o01L0oooo0P00
o`0G0?ooo`800?l0A@3oool000l0oooo0P00003o0?oooa00oooo000?0?ooo`030000003oool0oooo
0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo
0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<00000
0?ooo`3oool0o`3oool?0?ooo`003`3oool200000?l0oooo403oool000l0oooo00<000000?ooo`3o
ool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003o
ool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`001P3oool01P3o
e9/00000000000000000002K0=Coo`<0oooo00<000000?ooo`3oool0o`3oool?0?ooo`001`3oool0
0`2jLP00002K0=Coo`050?ooo`030000003oool0oooo0?l0oooo3`3oool000P0oooo00<0omBK0000
002Ke?l0103oool300000?l0oooo3`3oool000T0oooo00<0oooD0=CDo`3oool00`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo00060?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo0`3oool00`00
0000oooo0?ooo`3o0?ooo`l0oooo00070?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oooa00oooo000?0?ooo`030000003oool0
oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool200000?l0oooo403oool000l0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`800000o`3oool@0?ooo`003`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00080?oo
o`040>ZjLP000000001b0;[Zo`<0oooo00<000000?ooo`3oool0o`3oool?0?ooo`002@3oool00`3o
e9/0L[[Z0?ooo`030?ooo`030000003oool0oooo0?l0oooo3`3oool000H0oooo00H0oooD09/00000
000000000000LP2jj_l30?ooo`<00000o`3oool?0?ooo`001`3oool0103DV`00VmCo0?oDV`1b^^X4
0?ooo`030000003oool0oooo0?l0oooo3`3oool000L0oooo00@0oooD09/0LP2j^Y/0L[[Z103oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo00080?ooo`030?oZ^P1b0000L[[Z00@0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oooa00oooo000?0?ooo`030000003oool0
oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool200000?l0oooo403oool000l0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`800000o`3oool@0?ooo`003`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`001`3oool01@3oom@0V`00000000000780^^[o00<0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`001`3oool01@3DV`00VmCo0?ooo`3oom@0e=Co00<0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`001P3oool01P3oom@0V`0007:jjP3oool0j[Yb09_Do`<0oooo
0`00003o0?ooo`l0oooo00070?ooo`040;YbV`1bLP000000001b^P@0oooo00<000000?ooo`3oool0
o`3oool?0?ooo`001`3oool00`3oe9/007:j0?ooo`050?ooo`030000003oool0oooo0?l0oooo3`3o
ool000P0oooo00@0j[Yb000000000000VmCo0`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?
0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?oo
o`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`800000o`3oool@0?ooo`003`3o
ool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool0
00l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0
oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oooa00oooo000?
0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?oo
o`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo00T0oooo
00<0o`000?ooo`3oool0o`3oool30?ooo`003`3oool00`000000oooo0000o`040000o`<0oooo0`3o
003o0?ooo`D0oooo000?0?ooo`8000001@3oool20000o`050?l0003oool0oooo0?ooo`3o00001@3o
ool00`3o0000oooo0?ooo`3k0?ooo`003`3oool00`000000oooo0?ooo`050?ooo`030?l000000?l0
oooo0080oooo00<0o`000?ooo`3oool00P3oool0103o0000oooo0?l0003o003k0?ooo`003`3oool0
0`000000oooo0?ooo`040?ooo`040?l0003oool0oooo0000o`80oooo00<0o`000?ooo`3oool00P3o
ool01@3o0000oooo0?ooo`3oool0o`000?X0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
o`000?ooo`3oool00P3oool20000o`030?ooo`3o0000oooo0080o`001@3oool00`3o0000oooo0?oo
o`3g0?ooo`001`3oool0103DV`0000000000001b^^X40?ooo`030000003oool0oooo00<0oooo00<0
o`000?ooo`3oool0103oool30000o`L0oooo00<0o`000?ooo`3oool0m`3oool000H0oooo00D0oooD
09^Ke03oool0oooo0;ZK^P040?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0203o
ool20000o`H0oooo00<0o`000?ooo`3oool0mP3oool000L0oooo00@0^Y^j0?ooo`3oom@0Vi_D103o
ool300000080oooo00<0o`000?ooo`3oool02P3oool20000o`@0oooo00<0o`000?ooo`3oool0mP3o
ool000L0oooo00@0e9/0000000000000L[[Z103oool00`000000oooo0?ooo`020?ooo`030?l0003o
ool0oooo00`0oooo10000?l00`3oool0o`000?ooo`3f0?ooo`001P3oool01@3oom@0Vg:j0?ooo`3o
om@0Vg:j00@0oooo00D000000?ooo`3oool0oooo0?l0000C0?ooo`@0003om@3oool000L0oooo00@0
j[Yb000000000000VmCo103oool01@000000oooo0?ooo`3oool0o`0001@0oooo00<0o`000?ooo`3o
ool00P000?oc0?ooo`003`3oool010000000oooo0?l0003o000E0?ooo`030?l0003oool0oooo0080
oooo00<0003o0?ooo`3oool0l03oool000l0oooo00<000000?ooo`3oool05`3oool00`3o0000oooo
0?ooo`020?ooo`050000o`3oool0oooo0?ooo`3o0000k@3oool000l0oooo00<000000?ooo`3oool0
5`3oool00`3o0000oooo0?ooo`030?ooo`050000o`3oool0o`000?ooo`3o0000k03oool000l0oooo
0P00000H0?ooo`030?l0003oool0oooo00@0oooo00D0003o0?l0003oool0oooo0?l0003[0?ooo`00
3`3oool00`000000oooo0?ooo`0G0?ooo`030?l0003oool0oooo00@0oooo00D0o`000000o`3oool0
oooo0?l0003[0?ooo`003`3oool00`000000oooo0?ooo`0G0?ooo`030?l0003oool0oooo0080oooo
0P3o00020?ooo`040000o`3oool0oooo0?l00>X0oooo000?0?ooo`030000003oool0oooo01L0oooo
00D0o`000?ooo`3oool0oooo0?l000050?ooo`030000o`3oool0o`000>X0oooo000?0?ooo`030000
003oool0oooo01P0oooo00@0o`000?ooo`3oool0o`001@3oool00`000?l0oooo0?l0003Z0?ooo`00
3`3oool00`000000oooo0?ooo`0H0?ooo`030?l0003oool0o`0000L0oooo00<0003o0?l0003oool0
0`3oool00`3o0000oooo0?ooo`0H0?ooo`<0o`00TP3oool30?l000h0oooo00<0o`000?ooo`3oool0
8P3oool000l0oooo0P00000I0?ooo`<0o`00203oool01P000?l0o`000?ooo`3oool0o`000?ooo`80
o`005`3oool01@3o0000oooo0?ooo`3oool0o`0000/0oooo0`3o00210?ooo`80o`000P3oool00`3o
0000oooo0?ooo`0:0?ooo`80o`0000<0oooo0?l0003oool00`3oool30?l001`0oooo000?0?ooo`03
0000003oool0oooo02@0oooo00<0003o0?l0003o0000103oool00`3o0000oooo0?ooo`0C0?ooo`03
0?l0003oool0oooo0080oooo00<0o`000?ooo`3oool02@3oool00`3o0000oooo0?l0001k0?ooo`03
0?l0003oool0oooo0080oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`090?ooo`04
0?l0003oool0oooo0?l000<0oooo00D0o`000?ooo`3oool0oooo0?l0000K0?ooo`003`3oool00`00
0000oooo0?ooo`0U0?ooo`030000o`3oool0oooo00@0oooo0P3o000B0?ooo`030?l0003oool0oooo
00@0oooo20000?l20?ooo`050?l0003oool0oooo0?ooo`3o0000103oool30?l00780oooo00<0o`00
0?ooo`3o00000`3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo00P0oooo00<0o`00
0?ooo`3oool00P3oool30?l000D0oooo00<0o`000?ooo`3oool0603oool000l0oooo00<000000?oo
o`3oool09P3oool00`000?l0oooo0?ooo`040?ooo`030?l0003oool0oooo0100oooo00<0o`000?oo
o`3oool00P3oool20000o`030?l0003oool0oooo00D0oooo0P000?l01@3o0000oooo0?ooo`3oool0
o`0000<0oooo00D0o`000?ooo`3oool0oooo0?l0001a0?ooo`030?l0003oool0o`000080oooo00<0
o`000?ooo`3oool01@3oool60000o`@0oooo00<0o`000?ooo`3oool02P3oool00`3o0000oooo0?oo
o`0H0?ooo`003`3oool00`000000oooo0?ooo`0W0?ooo`030000o`3oool0oooo00@0oooo00<0o`00
0?ooo`3oool02P3oool01@3o0000oooo0?ooo`3oool0o`0000@0oooo00D0003o0?ooo`3oool0oooo
0?l000070?ooo`030?l000000?l0003o00<0oooo00<0o`000?ooo`3o00001@3oool00`3o0000oooo
0?ooo`1]0?ooo`040?l0003oool0oooo0?ooo`<0o`000`3oool40000o`030?l0003oool0oooo00<0
oooo2P000?l80?ooo`030?l0003oool0oooo01L0oooo000?0?ooo`030000003oool0oooo02P0oooo
0P000?l40?ooo`030?l0003oool0oooo00T0oooo00<0o`000?ooo`3o00000P3oool01@3o0000oooo
0?ooo`3oool0003o00@0oooo00<0o`000?ooo`3oool01@3oool00`3o0000oooo0?ooo`020000o`03
0?ooo`3o0000o`0000H0oooo00<0o`000?ooo`3oool0K@3oool00`3o0000oooo0?ooo`050?ooo`80
003o103oool00`3o0000oooo0?ooo`060?ooo`030?l0003oool0oooo00@0oooo10000?l40?ooo`03
0?l0003oool0oooo01L0oooo000?0?ooo`800000:`3oool20000o`<0oooo00<0o`000?ooo`3oool0
1`3oool01P3o0000oooo0?ooo`3o0000oooo0?l00080oooo0P000?l50?ooo`030?l0003oool0oooo
00@0oooo00<0o`000?ooo`3oool00`3oool40000o`H0oooo00<0o`000?ooo`3oool0J`3oool00`3o
0000oooo0?ooo`020?ooo`@0003o1`3oool00`3o0000oooo0?ooo`050?ooo`030?l0003oool0oooo
00P0oooo0P000?l30?ooo`030?l0003oool0oooo00P0oooo0`3o000;0?ooo`003`3oool00`000000
oooo0?ooo`0/0?ooo`80003o00<0oooo0?l0003oool0203oool01P3o0000oooo0?ooo`3oool0o`00
0?ooo`80003o1`3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo00P0oooo0P000?l4
0?ooo`030?l0003oool0oooo06/0oooo00<0o`000?ooo`3oool00P000?l;0?ooo`030?l0003oool0
oooo00@0oooo00<0o`000?ooo`3oool02`3oool;0000o`80oooo00D0o`000?ooo`3oool0oooo0?l0
00020?ooo`030?l0003oool0oooo00D0oooo000?0?ooo`030000003oool0oooo02h0oooo1P000?l4
0?ooo`030?l0003oool0oooo0080oooo0P000?l:0?ooo`030?l0003oool0oooo0080oooo00<0o`00
0?ooo`3oool02P3oool20000o`80oooo00<0o`000?ooo`3oool0J`3oool00`3o0000003o0000o`0=
0?ooo`030?l0003oool0oooo00@0oooo00<0o`000?ooo`3oool03P3oool00`3o0000oooo0?ooo`05
0?ooo`80003o00L0o`000?ooo`3oool0oooo0?l0003oool0o`0000P0oooo000?0?ooo`030000003o
ool0oooo02l0oooo00<0o`000?ooo`3oool00P3oool40000o`030?l0003oool0oooo0080003o303o
ool01@3o0000oooo0?ooo`3oool0o`0000l0oooo0P000?l00`3o0000oooo0?ooo`1Z0?ooo`030?l0
00000?l0oooo00l0oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`0?0?ooo`030?l0
003oool0oooo00H0oooo00<0o`000000o`000?l00`3oool00`3o0000oooo0?ooo`070?ooo`0000P0
oooD09/00000000000000000LP2jj_l0oooo0>ZjLP80000000<0L[[Z0?ooo`3oool00P3oool00`00
0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo00D0oooo00@0o`000000o`000?l0003o3P3oool0
1@3o0000oooo0?ooo`3oool0o`000140oooo00<0003o0?l0003oool0JP3oool00`000?l0oooo0?oo
o`0?0?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool0403oool00`3o0000oooo0?oo
o`040?ooo`040?l0003oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`050?ooo`000P3o
ool00`3oe9/0L[[Z0?ooo`020?ooo`050;ZK^P3oool0oooo0;YbV`3Dool00`3oool00`000000oooo
0?ooo`0`0?ooo`030?l0003oool0oooo00@0oooo00<0o`000?ooo`3oool0403oool00`3o0000oooo
0?l0000C0?ooo`030000o`3oool0oooo00X0oooo00<0o`000?ooo`3oool0D03oool00`3o0000oooo
0?ooo`080?ooo`030000o`3o0000oooo0140oooo00@0o`000?ooo`3oool0o`004`3oool00`3o0000
oooo0?ooo`040?ooo`030?l0003oool0oooo00<0oooo0`000?l80?ooo`000P3oool01P3oe9/0L[[Z
0?ooo`3oool0oooD09]b^P80oooo00<0e9]b0;[Zo`3oool00P3oool300000300oooo00<0o`000?oo
o`3oool00`3oool00`3o0000oooo0?ooo`0A0?ooo`<0o`004`3oool00`3o0000003o0000o`080?oo
o`<0o`00D@3oool0103o0000oooo0?l0003o00070?ooo`030000o`3oool0o`000180oooo00@0o`00
0?ooo`3oool0o`004`3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo00l0oooo0002
0?ooo`060?oDV`1b^^X0oooo0?ooo`3oom@0Vg:j0P3oool00`3DVg80^^[o0?ooo`020?ooo`030000
003oool0oooo0300oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`0W0?ooo`040?l0
003oool0oooo0000o`L0oooo00@0o`000?ooo`3oool0o`00C`3oool01@3o0000oooo0?ooo`3oool0
o`0000D0oooo0P000?l00`3oool0o`000?ooo`0C0?ooo`80o`00503oool00`3o0000oooo0?ooo`02
0?ooo`030?l0003oool0oooo0100oooo0000103oool0^W:K0=CDV`1b^^X30?ooo`050;YbLP2jj_l0
oooD09/0V`3Dool00`3oool00`000000oooo0?ooo`0`0?ooo`030?l0003oool0oooo0080oooo00<0
o`000?ooo`3oool0:@3oool0103o0000oooo0?ooo`000?l50?ooo`050?l0003oool0oooo0?ooo`3o
0000103oool30?l00340oooo00<0o`000?ooo`3oool03@3oool00`3o0000oooo0?ooo`030?ooo`03
0?l0003oool0oooo00<0oooo00<0o`000?ooo`3oool00P000?l30?ooo`030?l0003oool0oooo01<0
oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo0100
oooo0000103oool0omBK0000001b^^X30?ooo`040?oZ^P1b0000000009_Do`@0oooo00<000000?oo
o`3oool0<03oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo02T0oooo00@0o`000?oo
o`3oool0oooo0P000?l30?ooo`030?l0003oool0oooo0080oooo103o00030?ooo`030?l0003oool0
oooo02d0oooo00@0o`000?ooo`3o0000o`002`3oool20?l000030?ooo`3o0000oooo0080oooo00<0
o`000?ooo`3oool0103oool00`3o0000oooo0000o`050?ooo`030?l0003oool0oooo02T0oooo00@0
o`000?ooo`3oool0o`004`3oool000l0oooo00<000000?ooo`3oool0<03oool01@3o0000oooo0?oo
o`3oool0o`0002`0oooo00<0o`000?ooo`3oool00`3oool70000o`T0oooo00<0o`000?ooo`3oool0
:`3oool01@3o0000oooo0?ooo`3oool0o`0000/0oooo00@0o`000?ooo`3oool0oooo0`3o00080?oo
o`030000o`3oool0oooo00@0oooo00<0o`000?ooo`3oool0:@3oool0103o0000oooo0?ooo`3o000C
0?ooo`003`3oool00`000000oooo0?ooo`0a0?ooo`040?l0003oool0oooo0?l002`0oooo00<0o`00
0?ooo`3oool01@3oool00`3o0000oooo0?ooo`020?ooo`@0003o1@3oool00`3o0000oooo0?ooo`0Z
0?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool0203oool00`3o0000oooo0?ooo`0;
0?ooo`80003o00<0o`000?ooo`3oool0103oool00`3o0000oooo0?ooo`0Y0?ooo`<0o`00503oool0
00l0oooo00<000000?ooo`3oool0<@3oool00`3o0000oooo0?l0000]0?ooo`030?l0003oool0oooo
00D0oooo00<0o`000?ooo`3oool01P3oool20000o`@0oooo00<0o`000?ooo`3oool0:@3oool00`3o
0000oooo0?ooo`030?ooo`030?l0003oool0oooo00L0oooo00<0o`000?ooo`3oool0103oool70000
o`80oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`110?ooo`003`3oool200000380
oooo0`3o000]0?ooo`030?l0003oool0oooo00@0oooo00<0o`000?ooo`3oool02@3oool01@000?l0
oooo0?ooo`3oool0o`0002D0oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`040?oo
o`030?l0003oool0oooo00L0oooo00<0o`000000o`000?l010000?l:0?ooo`030?l0003oool0oooo
0080oooo00<0o`000?ooo`3oool0@@3oool000l0oooo00<000000?ooo`3oool0HP3oool00`3o0000
oooo0?ooo`030?ooo`030?l0003oool0oooo00X0oooo00@0003o0?ooo`3oool0o`009@3oool20?l0
0080oooo0P3o00060?ooo`030?l0003oool0oooo00@0oooo10000?l@0?ooo`030?l0003oool0oooo
0080oooo00<0o`000?ooo`3oool0@@3oool000l0oooo00<000000?ooo`3oool0HP3oool00`3o0000
oooo0?ooo`020?ooo`030?l0003oool0oooo00`0oooo00@0003o0?ooo`3oool0o`008`3oool00`3o
0000oooo0?ooo`020?l000<0oooo30000?l20?ooo`030?l0003oool0oooo00l0oooo00D0o`000?oo
o`3oool0oooo0?l000140?ooo`003`3oool00`000000oooo0?ooo`1R0?ooo`030?l0003oool0oooo
0080oooo00<0o`000?ooo`3oool03@3oool00`000?l0oooo0?l0000S0?ooo`030?l0003oool0oooo
0080oooo0`000?l60?ooo`030?l0003oool0oooo00D0oooo00<0o`000?ooo`3oool03`3oool01@3o
0000oooo0?ooo`3oool0o`0004@0oooo000?0?ooo`030000003oool0oooo0680oooo00D0o`000?oo
o`3oool0oooo0?l0000A0?ooo`030000o`3o0000oooo0240oooo00@0o`000?ooo`3oool0oooo0P00
0?l90?ooo`030?l0003oool0oooo00@0oooo00<0o`000?ooo`3oool04@3oool00`3o0000oooo0?l0
00150?ooo`003`3oool00`000000oooo0?ooo`1S0?ooo`030?l0003oool0o`0001<0oooo00<0003o
0?ooo`3oool0803oool0103o0000oooo0?ooo`000?l;0?ooo`030?l0003oool0oooo00@0oooo00<0
o`000?ooo`3oool04@3oool00`3o0000oooo0?l000150?ooo`003`3oool2000006@0oooo00<0o`00
0?ooo`3o00004`3oool00`3o0000003o0?ooo`090?ooo`80o`005@3oool00`3o0000oooo0000o`0<
0?ooo`030?l0003oool0oooo00<0oooo00<0o`000?ooo`3oool04P3oool20?l004H0oooo000?0?oo
o`030000003oool0oooo06@0oooo00<0o`000?ooo`3oool04P3oool00`3o0000003o0?ooo`070?oo
o`80o`0000<0oooo0?l0003oool04`3oool00`3o0000oooo0000o`0>0?ooo`030?l0003oool0oooo
0080oooo00<0o`000?ooo`3oool0FP3oool000l0oooo00<000000?ooo`3oool0NP3oool00`3o0000
003o0?ooo`050?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool00P3oool30?l000`0
oooo00<0o`000000o`3oool03P3oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo05X0
oooo000?0?ooo`030000003oool0oooo07X0oooo00<0o`000?ooo`000?l00`000?l20?ooo`030?l0
003oool0oooo0080oooo00D0o`000?ooo`3oool0oooo0?l000030?ooo`030?l0003oool0oooo00T0
oooo00<0003o0?ooo`3oool03P3oool01@3o0000oooo0?ooo`3oool0o`0005d0oooo000?0?ooo`03
0000003oool0oooo07X0oooo00<0o`000?ooo`3oool00`3oool20000o`H0oooo00@0o`000?ooo`3o
ool0o`00103oool00`3o0000oooo0?ooo`070?ooo`030?l000000?l0oooo00l0oooo00D0o`000?oo
o`3oool0oooo0?l0001M0?ooo`003`3oool00`000000oooo0?ooo`1j0?ooo`030?l0003oool0oooo
00@0oooo00<0o`000000o`000?l00`000?l0103oool0o`000?l0003o00050?ooo`030?l0003oool0
oooo00L0oooo00<0003o0?ooo`3oool0403oool0103o0000oooo0?ooo`3o001M0?ooo`003`3oool2
000007/0oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`040?ooo`80003o203oool0
0`3o0000oooo0?ooo`050?ooo`030000o`3o0000oooo0140oooo00<0o`000?ooo`3o0000GP3oool0
00l0oooo00<000000?ooo`3oool0NP3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo
00H0oooo0P000?l60?ooo`030?l0003oool0oooo00@0oooo00<0003o0?ooo`3o00004`3oool20?l0
05h0oooo000?0?ooo`030000003oool0oooo07X0oooo00<0o`000?ooo`3oool00P3oool00`3o0000
oooo0?ooo`090?ooo`@0003o0P3oool00`3o0000oooo0?ooo`020?ooo`80003o00<0oooo0?l0003o
ool0L`3oool000l0oooo00<000000?ooo`3oool0NP3oool00`3o0000oooo0?ooo`020?ooo`030?l0
003oool0oooo00d0oooo1`000?l30?ooo`030?l0003oool0oooo0780oooo00001`3oom@0V`000000
00000000001b0;[Zo`3oe9/00`0000000`0009/0e?oo0?ooo`020?ooo`030000003oool0oooo07X0
oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`0@0?ooo`030?l0003oool0oooo00@0
oooo00<0o`000?ooo`3oool0LP3oool00080oooo00<0omBK07:jjP3oool00P3oool00`2jLP00002K
0=Coo`050?ooo`030000003oool0oooo07/0oooo00@0o`000?ooo`3oool0o`004`3oool00`3o0000
oooo0?ooo`040?ooo`030?l0003oool0oooo0780oooo00020?ooo`030?oDV`1b^^X0oooo00<0oooo
00<0omBK0000002Ke?l0103oool3000007/0oooo00@0o`000?ooo`3oool0o`004`3oool00`3o0000
oooo0?ooo`030?ooo`030?l0003oool0oooo07<0oooo00020?ooo`030?oDV`1b^^X0oooo00@0oooo
00<0oooD0=CDo`3oool00`3oool00`000000oooo0?ooo`1k0?ooo`040?l0003oool0oooo0?l001@0
oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`1c0?ooo`0000@0oooo0;YbV`3De9/0
L[[Z0P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3oool0N`3oool0
0`3o0000oooo0?l0000E0?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool0L`3oool0
00040?ooo`3oe9/0000007:jjP<0oooo00@0j[Yb000000000000L[[Z103oool00`000000oooo0?oo
o`1k0?ooo`<0o`005@3oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo07<0oooo000?
0?ooo`030000003oool0oooo09<0oooo00D0o`000?ooo`3oool0oooo0?l0001f0?ooo`003`3oool0
0`000000oooo0?ooo`2C0?ooo`050?l0003oool0oooo0?ooo`3o0000MP3oool000l0oooo00<00000
0?ooo`3oool0U03oool0103o0000oooo0?ooo`3o001f0?ooo`003`3oool2000009D0oooo00<0o`00
0?ooo`3o0000M`3oool000l0oooo00<000000?ooo`3oool0U03oool30?l007L0oooo000?0?ooo`03
0000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3o
ool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool0
0?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{54.375, 341.375}, {365.75, 188.813}} -> {-33.7533, \
14.0011, 0.483204, 0.0800936}}],

Cell[BoxData[
    InterpretationBox[\("Smoothing parameters: \[Alpha] = \
"\[InvisibleSpace]0.9236999330016303`\[InvisibleSpace]",  \[Gamma] = "\
\[InvisibleSpace]1.8876668549878417`\),
      SequenceForm[ 
      "Smoothing parameters: \[Alpha] = ", .92369993300163034, 
        ",  \[Gamma] = ", 1.8876668549878417],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Estimated variances: \!\(\[Sigma]\_u\^2\) = "\
\[InvisibleSpace]0.020494753549535956`\[InvisibleSpace]", \
\!\(\[Sigma]\_v\^2\) = \
"\[InvisibleSpace]0.02218767460871926`\[InvisibleSpace]", \
\!\(\[Sigma]\_w\^2\) = "\[InvisibleSpace]0.010857187800581454`\),
      SequenceForm[ 
      "Estimated variances: \!\(\[Sigma]\_u\^2\) = ", .020494753549535956, 
        ", \!\(\[Sigma]\_v\^2\) = ", .02218767460871926, 
        ", \!\(\[Sigma]\_w\^2\) = ", .010857187800581454],
      Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
  "The option \"SearchRange\" \[Rule] {{",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Alpha]", 
            StyleBox["max",
              FontSlant->"Italic"]], "}"}], TraditionalForm]]],
  ", {",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Gamma]", 
            StyleBox["max",
              FontSlant->"Italic"]], "}"}], TraditionalForm]]],
  "} permits to select a range over which Season searches for a solution, \
where \[Alpha] is restricted to the interval [",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["max",
            FontSlant->"Italic"]], TraditionalForm]]],
  "] and \[Gamma] is restricted to the interval [",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["max",
            FontSlant->"Italic"]], TraditionalForm]]],
  "]. If a parameter is estimated close to the boundary of the relevant \
interval, a warning is issued.\n\n",
  StyleBox["The standard option for the search range is: \"SearchRange\"  \
\[Rule] ", "Commentary"],
  StyleBox["{{0.5, 1000}, {0.5, 1000}}", "Commentary"],
  StyleBox[".", "Commentary"]
}], "DefinitionBox",
  CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\({{x, y, z, u}, {a, g}, \ var} = 
        Season[x, 
          12, \ "\<SearchRange\>"\  \[Rule] \ {{1, 2}, {1, 
                2}}];\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(Season::"cornera" \(\(:\)\(\ \)\) 
      "Estimate \!\(1.0000008256837694`\) of alpha appears to be a corner \
solution"\)], "Message"]
}, Open  ]],

Cell[TextData[{
  "Season calls NMaximize to determine the optimum smoothing parameter. \
NMaximize options can be given to Season to cope with convergency problems \
and other issues. They are handed over to NMaximize. If NMaximize does not \
find a solution, a warning is issued.\n\n",
  StyleBox["Standard options for NMaximize in Season are: Method \[Rule] \
{\"NelderMead\", PostProcess \[Rule] False }. To speed up calculation, use \
AccuracyGoal \[Rule] 3.", "Commentary"]
}], "DefinitionBox",
  CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\({{x, y, z, u}, {a, g}, \ var} = 
        Season[x, 12, AccuracyGoal \[Rule] 8, 
          MaxIterations \[Rule] 5];\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    RowBox[{\(NMaximize::"cvmit"\), \(\(:\)\(\ \)\), "\<\"Failed to converge \
to the requested accuracy or precision within \\!\\(5\\) iterations. \
\\!\\(\\*ButtonBox[\\\"Mehr\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NMaximize::cvmit\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    \(Season::"maxfail" \(\(:\)\(\ \)\) 
      "Aborting due to problems in numerical maximization procedure.\n \
Consider fine-tuning of NMaximize options."\)], "Message"],

Cell[BoxData[
    \($Aborted\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function Likelihood[",
  StyleBox["x,s",
    FontSlant->"Italic"],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Alpha]\)\(,\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  "] returns the log likelihood of the constellation {",
  StyleBox["x,s",
    FontSlant->"Italic"],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Alpha]\)\(,\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  "}."
}], "DefinitionBox",
  CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LL[x, 12, 2, 3]\)], "Input"],

Cell[BoxData[
    \(681.780668935064`\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function LLPlot[x,s,{",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Alpha]", 
            StyleBox["max",
              FontSlant->"Italic"]], "}"}], TraditionalForm]]],
  ", {",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Gamma]", 
            StyleBox["max",
              FontSlant->"Italic"]], "}"}], TraditionalForm]]],
  "] returns a plot of the log likelihood over the range {\[Alpha],\[Gamma]}\
\[Element][",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Alpha]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Alpha]", 
            StyleBox["max",
              FontSlant->"Italic"]], "]"}], TraditionalForm]]],
  "\[Times][",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["min",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[Gamma]", 
          StyleBox["max",
            FontSlant->"Italic"]], TraditionalForm]]],
  "].\n\n",
  StyleBox["LLPlot calls Plot3D and hands any options over to Plot3D. Be \
aware that the system matrix becomes near-singular for very large or very \
small values of the smoothing parameters, and that irregularities in these \
regions may be computational artifacts.", "Commentary"]
}], "DefinitionBox",
  CellTags->"b:0"],

Cell["Here is an example:", "MathCaption",
  CellFrame->{{0, 0}, {0, 0.5}},
  CellTags->"b:0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LLPlot[x, 12, {0.9, 0.95}, {1.8, 2}, 
      PlotPoints\  \[Rule] 20]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.47973e-013 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -23.848 -9 ]
[.14598 .19958 .15205 0 ]
[.27013 .15073 -22.8472 -9 ]
[.27013 .15073 1.15281 0 ]
[.40046 .09948 -21.8464 -9 ]
[.40046 .09948 2.15358 0 ]
[.53743 .04564 -20.8457 -9 ]
[.53743 .04564 3.15434 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 18 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 24 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 18 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 24 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02145 .28182 -42 -2.75643 ]
[.02145 .28182 0 6.24357 ]
[.00909 .35929 -42 -2.82206 ]
[.00909 .35929 0 6.17794 ]
[-0.00391 .44075 -42 -2.8914 ]
[-0.00391 .44075 0 6.1086 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.9)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.91)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.92)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.93)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.94)] .53743 .04564 .73714 1 Mshowa
.125 Mabswid
.06033 .24606 m
.06319 .24877 L
s
.08372 .23691 m
.08655 .23964 L
s
.10732 .22766 m
.11013 .23042 L
s
.13115 .21833 m
.13394 .22111 L
s
.17948 .19941 m
.18222 .20223 L
s
.20399 .18981 m
.2067 .19266 L
s
.22873 .18012 m
.23142 .183 L
s
.25371 .17034 m
.25638 .17324 L
s
.3044 .15049 m
.30701 .15344 L
s
.33011 .14043 m
.3327 .14339 L
s
.35608 .13026 m
.35864 .13325 L
s
.3823 .11999 m
.38483 .12301 L
s
.43553 .09915 m
.43799 .10222 L
s
.46254 .08857 m
.46497 .09167 L
s
.48982 .07789 m
.49222 .08101 L
s
.51738 .0671 m
.51975 .07024 L
s
.57333 .04519 m
.57563 .04838 L
s
.60174 .03407 m
.60401 .03728 L
s
.63044 .02283 m
.63267 .02607 L
s
.65944 .01147 m
.66163 .01474 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(1.8)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(1.85)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(1.9)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1.95)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03368 .27708 m
.0398 .27471 L
s
[(684.392)] .02145 .28182 1 -0.38746 Mshowa
.02138 .35471 m
.02753 .35242 L
s
[(684.394)] .00909 .35929 1 -0.37288 Mshowa
.00845 .43633 m
.01462 .43412 L
s
[(684.396)] -0.00391 .44075 1 -0.35747 Mshowa
.125 Mabswid
.03066 .29613 m
.03434 .29472 L
s
.02761 .31541 m
.03129 .31401 L
s
.02451 .33494 m
.0282 .33355 L
s
.01821 .37473 m
.0219 .37337 L
s
.015 .395 m
.01869 .39365 L
s
.01174 .41553 m
.01544 .4142 L
s
.03667 .25826 m
.04033 .25683 L
s
.00511 .45739 m
.00882 .45608 L
s
.00173 .47873 m
.00544 .47743 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.589 .034 0 r
.38834 .60443 .40512 .60371 .43157 .61767 .41497 .61841 Metetra
.527 0 0 r
.41497 .61841 .43157 .61767 .45867 .62945 .44228 .63018 Metetra
.451 0 0 r
.44228 .63018 .45867 .62945 .48641 .63897 .47025 .63965 Metetra
.36 0 0 r
.47025 .63965 .48641 .63897 .51473 .64616 .49882 .64676 Metetra
.253 0 0 r
.49882 .64676 .51473 .64616 .54358 .65096 .52795 .65144 Metetra
.131 0 0 r
.52795 .65144 .54358 .65096 .57293 .65331 .55759 .65364 Metetra
.55759 .65364 .57293 .65331 .60272 .65317 .58769 .65331 Metetra
.133 .681 .779 r
.58769 .65331 .60272 .65317 .63289 .6505 .61819 .65041 Metetra
.262 .77 .843 r
.61819 .65041 .63289 .6505 .6634 .64527 .64904 .64492 Metetra
.379 .841 .889 r
.64904 .64492 .6634 .64527 .69416 .63746 .68017 .63681 Metetra
.482 .894 .917 r
.68017 .63681 .69416 .63746 .72514 .62708 .71152 .62609 Metetra
.568 .931 .93 r
.71152 .62609 .72514 .62708 .75626 .61412 .74303 .61275 Metetra
.64 .956 .933 r
.74303 .61275 .75626 .61412 .78746 .5986 .77463 .59682 Metetra
.698 .971 .928 r
.77463 .59682 .78746 .5986 .81867 .58054 .80625 .57831 Metetra
.745 .979 .918 r
.80625 .57831 .81867 .58054 .84983 .55999 .83783 .55727 Metetra
.784 .982 .905 r
.83783 .55727 .84983 .55999 .88088 .53698 .8693 .53375 Metetra
.815 .981 .889 r
.8693 .53375 .88088 .53698 .91175 .51158 .9006 .5078 Metetra
.841 .979 .874 r
.9006 .5078 .91175 .51158 .94238 .48385 .93165 .4795 Metetra
.863 .975 .857 r
.93165 .4795 .94238 .48385 .97271 .45386 .96241 .44892 Metetra
.567 0 0 r
.37114 .60382 .38834 .60443 .41497 .61841 .39795 .6178 Metetra
.496 0 0 r
.39795 .6178 .41497 .61841 .44228 .63018 .42546 .62953 Metetra
.409 0 0 r
.42546 .62953 .44228 .63018 .47025 .63965 .45364 .63894 Metetra
.306 0 0 r
.45364 .63894 .47025 .63965 .49882 .64676 .48246 .64595 Metetra
.186 0 0 r
.48246 .64595 .49882 .64676 .52795 .65144 .51186 .6505 Metetra
.055 0 0 r
.51186 .6505 .52795 .65144 .55759 .65364 .54178 .65253 Metetra
.081 .64 .785 r
.54178 .65253 .55759 .65364 .58769 .65331 .57219 .652 Metetra
.215 .734 .856 r
.57219 .652 .58769 .65331 .61819 .65041 .60302 .64886 Metetra
.338 .811 .906 r
.60302 .64886 .61819 .65041 .64904 .64492 .63421 .64308 Metetra
.446 .869 .937 r
.63421 .64308 .64904 .64492 .68017 .63681 .6657 .63466 Metetra
.538 .91 .953 r
.6657 .63466 .68017 .63681 .71152 .62609 .69743 .62358 Metetra
.614 .937 .956 r
.69743 .62358 .71152 .62609 .74303 .61275 .72932 .60985 Metetra
.676 .954 .951 r
.72932 .60985 .74303 .61275 .77463 .59682 .76131 .59349 Metetra
.726 .963 .94 r
.76131 .59349 .77463 .59682 .80625 .57831 .79334 .57453 Metetra
.767 .967 .926 r
.79334 .57453 .80625 .57831 .83783 .55727 .82534 .553 Metetra
.8 .968 .911 r
.82534 .553 .83783 .55727 .8693 .53375 .85723 .52896 Metetra
.827 .966 .894 r
.85723 .52896 .8693 .53375 .9006 .5078 .88895 .50246 Metetra
.85 .963 .877 r
.88895 .50246 .9006 .5078 .93165 .4795 .92043 .47358 Metetra
.869 .959 .86 r
.92043 .47358 .93165 .4795 .96241 .44892 .95161 .4424 Metetra
.54 0 0 r
.35353 .60183 .37114 .60382 .39795 .6178 .3805 .61578 Metetra
.458 0 0 r
.3805 .61578 .39795 .6178 .42546 .62953 .40821 .62745 Metetra
.359 0 0 r
.40821 .62745 .42546 .62953 .45364 .63894 .43661 .63678 Metetra
.243 0 0 r
.43661 .63678 .45364 .63894 .48246 .64595 .46566 .64367 Metetra
.113 0 0 r
.46566 .64367 .48246 .64595 .51186 .6505 .49531 .64806 Metetra
.025 .592 .783 r
.49531 .64806 .51186 .6505 .54178 .65253 .52552 .64991 Metetra
.162 .692 .86 r
.52552 .64991 .54178 .65253 .57219 .652 .55623 .64915 Metetra
.291 .774 .916 r
.55623 .64915 .57219 .652 .60302 .64886 .58738 .64574 Metetra
.405 .837 .951 r
.58738 .64574 .60302 .64886 .63421 .64308 .61891 .63968 Metetra
.502 .883 .969 r
.61891 .63968 .63421 .64308 .6657 .63466 .65075 .63092 Metetra
.583 .913 .974 r
.65075 .63092 .6657 .63466 .69743 .62358 .68284 .61947 Metetra
.649 .933 .969 r
.68284 .61947 .69743 .62358 .72932 .60985 .71512 .60534 Metetra
.702 .944 .959 r
.71512 .60534 .72932 .60985 .76131 .59349 .74751 .58855 Metetra
.746 .95 .945 r
.74751 .58855 .76131 .59349 .79334 .57453 .77994 .56912 Metetra
.781 .952 .929 r
.77994 .56912 .79334 .57453 .82534 .553 .81235 .54709 Metetra
.81 .951 .912 r
.81235 .54709 .82534 .553 .85723 .52896 .84466 .52252 Metetra
.834 .948 .894 r
.84466 .52252 .85723 .52896 .88895 .50246 .8768 .49547 Metetra
.855 .945 .877 r
.8768 .49547 .88895 .50246 .92043 .47358 .90871 .46601 Metetra
.872 .941 .86 r
.90871 .46601 .92043 .47358 .95161 .4424 .94032 .43423 Metetra
.505 0 0 r
.33552 .59837 .35353 .60183 .3805 .61578 .36264 .61227 Metetra
.412 0 0 r
.36264 .61227 .3805 .61578 .40821 .62745 .39053 .62386 Metetra
.3 0 0 r
.39053 .62386 .40821 .62745 .43661 .63678 .41913 .63307 Metetra
.173 0 0 r
.41913 .63307 .43661 .63678 .46566 .64367 .44841 .63983 Metetra
0 .537 .772 r
.44841 .63983 .46566 .64367 .49531 .64806 .47832 .64405 Metetra
.105 .642 .856 r
.47832 .64405 .49531 .64806 .52552 .64991 .5088 .64568 Metetra
.238 .73 .918 r
.5088 .64568 .52552 .64991 .55623 .64915 .5398 .64468 Metetra
.358 .799 .959 r
.5398 .64468 .55623 .64915 .58738 .64574 .57126 .641 Metetra
.461 .85 .98 r
.57126 .641 .58738 .64574 .61891 .63968 .60312 .63462 Metetra
.547 .885 .987 r
.60312 .63462 .61891 .63968 .65075 .63092 .63532 .62552 Metetra
.618 .907 .984 r
.63532 .62552 .65075 .63092 .68284 .61947 .66778 .61369 Metetra
.675 .921 .974 r
.66778 .61369 .68284 .61947 .71512 .60534 .70043 .59914 Metetra
.721 .929 .959 r
.70043 .59914 .71512 .60534 .74751 .58855 .73321 .5819 Metetra
.759 .932 .943 r
.73321 .5819 .74751 .58855 .77994 .56912 .76604 .56199 Metetra
.79 .933 .926 r
.76604 .56199 .77994 .56912 .81235 .54709 .79886 .53946 Metetra
.816 .931 .908 r
.79886 .53946 .81235 .54709 .84466 .52252 .83158 .51435 Metetra
.837 .929 .891 r
.83158 .51435 .84466 .52252 .8768 .49547 .86415 .48674 Metetra
.856 .926 .874 r
.86415 .48674 .8768 .49547 .90871 .46601 .89648 .4567 Metetra
.871 .922 .858 r
.89648 .4567 .90871 .46601 .94032 .43423 .92851 .42432 Metetra
.463 0 0 r
.3171 .59337 .33552 .59837 .36264 .61227 .34438 .60719 Metetra
.357 0 0 r
.34438 .60719 .36264 .61227 .39053 .62386 .37243 .61869 Metetra
.234 0 0 r
.37243 .61869 .39053 .62386 .41913 .63307 .40123 .62777 Metetra
0 .478 .754 r
.40123 .62777 .41913 .63307 .44841 .63983 .43073 .63435 Metetra
.044 .587 .844 r
.43073 .63435 .44841 .63983 .47832 .64405 .46088 .63838 Metetra
.181 .681 .913 r
.46088 .63838 .47832 .64405 .5088 .64568 .49163 .63978 Metetra
.306 .756 .959 r
.49163 .63978 .5088 .64568 .5398 .64468 .52291 .63852 Metetra
.415 .812 .985 r
.52291 .63852 .5398 .64468 .57126 .641 .55468 .63454 Metetra
.507 .851 .995 r
.55468 .63454 .57126 .641 .60312 .63462 .58687 .62783 Metetra
.582 .878 .993 r
.58687 .62783 .60312 .63462 .63532 .62552 .6194 .61837 Metetra
.643 .895 .984 r
.6194 .61837 .63532 .62552 .66778 .61369 .65222 .60615 Metetra
.693 .905 .971 r
.65222 .60615 .66778 .61369 .70043 .59914 .68525 .59117 Metetra
.734 .91 .955 r
.68525 .59117 .70043 .59914 .73321 .5819 .71841 .57347 Metetra
.767 .912 .937 r
.71841 .57347 .73321 .5819 .76604 .56199 .75164 .55308 Metetra
.795 .912 .92 r
.75164 .55308 .76604 .56199 .79886 .53946 .78486 .53003 Metetra
.818 .911 .902 r
.78486 .53003 .79886 .53946 .83158 .51435 .818 .50438 Metetra
.838 .908 .885 r
.818 .50438 .83158 .51435 .86415 .48674 .85099 .47621 Metetra
.855 .906 .869 r
.85099 .47621 .86415 .48674 .89648 .4567 .88374 .44559 Metetra
.869 .903 .853 r
.88374 .44559 .89648 .4567 .92851 .42432 .9162 .41261 Metetra
.413 0 0 r
.2983 .58678 .3171 .59337 .34438 .60719 .32571 .60049 Metetra
.295 0 0 r
.32571 .60049 .34438 .60719 .37243 .61869 .35393 .61185 Metetra
0 .414 .728 r
.35393 .61185 .37243 .61869 .40123 .62777 .38291 .62077 Metetra
0 .526 .824 r
.38291 .62077 .40123 .62777 .43073 .63435 .41262 .62717 Metetra
.119 .625 .9 r
.41262 .62717 .43073 .63435 .46088 .63838 .443 .63098 Metetra
.249 .706 .952 r
.443 .63098 .46088 .63838 .49163 .63978 .474 .63213 Metetra
.364 .768 .984 r
.474 .63213 .49163 .63978 .52291 .63852 .50557 .63058 Metetra
.462 .813 .997 r
.50557 .63058 .52291 .63852 .55468 .63454 .53764 .62629 Metetra
.543 .844 .999 r
.53764 .62629 .55468 .63454 .58687 .62783 .57014 .61923 Metetra
.609 .865 .991 r
.57014 .61923 .58687 .62783 .6194 .61837 .60301 .60939 Metetra
.662 .878 .979 r
.60301 .60939 .6194 .61837 .65222 .60615 .63618 .59676 Metetra
.706 .885 .963 r
.63618 .59676 .65222 .60615 .68525 .59117 .66957 .58135 Metetra
.742 .889 .946 r
.66957 .58135 .68525 .59117 .71841 .57347 .70312 .56318 Metetra
.772 .891 .929 r
.70312 .56318 .71841 .57347 .75164 .55308 .73674 .54229 Metetra
.797 .891 .912 r
.73674 .54229 .75164 .55308 .78486 .53003 .77036 .51872 Metetra
.818 .89 .895 r
.77036 .51872 .78486 .53003 .818 .50438 .80391 .49253 Metetra
.836 .888 .878 r
.80391 .49253 .818 .50438 .85099 .47621 .83731 .4638 Metetra
.852 .886 .863 r
.83731 .4638 .85099 .47621 .88374 .44559 .87048 .43259 Metetra
.865 .883 .847 r
.87048 .43259 .88374 .44559 .9162 .41261 .90336 .39902 Metetra
.355 0 0 r
.27911 .5785 .2983 .58678 .32571 .60049 .30665 .59209 Metetra
0 .348 .695 r
.30665 .59209 .32571 .60049 .35393 .61185 .33502 .60329 Metetra
0 .462 .797 r
.33502 .60329 .35393 .61185 .38291 .62077 .36418 .61202 Metetra
.054 .565 .879 r
.36418 .61202 .38291 .62077 .41262 .62717 .39408 .6182 Metetra
.189 .652 .939 r
.39408 .6182 .41262 .62717 .443 .63098 .42469 .62177 Metetra
.309 .72 .976 r
.42469 .62177 .443 .63098 .474 .63213 .45594 .62265 Metetra
.413 .771 .995 r
.45594 .62265 .474 .63213 .50557 .63058 .48777 .62079 Metetra
.499 .807 1 r
.48777 .62079 .50557 .63058 .53764 .62629 .52013 .61617 Metetra
.57 .832 .995 r
.52013 .61617 .53764 .62629 .57014 .61923 .55294 .60875 Metetra
.628 .848 .984 r
.55294 .60875 .57014 .61923 .60301 .60939 .58614 .59851 Metetra
.675 .859 .969 r
.58614 .59851 .60301 .60939 .63618 .59676 .61965 .58545 Metetra
.714 .865 .953 r
.61965 .58545 .63618 .59676 .66957 .58135 .65341 .56959 Metetra
.747 .868 .936 r
.65341 .56959 .66957 .58135 .70312 .56318 .68733 .55095 Metetra
.774 .87 .919 r
.68733 .55095 .70312 .56318 .73674 .54229 .72134 .52955 Metetra
.797 .87 .902 r
.72134 .52955 .73674 .54229 .77036 .51872 .75536 .50546 Metetra
.816 .869 .886 r
.75536 .50546 .77036 .51872 .80391 .49253 .78931 .47872 Metetra
.833 .868 .87 r
.78931 .47872 .80391 .49253 .83731 .4638 .82312 .44942 Metetra
.848 .866 .855 r
.82312 .44942 .83731 .4638 .87048 .43259 .8567 .41764 Metetra
.861 .864 .841 r
.8567 .41764 .87048 .43259 .90336 .39902 .89 .38347 Metetra
0 .28 .657 r
.25956 .56849 .27911 .5785 .30665 .59209 .28721 .58191 Metetra
0 .394 .763 r
.28721 .58191 .30665 .59209 .33502 .60329 .31571 .59292 Metetra
0 .501 .852 r
.31571 .59292 .33502 .60329 .36418 .61202 .34504 .60144 Metetra
.125 .593 .919 r
.34504 .60144 .36418 .61202 .39408 .6182 .37514 .60738 Metetra
.25 .668 .963 r
.37514 .60738 .39408 .6182 .42469 .62177 .40596 .61067 Metetra
.36 .725 .988 r
.40596 .61067 .42469 .62177 .45594 .62265 .43744 .61125 Metetra
.452 .767 .996 r
.43744 .61125 .45594 .62265 .48777 .62079 .46953 .60907 Metetra
.528 .796 .994 r
.46953 .60907 .48777 .62079 .52013 .61617 .50217 .6041 Metetra
.591 .816 .986 r
.50217 .6041 .52013 .61617 .55294 .60875 .53528 .59629 Metetra
.642 .83 .972 r
.53528 .59629 .55294 .60875 .58614 .59851 .5688 .58564 Metetra
.684 .838 .957 r
.5688 .58564 .58614 .59851 .61965 .58545 .60265 .57215 Metetra
.72 .844 .941 r
.60265 .57215 .61965 .58545 .65341 .56959 .63676 .55583 Metetra
.749 .847 .924 r
.63676 .55583 .65341 .56959 .68733 .55095 .67105 .53669 Metetra
.774 .848 .908 r
.67105 .53669 .68733 .55095 .72134 .52955 .70543 .51479 Metetra
.795 .849 .892 r
.70543 .51479 .72134 .52955 .75536 .50546 .73984 .49016 Metetra
.813 .849 .876 r
.73984 .49016 .75536 .50546 .78931 .47872 .77419 .46288 Metetra
.829 .848 .861 r
.77419 .46288 .78931 .47872 .82312 .44942 .8084 .43302 Metetra
.843 .847 .847 r
.8084 .43302 .82312 .44942 .8567 .41764 .8424 .40066 Metetra
.855 .846 .834 r
.8424 .40066 .8567 .41764 .89 .38347 .87611 .36589 Metetra
0 .325 .724 r
.23965 .55666 .25956 .56849 .28721 .58191 .2674 .56988 Metetra
0 .433 .818 r
.2674 .56988 .28721 .58191 .31571 .59292 .29604 .58068 Metetra
.058 .53 .893 r
.29604 .58068 .31571 .59292 .34504 .60144 .32552 .58895 Metetra
.188 .611 .944 r
.32552 .58895 .34504 .60144 .37514 .60738 .35579 .59462 Metetra
.303 .675 .975 r
.35579 .59462 .37514 .60738 .40596 .61067 .38681 .59762 Metetra
.401 .723 .989 r
.38681 .59762 .40596 .61067 .43744 .61125 .41852 .59788 Metetra
.483 .757 .991 r
.41852 .59788 .43744 .61125 .46953 .60907 .45086 .59535 Metetra
.551 .782 .984 r
.45086 .59535 .46953 .60907 .50217 .6041 .48377 .58999 Metetra
.606 .799 .973 r
.48377 .58999 .50217 .6041 .53528 .59629 .51717 .58179 Metetra
.652 .81 .959 r
.51717 .58179 .53528 .59629 .5688 .58564 .551 .57071 Metetra
.69 .818 .944 r
.551 .57071 .5688 .58564 .60265 .57215 .58518 .55677 Metetra
.722 .823 .928 r
.58518 .55677 .60265 .57215 .63676 .55583 .61963 .53997 Metetra
.749 .826 .912 r
.61963 .53997 .63676 .55583 .67105 .53669 .65427 .52034 Metetra
.772 .828 .896 r
.65427 .52034 .67105 .53669 .70543 .51479 .68903 .49792 Metetra
.792 .829 .881 r
.68903 .49792 .70543 .51479 .73984 .49016 .72382 .47276 Metetra
.809 .829 .866 r
.72382 .47276 .73984 .49016 .77419 .46288 .75857 .44493 Metetra
.824 .829 .852 r
.75857 .44493 .77419 .46288 .8084 .43302 .79318 .4145 Metetra
.837 .829 .839 r
.79318 .4145 .8084 .43302 .8424 .40066 .82758 .38157 Metetra
.849 .828 .827 r
.82758 .38157 .8424 .40066 .87611 .36589 .8617 .34623 Metetra
0 .364 .779 r
.21941 .54295 .23965 .55666 .2674 .56988 .24725 .55595 Metetra
0 .465 .86 r
.24725 .55595 .2674 .56988 .29604 .58068 .276 .56649 Metetra
.122 .551 .92 r
.276 .56649 .29604 .58068 .32552 .58895 .30562 .57448 Metetra
.242 .621 .957 r
.30562 .57448 .32552 .58895 .35579 .59462 .33606 .57986 Metetra
.347 .675 .977 r
.33606 .57986 .35579 .59462 .38681 .59762 .36727 .58253 Metetra
.435 .715 .983 r
.36727 .58253 .38681 .59762 .41852 .59788 .39919 .58244 Metetra
.508 .745 .98 r
.39919 .58244 .41852 .59788 .45086 .59535 .43177 .57954 Metetra
.568 .765 .971 r
.43177 .57954 .45086 .59535 .48377 .58999 .46493 .57379 Metetra
.618 .78 .959 r
.46493 .57379 .48377 .58999 .51717 .58179 .49862 .56516 Metetra
.659 .791 .945 r
.49862 .56516 .51717 .58179 .551 .57071 .53274 .55365 Metetra
.694 .798 .929 r
.53274 .55365 .551 .57071 .58518 .55677 .56724 .53924 Metetra
.723 .803 .914 r
.56724 .53924 .58518 .55677 .61963 .53997 .60203 .52195 Metetra
.748 .806 .899 r
.60203 .52195 .61963 .53997 .65427 .52034 .63702 .50182 Metetra
.769 .808 .884 r
.63702 .50182 .65427 .52034 .68903 .49792 .67214 .47888 Metetra
.788 .81 .87 r
.67214 .47888 .68903 .49792 .72382 .47276 .70731 .45319 Metetra
.804 .811 .856 r
.70731 .45319 .72382 .47276 .75857 .44493 .74244 .42481 Metetra
.819 .811 .843 r
.74244 .42481 .75857 .44493 .79318 .4145 .77744 .39382 Metetra
.832 .811 .831 r
.77744 .39382 .79318 .4145 .82758 .38157 .81224 .36032 Metetra
.843 .812 .819 r
.81224 .36032 .82758 .38157 .8617 .34623 .84676 .3244 Metetra
0 .396 .822 r
.19885 .52731 .21941 .54295 .24725 .55595 .22677 .54003 Metetra
.054 .488 .889 r
.22677 .54003 .24725 .55595 .276 .56649 .25562 .55029 Metetra
.179 .564 .935 r
.25562 .55029 .276 .56649 .30562 .57448 .28536 .55798 Metetra
.289 .625 .961 r
.28536 .55798 .30562 .57448 .33606 .57986 .31595 .56302 Metetra
.383 .671 .972 r
.31595 .56302 .33606 .57986 .36727 .58253 .34734 .56534 Metetra
.462 .705 .973 r
.34734 .56534 .36727 .58253 .39919 .58244 .37947 .56488 Metetra
.527 .73 .967 r
.37947 .56488 .39919 .58244 .43177 .57954 .41227 .56158 Metetra
.581 .749 .957 r
.41227 .56158 .43177 .57954 .46493 .57379 .44568 .55542 Metetra
.626 .762 .944 r
.44568 .55542 .46493 .57379 .49862 .56516 .47963 .54635 Metetra
.664 .771 .93 r
.47963 .54635 .49862 .56516 .53274 .55365 .51405 .53437 Metetra
.696 .778 .915 r
.51405 .53437 .53274 .55365 .56724 .53924 .54885 .51949 Metetra
.723 .784 .901 r
.54885 .51949 .56724 .53924 .60203 .52195 .58396 .50171 Metetra
.746 .787 .886 r
.58396 .50171 .60203 .52195 .63702 .50182 .6193 .48106 Metetra
.766 .79 .872 r
.6193 .48106 .63702 .50182 .67214 .47888 .65477 .4576 Metetra
.784 .792 .859 r
.65477 .4576 .67214 .47888 .70731 .45319 .6903 .43136 Metetra
.799 .793 .846 r
.6903 .43136 .70731 .45319 .74244 .42481 .72581 .40244 Metetra
.813 .794 .834 r
.72581 .40244 .74244 .42481 .77744 .39382 .76119 .3709 Metetra
.826 .795 .823 r
.76119 .3709 .77744 .39382 .81224 .36032 .79638 .33684 Metetra
.837 .795 .811 r
.79638 .33684 .81224 .36032 .84676 .3244 .8313 .30036 Metetra
0 .422 .854 r
.17799 .50965 .19885 .52731 .22677 .54003 .20597 .52208 Metetra
.113 .504 .907 r
.20597 .52208 .22677 .54003 .25562 .55029 .23491 .53201 Metetra
.228 .571 .94 r
.23491 .53201 .25562 .55029 .28536 .55798 .26477 .53936 Metetra
.328 .623 .958 r
.26477 .53936 .28536 .55798 .31595 .56302 .2955 .54404 Metetra
.413 .663 .963 r
.2955 .54404 .31595 .56302 .34734 .56534 .32705 .54598 Metetra
.484 .693 .96 r
.32705 .54598 .34734 .56534 .37947 .56488 .35937 .54512 Metetra
.542 .715 .952 r
.35937 .54512 .37947 .56488 .41227 .56158 .39238 .54141 Metetra
.591 .732 .941 r
.39238 .54141 .41227 .56158 .44568 .55542 .42603 .5348 Metetra
.632 .744 .928 r
.42603 .5348 .44568 .55542 .47963 .54635 .46024 .52528 Metetra
.667 .753 .915 r
.46024 .52528 .47963 .54635 .51405 .53437 .49493 .51283 Metetra
.696 .76 .901 r
.49493 .51283 .51405 .53437 .54885 .51949 .53003 .49745 Metetra
.721 .765 .887 r
.53003 .49745 .54885 .51949 .58396 .50171 .56545 .47917 Metetra
.743 .769 .874 r
.56545 .47917 .58396 .50171 .6193 .48106 .60111 .458 Metetra
.762 .772 .861 r
.60111 .458 .6193 .48106 .65477 .4576 .63693 .43401 Metetra
.779 .774 .849 r
.63693 .43401 .65477 .4576 .6903 .43136 .67282 .40724 Metetra
.794 .776 .837 r
.67282 .40724 .6903 .43136 .72581 .40244 .70869 .37777 Metetra
.807 .778 .825 r
.70869 .37777 .72581 .40244 .76119 .3709 .74445 .34568 Metetra
.82 .779 .814 r
.74445 .34568 .76119 .3709 .79638 .33684 .78002 .31107 Metetra
.831 .78 .804 r
.78002 .31107 .79638 .33684 .8313 .30036 .81532 .27404 Metetra
.045 .441 .874 r
.15686 .48994 .17799 .50965 .20597 .52208 .18489 .50202 Metetra
.165 .514 .915 r
.18489 .50202 .20597 .52208 .23491 .53201 .21391 .5116 Metetra
.271 .573 .939 r
.21391 .5116 .23491 .53201 .26477 .53936 .24387 .51858 Metetra
.361 .618 .95 r
.24387 .51858 .26477 .53936 .2955 .54404 .27473 .52287 Metetra
.437 .653 .951 r
.27473 .52287 .2955 .54404 .32705 .54598 .30643 .5244 Metetra
.501 .68 .946 r
.30643 .5244 .32705 .54598 .35937 .54512 .33892 .52311 Metetra
.554 .7 .937 r
.33892 .52311 .35937 .54512 .39238 .54141 .37213 .51895 Metetra
.599 .715 .926 r
.37213 .51895 .39238 .54141 .42603 .5348 .40599 .51188 Metetra
.636 .727 .913 r
.40599 .51188 .42603 .5348 .46024 .52528 .44044 .50188 Metetra
.668 .735 .9 r
.44044 .50188 .46024 .52528 .49493 .51283 .4754 .48894 Metetra
.696 .742 .887 r
.4754 .48894 .49493 .51283 .53003 .49745 .51078 .47306 Metetra
.719 .748 .874 r
.51078 .47306 .53003 .49745 .56545 .47917 .54651 .45426 Metetra
.74 .752 .862 r
.54651 .45426 .56545 .47917 .60111 .458 .58249 .43258 Metetra
.758 .755 .85 r
.58249 .43258 .60111 .458 .63693 .43401 .61864 .40805 Metetra
.774 .758 .838 r
.61864 .40805 .63693 .43401 .67282 .40724 .65487 .38074 Metetra
.789 .76 .827 r
.65487 .38074 .67282 .40724 .70869 .37777 .69109 .35073 Metetra
.802 .762 .817 r
.69109 .35073 .70869 .37777 .74445 .34568 .72722 .31811 Metetra
.814 .764 .806 r
.72722 .31811 .74445 .34568 .78002 .31107 .76316 .28296 Metetra
.824 .765 .797 r
.76316 .28296 .78002 .31107 .81532 .27404 .79884 .2454 Metetra
.099 .455 .885 r
.13549 .46811 .15686 .48994 .18489 .50202 .16355 .47981 Metetra
.21 .52 .916 r
.16355 .47981 .18489 .50202 .21391 .5116 .19263 .489 Metetra
.306 .571 .933 r
.19263 .489 .21391 .5116 .24387 .51858 .22268 .49556 Metetra
.388 .611 .939 r
.22268 .49556 .24387 .51858 .27473 .52287 .25364 .49943 Metetra
.457 .643 .937 r
.25364 .49943 .27473 .52287 .30643 .5244 .28548 .50052 Metetra
.515 .666 .931 r
.28548 .50052 .30643 .5244 .33892 .52311 .31813 .49878 Metetra
.564 .685 .921 r
.31813 .49878 .33892 .52311 .37213 .51895 .35153 .49415 Metetra
.604 .699 .91 r
.35153 .49415 .37213 .51895 .40599 .51188 .3856 .4866 Metetra
.639 .71 .898 r
.3856 .4866 .40599 .51188 .44044 .50188 .42028 .47611 Metetra
.669 .719 .886 r
.42028 .47611 .44044 .50188 .4754 .48894 .45549 .46267 Metetra
.694 .726 .874 r
.45549 .46267 .4754 .48894 .51078 .47306 .49114 .44627 Metetra
.717 .731 .862 r
.49114 .44627 .51078 .47306 .54651 .45426 .52715 .42695 Metetra
.736 .736 .85 r
.52715 .42695 .54651 .45426 .58249 .43258 .56343 .40474 Metetra
.754 .74 .839 r
.56343 .40474 .58249 .43258 .61864 .40805 .5999 .37968 Metetra
.769 .743 .828 r
.5999 .37968 .61864 .40805 .65487 .38074 .63646 .35184 Metetra
.783 .745 .818 r
.63646 .35184 .65487 .38074 .69109 .35073 .67303 .32129 Metetra
.796 .748 .808 r
.67303 .32129 .69109 .35073 .72722 .31811 .70951 .28813 Metetra
.808 .75 .799 r
.70951 .28813 .72722 .31811 .76316 .28296 .74581 .25246 Metetra
.818 .751 .789 r
.74581 .25246 .76316 .28296 .79884 .2454 .78186 .21439 Metetra
.146 .464 .89 r
.11389 .44411 .13549 .46811 .16355 .47981 .14198 .4554 Metetra
.249 .521 .912 r
.14198 .4554 .16355 .47981 .19263 .489 .17111 .46415 Metetra
.336 .567 .923 r
.17111 .46415 .19263 .489 .22268 .49556 .20122 .47028 Metetra
.411 .603 .926 r
.20122 .47028 .22268 .49556 .25364 .49943 .23229 .47368 Metetra
.474 .631 .922 r
.23229 .47368 .25364 .49943 .28548 .50052 .26425 .47431 Metetra
.526 .653 .915 r
.26425 .47431 .28548 .50052 .31813 .49878 .29704 .47208 Metetra
.571 .67 .906 r
.29704 .47208 .31813 .49878 .35153 .49415 .33061 .46696 Metetra
.608 .684 .895 r
.33061 .46696 .35153 .49415 .3856 .4866 .36487 .45891 Metetra
.641 .694 .884 r
.36487 .45891 .3856 .4866 .42028 .47611 .39976 .44791 Metetra
.669 .703 .873 r
.39976 .44791 .42028 .47611 .45549 .46267 .4352 .43394 Metetra
.693 .71 .861 r
.4352 .43394 .45549 .46267 .49114 .44627 .47111 .41702 Metetra
.714 .716 .85 r
.47111 .41702 .49114 .44627 .52715 .42695 .50739 .39717 Metetra
.733 .72 .839 r
.50739 .39717 .52715 .42695 .56343 .40474 .54397 .37443 Metetra
.749 .725 .829 r
.54397 .37443 .56343 .40474 .5999 .37968 .58074 .34884 Metetra
.764 .728 .819 r
.58074 .34884 .5999 .37968 .63646 .35184 .61762 .32047 Metetra
.778 .731 .809 r
.61762 .32047 .63646 .35184 .67303 .32129 .65452 .2894 Metetra
.79 .734 .8 r
.65452 .2894 .67303 .32129 .70951 .28813 .69134 .25572 Metetra
.802 .736 .791 r
.69134 .25572 .70951 .28813 .74581 .25246 .72799 .21954 Metetra
.812 .738 .782 r
.72799 .21954 .74581 .25246 .78186 .21439 .76439 .18098 Metetra
.188 .469 .888 r
.09211 .4179 .11389 .44411 .14198 .4554 .12021 .42874 Metetra
.282 .52 .905 r
.12021 .42874 .14198 .4554 .17111 .46415 .14936 .43702 Metetra
.362 .562 .912 r
.14936 .43702 .17111 .46415 .20122 .47028 .17954 .44266 Metetra
.43 .594 .912 r
.17954 .44266 .20122 .47028 .23229 .47368 .21069 .44558 Metetra
.487 .62 .908 r
.21069 .44558 .23229 .47368 .26425 .47431 .24275 .4457 Metetra
.535 .64 .9 r
.24275 .4457 .26425 .47431 .29704 .47208 .27567 .44297 Metetra
.576 .656 .891 r
.27567 .44297 .29704 .47208 .33061 .46696 .30939 .43734 Metetra
.611 .669 .881 r
.30939 .43734 .33061 .46696 .36487 .45891 .34383 .42876 Metetra
.642 .679 .87 r
.34383 .42876 .36487 .45891 .39976 .44791 .37893 .41723 Metetra
.668 .688 .86 r
.37893 .41723 .39976 .44791 .4352 .43394 .41458 .40273 Metetra
.691 .695 .849 r
.41458 .40273 .4352 .43394 .47111 .41702 .45073 .38528 Metetra
.711 .701 .839 r
.45073 .38528 .47111 .41702 .50739 .39717 .48727 .36489 Metetra
.729 .706 .829 r
.48727 .36489 .50739 .39717 .54397 .37443 .52412 .34161 Metetra
.745 .71 .819 r
.52412 .34161 .54397 .37443 .58074 .34884 .56118 .31549 Metetra
.76 .714 .81 r
.56118 .31549 .58074 .34884 .61762 .32047 .59836 .2866 Metetra
.773 .717 .801 r
.59836 .2866 .61762 .32047 .65452 .2894 .63558 .25502 Metetra
.785 .72 .792 r
.63558 .25502 .65452 .2894 .69134 .25572 .67272 .22084 Metetra
.796 .723 .783 r
.67272 .22084 .69134 .25572 .72799 .21954 .70972 .18417 Metetra
.806 .725 .775 r
.70972 .18417 .72799 .21954 .76439 .18098 .74646 .14513 Metetra
.224 .471 .884 r
.07018 .38945 .09211 .4179 .12021 .42874 .09827 .39978 Metetra
.31 .518 .896 r
.09827 .39978 .12021 .42874 .14936 .43702 .12744 .40756 Metetra
.383 .555 .9 r
.12744 .40756 .14936 .43702 .17954 .44266 .15766 .41269 Metetra
.445 .584 .898 r
.15766 .41269 .17954 .44266 .21069 .44558 .18887 .41508 Metetra
.498 .608 .893 r
.18887 .41508 .21069 .44558 .24275 .4457 .22102 .41468 Metetra
.542 .627 .885 r
.22102 .41468 .24275 .4457 .27567 .44297 .25406 .41141 Metetra
.58 .642 .877 r
.25406 .41141 .27567 .44297 .30939 .43734 .28792 .40523 Metetra
.613 .655 .867 r
.28792 .40523 .30939 .43734 .34383 .42876 .32252 .39611 Metetra
.642 .665 .857 r
.32252 .39611 .34383 .42876 .37893 .41723 .35779 .38404 Metetra
.667 .674 .847 r
.35779 .38404 .37893 .41723 .41458 .40273 .39365 .36899 Metetra
.688 .681 .838 r
.39365 .36899 .41458 .40273 .45073 .38528 .43002 .351 Metetra
.708 .687 .828 r
.43002 .351 .45073 .38528 .48727 .36489 .4668 .33007 Metetra
.725 .692 .819 r
.4668 .33007 .48727 .36489 .52412 .34161 .50391 .30626 Metetra
.741 .697 .81 r
.50391 .30626 .52412 .34161 .56118 .31549 .54124 .27961 Metetra
.755 .701 .801 r
.54124 .27961 .56118 .31549 .59836 .2866 .57872 .25021 Metetra
.768 .704 .792 r
.57872 .25021 .59836 .2866 .63558 .25502 .61623 .21812 Metetra
.779 .708 .784 r
.61623 .21812 .63558 .25502 .67272 .22084 .65369 .18345 Metetra
.79 .71 .776 r
.65369 .18345 .67272 .22084 .70972 .18417 .691 .14631 Metetra
.8 .713 .769 r
.691 .14631 .70972 .18417 .74646 .14513 .72808 .10682 Metetra
.255 .471 .876 r
.04812 .35871 .07018 .38945 .09827 .39978 .07619 .36851 Metetra
.334 .513 .885 r
.07619 .36851 .09827 .39978 .12744 .40756 .10537 .37574 Metetra
.401 .547 .886 r
.10537 .37574 .12744 .40756 .15766 .41269 .13561 .38032 Metetra
.458 .575 .884 r
.13561 .38032 .15766 .41269 .18887 .41508 .16687 .38216 Metetra
.506 .597 .879 r
.16687 .38216 .18887 .41508 .22102 .41468 .1991 .38119 Metetra
.548 .615 .871 r
.1991 .38119 .22102 .41468 .25406 .41141 .23223 .37736 Metetra
.584 .63 .863 r
.23223 .37736 .25406 .41141 .28792 .40523 .26621 .37062 Metetra
.614 .642 .854 r
.26621 .37062 .28792 .40523 .32252 .39611 .30096 .36094 Metetra
.641 .652 .845 r
.30096 .36094 .32252 .39611 .35779 .38404 .33639 .3483 Metetra
.665 .66 .836 r
.33639 .3483 .35779 .38404 .39365 .36899 .37244 .3327 Metetra
.686 .668 .827 r
.37244 .3327 .39365 .36899 .43002 .351 .40901 .31415 Metetra
.704 .674 .818 r
.40901 .31415 .43002 .351 .4668 .33007 .44602 .29269 Metetra
.721 .679 .809 r
.44602 .29269 .4668 .33007 .50391 .30626 .48337 .26834 Metetra
.736 .684 .8 r
.48337 .26834 .50391 .30626 .54124 .27961 .52096 .24118 Metetra
.75 .688 .792 r
.52096 .24118 .54124 .27961 .57872 .25021 .55871 .21127 Metetra
.762 .692 .784 r
.55871 .21127 .57872 .25021 .61623 .21812 .5965 .17869 Metetra
.774 .696 .777 r
.5965 .17869 .61623 .21812 .65369 .18345 .63426 .14356 Metetra
.785 .699 .769 r
.63426 .14356 .65369 .18345 .691 .14631 .67188 .10597 Metetra
.794 .701 .762 r
.67188 .10597 .691 .14631 .72808 .10682 .70927 .06605 Metetra
.282 .47 .867 r
.02598 .32567 .04812 .35871 .07619 .36851 .05402 .33489 Metetra
.354 .508 .873 r
.05402 .33489 .07619 .36851 .10537 .37574 .08318 .34154 Metetra
.416 .54 .873 r
.08318 .34154 .10537 .37574 .13561 .38032 .11343 .34553 Metetra
.469 .565 .87 r
.11343 .34553 .13561 .38032 .16687 .38216 .14473 .34678 Metetra
.514 .586 .865 r
.14473 .34678 .16687 .38216 .1991 .38119 .17702 .34522 Metetra
.553 .603 .858 r
.17702 .34522 .1991 .38119 .23223 .37736 .21023 .3408 Metetra
.586 .617 .85 r
.21023 .3408 .23223 .37736 .26621 .37062 .24431 .33348 Metetra
.615 .629 .842 r
.24431 .33348 .26621 .37062 .30096 .36094 .27918 .32322 Metetra
.641 .639 .833 r
.27918 .32322 .30096 .36094 .33639 .3483 .31477 .31001 Metetra
.663 .648 .824 r
.31477 .31001 .33639 .3483 .37244 .3327 .35098 .29384 Metetra
.683 .655 .816 r
.35098 .29384 .37244 .3327 .40901 .31415 .38774 .27474 Metetra
.701 .661 .808 r
.38774 .27474 .40901 .31415 .44602 .29269 .42495 .25273 Metetra
.717 .667 .8 r
.42495 .25273 .44602 .29269 .48337 .26834 .46253 .22785 Metetra
.732 .672 .792 r
.46253 .22785 .48337 .26834 .52096 .24118 .50036 .20017 Metetra
.745 .676 .784 r
.50036 .20017 .52096 .24118 .55871 .21127 .53836 .16977 Metetra
.757 .68 .777 r
.53836 .16977 .55871 .21127 .5965 .17869 .57642 .13672 Metetra
.769 .684 .769 r
.57642 .13672 .5965 .17869 .63426 .14356 .61446 .10114 Metetra
.779 .687 .762 r
.61446 .10114 .63426 .14356 .67188 .10597 .65237 .06312 Metetra
.789 .69 .756 r
.65237 .06312 .67188 .10597 .70927 .06605 .69006 .02281 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.9)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.91)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.92)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.93)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.94)] .53743 .04564 .73714 1 Mshowa
.125 Mabswid
.06033 .24606 m
.06319 .24877 L
s
.08372 .23691 m
.08655 .23964 L
s
.10732 .22766 m
.11013 .23042 L
s
.13115 .21833 m
.13394 .22111 L
s
.17948 .19941 m
.18222 .20223 L
s
.20399 .18981 m
.2067 .19266 L
s
.22873 .18012 m
.23142 .183 L
s
.25371 .17034 m
.25638 .17324 L
s
.3044 .15049 m
.30701 .15344 L
s
.33011 .14043 m
.3327 .14339 L
s
.35608 .13026 m
.35864 .13325 L
s
.3823 .11999 m
.38483 .12301 L
s
.43553 .09915 m
.43799 .10222 L
s
.46254 .08857 m
.46497 .09167 L
s
.48982 .07789 m
.49222 .08101 L
s
.51738 .0671 m
.51975 .07024 L
s
.57333 .04519 m
.57563 .04838 L
s
.60174 .03407 m
.60401 .03728 L
s
.63044 .02283 m
.63267 .02607 L
s
.65944 .01147 m
.66163 .01474 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00dWoo00YonDP00000000=FimoogoiB001]P=oo`04IT000000=]`mOol00=Aoo`03
Oc8fg7oo00Moo`05OoU:FGooOomJEP0mOol00=Aoo`03Oc8fg7oo00Qoo`04FUIoogoiBUTmOol00=Ao
o`03Oc8fg7oo00Qoo`04IT000000=]`mOol00==oo`03FK9W<SKL00Qoo`05OoU9]WooOoU9]P0mOol0
0<ioo`8000=oo`03Oc8003KL00Uoo`04L/d00000BclmOol00<aoo`D004moo`00bGoo0`000goo0P00
Cgoo002GOol016H5000001HI0Woo00=om2P00;000goo00A0X000000F6@=oo`04IPD00005@clIOol2
0006Ool00`00Ool0001>Ool009Moo`05@E1oogoo@:YCo`0:Ool00d2ZDomoo`02Ool00gj:5QUoo`0F
Ool300000goo001oo`05Ool01000Oomoo`00CGoo002FOol01Wod:;1oogooDDE3?`Moo`07OXX00000
000ZWgod:0000P0000<01D<oOol04Woo0`002goo00@007ooOol004eoo`00UWoo00Iom2R`Oomooe55
@cl6Ool02god:0YCogooIPDZWgooDD0ZWgj:5QT04Woo0`003Goo00D007ooOomoo`0004aoo`00Ugoo
00E0YD<oOo@X2U?o00Ioo`0;Oo@X2U?oOom0ZU?oOomom2P5@PXF6@0?Ool3000?Ool20002Ool00`00
Ool0001;Ool009Moo`04Oc0D0000:Yl8Ool017j:000001HI0goo00=o<1@05QT03Goo0P004Goo00@0
06KH000000=oo`03001oogoo04Uoo`00]goo0`0000=oo`00Ool03goo00<006KHI]P00P0017oo00<0
07ooOol0B7oo002eOol2000DOol00`00I]QVf002I]P20004Ool00`00Oomoo`17Ool00;9oo`<001Eo
o`03001Vf6KH00=Vf08000Aoo`03001oogoo04Moo`00/7oo0P000Woo00<007ooOol04Woo00<006KH
I]P016KH00<006KH000017oo00<007ooOol0AWoo002]Ool3000HOol00`00I]QVf005I]P00`00I]P0
0003Ool20018Ool00:Yoo`@001Uoo`03001Vf6KH00IVf004001Vf6KH0004Ool00`00Oomoo`15Ool0
0:Qoo`8000=oo`03001oogoo01Ioo`03001Vf6KH00MVf004001Vf6KH0005Ool00`00Oomoo`14Ool0
07Eoo`04IPD000005QT2Ool00god:000/003Ool0142P000001HI0Woo00AV1@000001E1Yoo`<001eo
o`8000UVf005001Vf6KHI]P00004Ool00`00Oomoo`14Ool007Eoo`05@E1oogoo@:YCo`0:Ool0242Z
Domo<1B`Oomom2P5@clGOol200000goo001oo`0LOol01000H[QR^00026KH00<006KHI]P00P001Goo
00<007ooOol0@goo001dOol01Wod:;1oogooDDE3?`Moo`05OXX00000000ZW`02Ool00e50000ZW`0E
Ool3000POol01@00H[QR^6:h000026KH00<006KH00000VKH00<007ooOol00goo00<007ooOol0@Woo
001dOol01Wod:;1oogooDDE3?`Ioo`06Oo@X2U?oOomV1BZO0goo00=om2R`Ool04Woo0`008Goo00<0
06:hH[P00f:h00<006KHI]P01FKH0P000fKH00<007ooOol00Woo0P00A7oo001eOol01D2U@cmom2P:
Dol01Woo00aom2P:Domood2ZDomom2P5@cmom2P:Dol?Ool3000SOol00`00H[QR^004H[P00`00I]QV
f005I]P00`00I]QVf003I]P00`00Oomoo`03Ool00`00Oomoo`11Ool007Eoo`04Oc0D0000:Yl8Ool0
17j:000001HI0Woo00Ao<1@0000ZW`ioo`8002Eoo`03001R^6:h00IR^003001Vf6KH00=Vf08000EV
f003001oogoo00Aoo`03001oogoo041oo`00UWoo10009Goo00<006:hH[P01f:h00<006KHI]P00VKH
00<006KH00001FKH00<007ooOol017oo00<007ooOol0@7oo002COol3000XOol00`00H[QR^009H[P0
1000I]QVf0000VKH00<006KHI]P016KH00<007ooOol017oo00<007ooOol0?goo002AOol2000ZOol0
0`00H[QR^00:H[P00`00I]P00003I]P00`00I]QVf004I]P00`00Oomoo`05Ool00`00Oomoo`0nOol0
08ioo`<0009oo`03001oogoo02Ioo`8000eR^003001Vf6KH009Vf003001Vf6KH00EVf003001oogoo
00=oo`8000Eoo`0:OoU8000000003E^OOomonDP00KH3Ool016I0000003KL0Woo00Abc@00000fg2Ao
o`00S7oo0P00;Goo00@006:hH[P000]R^08000AVf003001Vf6KH00EVf003001oogoo00Eoo`03001o
ogoo00Aoo`03Oc8fg7oo00Moo`08OoU:FGooOomJEWooOiHe]P9oo`03FJeKWgoo029oo`00RGoo1000
;Goo00D006:hH[QR^00000YR^004001Vf6KH0003I]P00`00I]QVf004I]P00`00I]P00007Ool00`00
Oomoo`03Ool00glb=]aoo`08Ool015YFOomonDYI1Goo00=VCE^OOol08Woo001EOol016H5000001HI
0Woo00=om2P00;000goo00I0X000000F6GooOXX300000`0:Domoo`0JOol20004Ool00`00Oomoo`0Y
Ool00`00H[QR^003H[P00`00H[QR^006H[P01@00I]QVf6KH00000fKH00<006KHI]P00fKH00@006KH
I]P000Moo`03001oogoo00=oo`03Oc8fg7oo00Qoo`04IT000000=]`2Ool016I00000009I97oo001E
Ool01D5@Oomood2ZDol02Woo00I0ZU?oOom0X00:DolJOol3000aOol00`00H[QR^004H[P00`00H[QR
^005H[P00`00I]QVf003I]P01000I]QVf00016KH00<006KHI]P00VKH00<007ooOol01Goo00L007oo
OomooeVbIc8fg008Ool01GoiBKIoogoiBKH00Woo00=VCE^OOol09Goo001DOol01Wod:;1oogooDDE3
?`Moo`05OXX00000000ZW`02Ool00gj:000ZW`0GOol20002Ool00`00Oomoo`0^Ool00`00H[QR^006
H[P00`00H[QR^003H[P00`00I]QVf004I]P01@00I]QVf6KH00000VKH00<006KHI]P00fKH00<007oo
Ool01Goo0P000Woo00=o<P00=]`02Goo00Abc@00001;?`9oo`04IT0000000UTTOol005Aoo`06Oo@X
/7ooOomAAD<o1Woo00Iom2P:DomoofH5:Yl3Ool00godDYmoo`0COol3000dOol00`00H[QR^007H[P0
0`00H[QR^002H[P00`00I]QVf005I]P01`00I]QVf6KH001Vf00000MVf003001oogoo00=oo`03001o
o`0003aoo`00EGoo00E0YD<oOo@X2U?o00Ioo`0<Oo@X2U?oOom0ZU?oOc0D/7ooOo@X2U?o47oo0`00
00=oo`00Ool0<goo00<006:hH[P02F:h00@006:hH[P000UVf003001Vf6KH008000QVf003001oogoo
00Ioo`03001oogoo03Uoo`00EGoo00Ao<1@0000ZW`Qoo`04OXX000005QT2Ool016H5000001HI3goo
0P00>7oo00<006:hH[P02V:h00<006:h00002VKH00@006KHI]P000YVf003001oogoo00Eoo`03001o
ogoo03Uoo`00Mgoo1000>7oo0P003F:h00<006KHI]P02VKH0`002VKH00<007ooOol01Woo00<007oo
Ool0>7oo001eOol2000kOol01000H[QR^0002f:h0P0036KH00<006KH00002fKH00<007ooOol01Woo
00<007ooOol0=goo001bOol3000lOol01@00H[QR^6:h00002V:h00@006;HH]P000YVf004001Vf000
000:I]P20007Ool2000iOol0071oo`80009oo`03001oogoo03Qoo`8000ER^003001R^6:h00IR^005
001Rf6;HH]P00009I]P00`00I]QVf0020009I]P01000I_QVn00027oo00<007ooOol0=Woo001]Ool3
000nOol00`00H[QR^005H[P00`00H[QR^005H[P00`00H]QRf003H]P00`00I]QVf005I]P00`00I]QV
f002I]P00`00I]QVf006I]P01@00I_QVn6Kh00002Goo00<007ooOol0=Goo001ZOol4000oOol00`00
H[QR^007H[P00`00H[QR^003H[P00`00H]QRf004H]P00`00I]QVf004I]P00`00I]QVf003I]P00`00
I]QVf005I]P00`00I_QVn003I_P00`00Oomoo`06Ool00`00Oomoo`0eOol003Ioo`04IPD000005QT2
Ool00god:000/003Ool01d2P000001HIOomom2P00080000300E3?goo01Yoo`8000Aoo`03001oogoo
03]oo`03001R^6:h00QR^003001R^6:h009R^003001Rf6;H00ERf003001Vf6KH00=Vf003001Vf6KH
00AVf08000EVf003001Vn6Kh00AVn003001oogoo00Moo`03001oogoo03Aoo`00=Woo00E1D7ooOom0
ZU?o00Yoo`06@:YCogooOomnRQHI6Woo1000@Woo00<006:hH[P02V:h00@006:hH[P000URf005001V
f6KHI]P00007I]P20004I]P00`00I_QVn006I_P00`00Oomoo`06Ool2000eOol003Eoo`06Oo@X/7oo
OomAAD<o1goo00EnRP00000002ZO009oo`03OXXF6Goo01Moo`8004Eoo`8000aR^003001R^00000YR
f004001Vf6KH0008I]P00`00I]P00002I]P00`00I_QVn007I_P00`00Oomoo`07Ool00`00Oomoo`0c
Ool003Eoo`06Oo@X/7ooOomAAD<o1Woo00Iom2P:DomoofH5:Yl2Ool00gj:5QUoo`0DOol30015Ool2
0002G[T00`00H[QR^00:H[P00`00H]QRf00:H]P20009I]P01@00I]P006KH00002fKh00<007ooOol0
1goo00<007ooOol0<Woo000fOol01D2U@cmom2P:Dol01Woo00Yom2P:Domood2ZDomood2ZDXXF6A=o
o`80009oo`03001oogoo049oo`03001N^Eji009N^@03001R^6:h00UR^08000aRf003001Vf6KH00QV
f004001Vf6KH000;I_P2000:Ool00`00Oomoo`0aOol003Ioo`04Oc0D0000:Yl8Ool017j:000001HI
0Woo00=nRP005QT047oo0`00B7oo00<005jiG[T015ji00<006:hH[P01f:h00@006;IH]T000YRf003
001Rf@0000UVf004001Vf000000:I_P01000I_UVn@002Goo00<007ooOol0<Goo001IOol200000goo
001oo`16Ool20007G[T00`00H[QR^006H[P01@00H]URfF;I00002F;H00@006;IH]T000UVf080009V
n@03001Vn6Kh00IVn005001VnFKiI_T0000:Ool00`00Oomoo`0`Ool005Ioo`<004Yoo`03001N^Eji
00QN^@03001R^6:h00=R^08000ERf@03001Rf6;H00ERf003001RfF;I009Rf@03001Vf6KH00IVf005
001VnFKiI_T00007I_P00`00I_UVn@03I_T00`00Oomoo`06Ool3000aOol005=oo`@004]oo`03001N
^Eji00UN^@03001R^6:h009R^003001RfF;I00ERf@03001Rf6;H00=Rf08000ERf@03001Vf6KH00EV
f08000AVn@03001Vn6Kh00=Vn003001VnFKi00AVn@03001oogoo00Qoo`03001oogoo02moo`00DGoo
0P00CWoo0P0035ji00@006:hH[P000URf@05001Rf6;HH]P00008H]T00`00I]QVf003I]P00`00I_T0
0004I_T00`00I_QVn003I_P00`00I_UVn@05I_T00`00Oomoo`08Ool00`00Oomoo`0^Ool004ioo`<0
04ioo`80009N^@03001N^Eji00UN^@03001R^00000YRf@04001Rf6;H0009H]T00`00I]QVf002I]P0
1@00I_UVnFKi000016Ki00D006KhI_QVn00000QVn@03001oogoo00Uoo`03001oogoo02eoo`0087oo
00Abc@00000fg09oo`03OoU8006f00=oo`04@:0000005QTLOol20002Ool2001<Ool00`00G[UN^@02
G[T00`00G[UN^@0:G[T00`00H]URf@0:H]T2000;H]T01000I]QVf00016Ki00<006KiI_T00VKi00@0
06KhI_P000YVn@03001oogoo00Qoo`03001oogoo02eoo`0087oo00EJEWooOomI/VOo00Yoo`03@:YC
ogoo01Moo`<0055oo`03001N^Eji00AN^@03001N^Eji00QN^@03001Nf@0000]Rf@03001RfF;I00YR
f@03001Vf00000EVn@03001VnFKi00=Vn@8000YVn@8000Yoo`8000Eoo`0:OoU8000000003E^OOomo
nDP00KH3Ool015VP000003KL67oo000OOol01WoiBKIoogooITeKW`Moo`05OXX00000000ZW`0FOol2
00000goo001oo`1?Ool20007G[T00`00G[UN^@06G[T20002G]T00`00H]URf@08H]T00`00H]T0000<
H]T00`00I_UVn@04I_T00`00I_UVn@03I_T00`00I_UVn@08I_T01000JaU[6@002Woo00<007ooOol0
1Goo00=o<SKLOol02goo00=I/VOoOol05Woo000OOol01WoiBKIoogooITeKW`Ioo`06Oo@X2U?oOomV
1BZO4goo0`00Dgoo00<005jiG[T025ji00<005jiG[T015ji00<005kIG]T00ekI00<006;IH]T01V;I
00@006;IH]T000]Rf@8000IVn@03001VnFKi009Vn@03001Vn@0000QVn@05001[6F/IJaT0000;Ool0
0`00Oomoo`04Ool00glb=]aoo`08Ool01Glb00000000Bcl05goo000POol01EV]FimonDPBIol01Woo
00Iom2P:Domood2ZDolAOol200000goo001oo`1BOol00`00G[UN^@09G[T00`00G[UN^@03G[T00`00
G]UNf@04G]T00`00H]URf@05H]T00`00H]URf@02H]T00`00H]URf@07H]T01000I_UVn@001FKi00D0
06KiI_UVn@00009Vn@03001VnFKi00EVn@03001[6F/I00=[6@03001oogoo00Uoo`03001oogoo00=o
o`03Oc8fg7oo00Moo`06OoU84VOoOombcD/o5goo000POol017nF=00004/o27oo00AnRP00000F6@mo
o`<005Eoo`800003F[T005ji00YN^@03001N^Eji008000QNf@03001RfF;I00=Rf@03001RfF;I00=R
f@03001RfF;I00IRf@05001VnFKiI_T00005I_T01000I_UVn@0016Ki00<006KiI_T00fKi00<006/I
JaT016/I00<007ooOol02Goo00<007ooOol00Woo00=I/VLb=]`027oo00IonDPBIomooeVbIolGOol0
03aoo`@005Eoo`8000=J^@03001N^Eji00UN^@03001N^@0000YNf@03001RfF;I009Rf@03001RfF;I
00ERf@03001RfF;I00=Rf@8000EVn@03001VnFKi009Vn@<000EVn@03001VnFKi009Vn@03001[6F/I
00I[6@03001oogoo00Moo`<000=oo`03Oc8003KL00Uoo`04Oc800000=]`HOol003Yoo`8005Moo`80
00IJ^@03001N^Eji00UN^@03001NfEkI00YNf@04001RfF;I0008H]T00`00H]URf@02H]T00`00I_UV
n@05I_T00`00I_UVn@02I_T00`00I_UVn@06I_T01000I_UVn@002F/I00<007ooOol02Woo00<007oo
Ool0:7oo000gOol3001GOol20008F[T00`00G[UN^@07G[T200000eji001Nf@0:G]T00`00H]T0000:
H]T01000H]URf@002FKi00<006KiI_T00P0026Ki00<006Ki00002f/I00<007ooOol02Goo00<007oo
Ool0:7oo000eOol20003Ool00`00Oomoo`1COol00`00F[UJ^@09F[T00`00G[UN^@05G[T01@00G[UN
^Eji000035kI00<006;IH]T02F;I00<006;I00002VKi0`000VKi00<006KiI_T01VKi00<006/IJaT0
2F/I00<006/I00002goo00<007ooOol09goo000cOol2001IOol3000;F[T00`00G[UN^@03G[T20005
G[T00`00G]UNf@08G]T2000<H]T00`00I_UVn@06I_T300000fKi001Vn@02I_T00`00I_UVn@05I_T0
0`00I_T00009JaT01000JaU[6@0037oo00<007ooOol09Woo000cOol2001HOol01@00F[UJ^EZi0000
2eZi00D005jiG[UN^@0000MN^@03001NfEkI00INf@80009Rf@03001RfF;I00QRf@03001Rf@0000AV
n@<000=Vn@03001Vn@0000=Vn@03001VnFKi00=Vn@04001VnFKi0008JaT00`00JaU[6@02JaT00`00
Oomoo`08Ool2000XOol003=oo`03001oo`0005Eoo`8000AJ^@03001J^EZi00UJ^@04001N^@000009
G[T00`00G]UNf@04G]T00`00H]URf@02H]T00`00H]URf@07H]T01@00H]URf@00I_T00`001FKi00@0
06KiI_T000AVn@05001VnFKiI_T00004I_T00`00JaU[6@04JaT00`00JaU[6@03JaT00`00Oomoo`0:
Ool00`00Oomoo`0UOol003=oo`04001oogoo001COol00`00F[UJ^@05F[T00`00F[UJ^@09F[T00`00
G[UN^@09G[T00`00G]UNf@03G]T00`00H]URf@04H]T00`00H]URf@05H]T01000H]URfF;I0P001fKi
00<006KiI_T00VKi00<006KiI_T00VKi00<006Ki00001FKi00<006/IJaT016/I00<006/IJaT016/I
00<007ooOol02Woo00<007ooOol097oo000bOol00`00Oomoo`02Ool00`00Oomoo`1>Ool20008F[T0
0`00F[UJ^@07F[T200000eji001N^@0:G[T00`00G]UNf@020007H]T00`00H]URf@03H]T200001V;I
00000000H]T000IVn@03001VnFKi00=Vn@03001VnFKi009Vn@03001Vn@0000IVn@03001[6F/I009[
6@03001[6F/I00E[6@03001oogoo00Yoo`03001oogoo02Aoo`00<Woo0`000goo00<007ooOol0Bgoo
0P002eZi00<005ZiF[T01EZi00D005jiG[UN^@0000]N^@03001Nf@0000YRf@04001RfF;IH]T40005
H]T00`00I_UVn@02I_T00`00I_UVn@05I_T00`00I_UVn@02I_T00`00I_UVn@06I_T01000JaU[6@00
2F/I00<007ooOol02Woo00<007ooOol08goo000bOol00`00Oomoo`04Ool00`00Oomoo`18Ool20002
EYX00`00F[UJ^@08F[T00`00F[UJ^@03F[T20005G[T00`00G[UN^@09G[T00`00H]URf@09H]T00`00
H]T000020009H]T01000I_UVn@002FKi00H006KiI_T006Ki0007I_T00`00JaT00009JaT00`00JaT0
000:Ool3000TOol000Moo`07OoU8000000eKWgooIT000P0000`fg7ooOomoog;=00003E^OOomonDP0
0KH3Ool017;=0000009I0Woo00IIX000000fg7ooOc8300001@0BIomoogoo00001goo0P00AWoo0P00
15JJ00<005ZiF[T02EZi00D005ZiF[UJ^@0000MN^@03001N^Eji00MN^@<000YRf@@000]Rf@03001V
n@0000YVn@03001Vn@0000=Vn@03001VnFKi00EVn@03001[6F/I00M[6@04001[6F/I000<Ool00`00
Oomoo`0ROol000Moo`07IT1;?gooOoUW?goiBUT00Woo00=JEWooOol00Woo00=o<SKLOol01Woo00Io
USFfOomonDP=Fil4Ool01UVbIomooeVP019Wo`Aoo`03001oogoo00Moo`03001oogoo045oo`8000MF
VP03001J^EZi00QJ^@04001J^@000009G[T00`00G[UN^@05G[T01@00G]UNfEkI00001V;I0`000V;I
00<006;IH]T02f;I00<006KiI_T02VKi00<006KiI_T00VKi00<006KiI_T016Ki00<006/I00001f/I
00<006/IJaT00V/I00<007ooOol02Woo00<007ooOol08Goo0006Ool03WoiB00fg7ooL/e;?gooFUIo
ogoiBUUoogoiB00200000`0=Fimoo`07Ool00fI0001;?`02Ool01Glb00000000Bcl00Woo00=o<P00
Bcl00goo0P002Goo00<007ooOol0?Woo0P002EJJ00<005ZiF[T02EZi00<005jiG[T02Eji00<005ji
G[T00eji0P0015kI00@006;IH]URf@<000=Rf@800003H]T006;I00YRf@8000]Vn@03001Vn@0000AV
n@03001VnFKi009Vn@04001[6F/I0006JaT00`00JaU[6@04JaT00`00Oomoo`0:Ool00`00Oomoo`0P
Ool000Moo`04FK8eX0000KH2Ool016I0000003KL0Woo00AV@4/oOc8fg0Yoo`09OoU9]WooOoU84VOo
OombcD/o00=oo`04OoUW?gooOol2000;Ool00`00Oomoo`0kOol3000;EYX00`00F[UJ^@06F[T20000
0eZj001N^@0:G[T01@00G[UN^Eji00001ekI0`001F;I00D006;IH]URf@0000YRf@04001RnF;i0009
I_T01000I_UVn@001FKi00@006KiI_T000A[6@03001[6F/I009[6@03001[6F/I00E[6@03001oogoo
00Yoo`03001oogoo021oo`001goo00=o<P6fOol00Woo00EonDVfOomonDVf009oo`04OoU83E[B=]`7
Ool057oiB0eKWgoiB19WogoiB19WogooFK9WognF=KIoogoiB19Wogoo000=Ool00`00Oomoo`0hOol2
0003EYX00`00EYYFVP08EYX00`00F[UJ^@04F[T20003F[X00`00G[UN^@09G[T01000G[T000001EkI
10001F;I0P001F;I00<006;IH]T01V;I00D006;iH_URn@0000QVn@03001VnFKi009Vn@03001VnFKi
00=Vn@8000I[6@04001[6F/I0009JaT00`00Oomoo`09Ool2000QOol000Qoo`06L/d00000Bcmoog;=
0P0000M;?gooOomoognF=00fg008Ool017nF=00004/o0Woo00Ao<P00000fg09oo`04L/d00000=]`2
Ool00`00Oomoo`0<Ool00`00Oomoo`0eOol20005EYX00`00EYYFVP09EYX01000F[UJ^EZi0P001UZj
00<005jiG[T02Eji00<005kIG]T00ekI0P0015kI00D006;IH]URf@0000MRf@03001RfF;I00ARf@80
00ERn@03001VnFKi00=Vn@8000EVn@03001VnFKi009Vn@8000M[6@03001[6@0000U[6@8000aoo`03
001oogoo01moo`00<Goo00<007ooOol03Goo00<007ooOol0<Goo0`0025JJ00<005JJEYX025JJ00@0
05Zi000000QJ^P03001N^Eji00MN^@<0009Nf@<000INf@04001Rf@000009H]T00`00H]URf@02H]T0
0`00H_URn@05H_T00`00I_UVn@02I_T00`00I_UVn@06I_T01000I_UVn@000V/I00<006/IJaT01F/I
00<006/IJaT01f/I00@006/iJcT000aoo`03001oogoo01ioo`00<Goo0P003goo00<007ooOol0;Goo
0`000U:J00<005JJEYX01UJJ00<005JJEYX02EJJ00<005ZjF[X02EZj00<005jiG[T01Eji00<005kJ
G]X00`002UkI00<006;IH]T02V;I00@006;IH]T000URn@04001VnFKi0009I_T00`00I_T00004JaT0
0`00JaU[6@03JaT20008JaT01@00JcU[>F/i00003Goo00<007ooOol07Goo000aOol00`00Oomoo`0?
Ool00`00Oomoo`0YOol30005DYX00`00EYYFVP07EYX00`00EYYFVP06EYX200000eJj001J^P09F[X0
0`00G[UN^@03G[T500000ekJ001Nf@09G]T00`00G]X0000;H]T00`00H]T0000:H_T00`00I_T0000;
I_T00`00JaU[6@03JaT00`00JaU[6@02JaT01000JaY[6P001V/I00<006/iJcT00f/i00<007ooOol0
2Woo0P001Goo00YonDP00000000=FimoogoiB001]P=oo`04FJ000000=]`2Ool017;=000003KL0Woo
000`Ool00`00Oomoo`0AOol00`00Oomoo`0UOol30009DYX00`00EYYFVP06EYX00`00EYYFVP04EYX2
0003E[X00`00F[YJ^P09F[X01000G[UN^Eji0`001EkJ00<005kIG]T01EkI0P000UkJ00<006;IH]T0
2V;I00<006;iH_T02V;i00<006KiI_T02FKi00<006LJ00001F/I00@006/IJaT000=[6P03001[6F/I
00=[6@03001[>F/i00A[>@03001oogoo00Yoo`8000Moo`03Oc8fg7oo00]oo`04FK9WognF=KH2Ool1
FJd1Fil1Ool0031oo`<0019oo`03001oogoo029oo`80009>VP03001BVU:J00MBVP03001FVUJJ00MF
VP04001FVUJJEYX20006E[X00`00F[YJ^P08F[X40008G]X00`00G]UNf@04G]T00`00G]YNfP03G]X0
0`00H]URf@07H]T200000f;j001Rn@09H_T00`00I_X00009I_T01000IaYW6P001V/I0P001F/J00D0
06/IJaU[6@0000Q[>@03001oogoo00]oo`03001oogoo00Aoo`03Oc8fg7oo00Qoo`05Oc800000001;
?`04Ool1ITd1Fil1Ool0031oo`03001oo`0000<0011oo`03001oogoo01ioo`<000A>VP03001BVU:J
00QBVP03001FVUJJ00IFVP04001FVP000008E[X00`00F[YJ^P06F[X4000;G]X00`00G]UNf@02G]T0
0`00G]YNfP04G]X00`00H]URf@06H]T01@00H_YRnV;j000026;i0P000VKj00<006KiI_T01VKi00<0
06LJIaX00VLJ00<006/IJaT00f/I0P001F/J00@006/IJaT000Q[>@03001[>P0000aoo`03001oogoo
00Aoo`03Oc8fg7oo00Moo`08OoU84VOoOombcD/oOomV@0800042F@5oo`5oo`00<7oo0`000bGk0`00
3Woo00<007ooOol067oo1@0024jJ00<005:JDYX01e:J00<005JJEYX01UJJ0P002eJj00<005ZjF[X0
0UZj0`0000EJ^P00001J^P0000YNfP03001NfEkI008000QNfP03001RfF;I00=Rf@8000ERnP03001R
nF;i00ARn@03001VnVKj00=VnP03001VnFKi00=Vn@8000EW6P03001[6F/I009[6@03001[6P0000I[
6P8000Q[>@05001[>V/jJcX0000<Ool00`00Oomoo`02Ool00eVbIc8fg008Ool02GoiB19WogooFK9W
ogooITeKW`04Ool0031oo`04001oogoo00049O/5000;Ool00`00Oomoo`0AOol60004BW/00`00CYY>
VP06CYX00`00DYYBVP08DYX00`00EYYFVP03EYX20002E[X00`00E[YF^P08E[X00`00F[X000020002
F[X20003F[X00`00G]YNfP09G]X2000;G]X01@00H]URfF;I00001f;j00<006;iH_T00f;i00<006Kj
I_X016Kj00<006KiI_T00VKi00<006LJIaX01VLJ00@006/IJaT000=[6P03001[6V/J00=[6P03001[
>F/i00I[>@03001[>V/j009[>P03001oogoo00Uoo`<000=oo`03Oc8003KL00Uoo`04Oc800000=]`2
Ool016I00000009I0Woo000`Ool01000Oomoo`0012Gk00<002hK;Q/00RhK1@001goo0P003Goo1000
0TIk00<004YkBW/01DYk00<004jJCYX01djJ00<005:JDYX01e:J00<005JJEYX00`0015Jj00<005Jj
E[X01eJj0`000eZj0P001UZj00<005kJG]X025kJ00<005kJG]X02UkJ00@006;I000000URnP03001R
nF;i008000QVnP04001VnFKi0009IaX00`00JaT00005JaX01`00JaY[6V/J001[>P0000I[>@03001[
>V/j00A[>P03001oogoo00Yoo`03001oogoo01Uoo`00;goo00<007ooOol00Woo00<002Gk9O/00RGk
00<002hK;Q/00bhK00<003Hk=S/05P001TIk00<004YkBW/01TYk00<004jJCYX01TjJ00<005:JDYX0
1e:J0`0025Jj00<005JjE[X015Jj0P000UJj00@005Zj000000QJ^P03001NfUkJ00INfP800003G]X0
05kJ00]NfP03001RnV;j00URnP03001Rn@0000YVnP03001Vn@0000]W6P03001[6V/J00E[6P03001[
6P0000=[>P03001[>F/i009[>@03001[>V/j00I[>P03001oogoo00Yoo`03001oogoo01Qoo`00;goo
00<007oo00000goo00<002Gk9O/00RGk00<002hK;Q/00RhK00<003Hk=S/013Hk00<003iK?U/01CiK
00<0049K@U/01D9K00<004IkAW/01TIk00<004YkBW/01DYk00<004jJCYX01djJ00<005:JDYX00e:J
0`000U:K00<005JjE[X01UJj00@005JjE[YF^P<000AF^P8000]J^P03001NfUkJ00ANfP05001NfUkJ
G]X0000:G]X200000ekj001RnP0:H_X00`00I_YVnP0:I_X00`00IaYW6P09IaX00`00IaX00006JaX2
0004JcX01@00JcU[>F/i000026/j00<006mJ000037oo00<007ooOol05goo000_Ool20004Ool00`00
9O/Un`039O/00`00;Q/^6`02;Q/00`00=S/f>`03=S/00`00?U/nF`05?U/00`00@U]2F`05@U/00`00
AW]6N`06AW/00`00BW]:N`06BW/00`00CYY>VP06CYX00`00DYYBVP030005DY/00`00E[YF^P07E[X3
0005E[X20002F[X00`00F[YJ^P09F[X01000G]YNfUkJ0P001EkJ00<005kJG]X01UkJ00D005kjG_YN
nP0000YRnP03001RnP0000YVnP03001W6P0000UW6P04001W6VLJ0006JaX20005JcX00`00JcT00008
JcX01000KeY_FP0037oo00<007ooOol05goo0004Ool01goiB000000=FimoofI00080000<=]aoogoo
Oombc@0000eKWgooOoU8006f0goo00Abc@000002F@9oo`04FJ000000=]`3Ool017;=00003E^O0Woo
00<007ooOol017oo0P000bGk00<002hK;Q/00bhK00<003Hk=S/00cHk00<003iK?U/01CiK00<0049K
@U/01D9K00<004IkAW/01TIk00<004YkBW/01DYk00<004jJCYX01TjJ0`002E:K00<005JjE[X00eJj
0`0000=F^P00E[X00eJj0P0015Zj00<005ZjF[X02EZj00@005kJ000000QNfP03001NfUkJ00=NfP80
00ENnP03001RnV;j00IRnP04001RnV;j0009I_X01@00IaYW6VLJ00001fLJ00<006LJIaX00VLJ00<0
06/JJaX00V/J00@006/jJcX000E[>P03001[>V/j00I[>P03001_FVmJ009_FP03001oogoo00Uoo`80
01Qoo`0017oo00MV@4/oOomonFLoOoU:F@02Ool00eYFOomoo`02Ool00glb=]aoo`06Ool01WnF=KIo
ogoiB0eKW`Aoo`03FK9Wogoo009oo`03Oc8fg7oo009oo`03001oogoo00Eoo`H000D^6`03000f>cHk
00<f>`03000nFciK00@nF`030012Fd9K00E2F`030016NdIk00I6N`03001:NdYk00I:N`03001>VTjJ
00=>VP80009>V`03001BVe:K00MBV`03001F^UJj00<000AF^P03001F^UJj008000MJ^P03001J^UZj
00UJ^P03001NfUkJ00UNfP05001NfUkJG]X00007G_X00`00H_YRnP05H_X00`00H_YRnP02H_X00`00
I_YVnP05I_X00`00IaYW6P02IaX00`00IaYW6P03IaX20006IaX01000JaY[6P000f/j00<006/jJcX0
0V/j00<006/j00001V/j00<006mJKeX016mJ00<007ooOol02Woo00<007ooOol05Goo0003Ool03Woi
B00fg7ooL/e;?gooFUIoogoiBUUoogoiB00200000`0=Fimoo`07Ool00fI0001;?`02Ool01glb0000
0000BcmonDP00080000500eKWgooOol00007Ool00`008O`Qo0028O`30003;Q/00`00=S/f>`04=S/0
0`00?U/nF`04?U/00`00@U]2F`05@U/00`00AW]6N`06AW/00`00BW]:N`05BW/00`00CYY>VP030004
CY/00`00DY]BV`07DY/30008E[X20009F[X00`00F[YJ^P07F[X3000;G]X01000G]X000002Ekj00<0
06;jH_X00V;j0P001V;j00<006KjI_X00VKj0P001VLJ00D006LJIaYW6P0000QW6P03001[6P0000E[
>P04001[>V/j0003JcX00`00JcY[>P02JcX00`00KeY_FP04KeX00`00KgX0000;Ool00`00Oomoo`0E
Ool000Aoo`04FK8eX0000KH2Ool016I0000003KL0Woo00AV@4/oOc8fg0Yoo`0>OoU9]WooOoU84VOo
OombcD/oOomV@4/oOc8fg09oo`03001oo`0000Moo`03000Qo27l00<Qo0H000Df>`03000nFciK00Dn
F`030012Fd9K00E2F`030016NdIk00E6N`03001:NdYk00=:N`D000Q>V`03001BVe:K00=BV`<00003
DY/005Jj00IF^P800003E[/005Zj00UJ^P03001J^UZj00AJ^P8000=JfP03001NfUkJ00UNfP03001N
nUkj00YNnP04001RnV;j0009H_X01000I_YVnP002FLJ00<006LJ00002VLJ00<006/jJcX01F/j0P00
16/j00D006/jJcY[>P0000I_FP05001_NVmjKgX0000;Ool00`00Oomoo`0DOol000Aoo`03Oc81]Woo
009oo`05OoU9]WooOoU9]P02Ool017oiB0eJdSKL1goo015onDP=FimonDPBIomonDPBIomooeVbIomo
ogoiB0eJdSKL009oo`8000Uoo`03000Qo27l008Qo003000Z72XL008Z70D0008f>`03000nFciK00@n
F`030012Fd9K00E2F`030016NdIk00=6N`P000A:V`03001>VdjK00I>V`03001BVe:K00<000EBV`03
001F^UJj009F^P8000=F^`03001J^UZj00UJ^P04001J^UZjF[X20005F]X00`00G]YNfP07G]X20000
0ekj001NnP0:G_X00`00H_X0000:H_X00`00I_X0000;IaX00`00IaYW6P08IaX00`00JcX00006JcX2
0005JcX00`00JcX00006KeX00`00KgY_NP02KgX00`00Oomoo`08Ool3000EOol000Eoo`06L/d00000
Bcmoog;=0P0000M;?gooOomoognF=00fg008Ool017nF=00004/o0Woo00Ao<P00000fg0=oo`03OiHd
03KL009oo`03001oogoo00Uoo`03000Qo27l008Qo003000Z72XL00<Z7003000b?38l01L000A6N`03
001:VdZK00E:V`03001>VdjK00I>V`<000QBV`03001F^UJj008000IF^`03001J^UZj00QJ^P04001J
^P000008F]X00`00G]YNfP05G]X01@00G_YNnUkj000035kj00<006;jH_X02V;j00<006LJIaX02FLJ
00<006LJ000026LJ00D006/jJcY[>P0000A[>P03001[>P0000I[>P03001_FVmJ00A_FP03001_NVmj
00A_NP03001oogoo00Uoo`03001oogoo01=oo`00;Woo00<007ooOol02Goo00<0027l8O`00R7l00<0
02XL:Q`00bXL00<0038l<S`0138l00<003YL>U`013YL00<0049l@W`01D9l00<004IkAW/01DIk00<0
04ZKBY/01TZK00<004jKCY/00TjK0`0000=>V`00DY/025:K0`0025Jk00<005ZjF[X025Zj0P002U[J
00<005kJG]X00ekJ0P001Ekj00<005kjG_X01ekj0P0000=RnP00H_X02F;j00<006<J000026LJ0P00
0VLJ00<006LJIaX01FLJ00<006/jJcX00V/j00D006/jJcY[>P0000=[>P03001[>V/j009[>P03001[
FP0000E_FP03001_NVmj00E_NP03001oogoo00Uoo`03001oogoo019oo`00;Woo00<007ooOol02Woo
0P000b7l00<002XL:Q`00bXL00<0038l<S`00c8l00<003YL>U`013YL00<0049l@W`01D9l00<004Ik
AW/01TIk00<004ZKBY/01DZK00<004jKCY/00P001DjK00<005:KDY/00e:K0`000U:k00<005JkE[/0
1eJk00<005ZjF[X01EZj0P000U[K00<005[JF]X025[J00D005kJG]YNfP0000MNnP03001NnUkj00IN
nP05001RnV;jH_X00008H_X20002HaX00`00IaYW6P05IaX00`00IaYW6P03IaX00`00IaYW6P02IaX2
0006JcX00`00JcX00005JcX01000JcY[>P000V]J00<006mJKeX00VmJ00<006mjKgX01Fmj00<006mj
00002Woo00<007ooOol04Woo000^Ool2000<Ool300028O`00`00:Q`Z7003:Q`00`00<S`b?003<S`0
0`00>U`jG004>U`00`00@Wa2O005@W`00`00AW]6N`05AW/00`00BY]:V`05BY/30007CY/00`00DY]B
V`030005D[/00`00E[]F^`08E[/00`00F[YJ^P02F[X20004F]/00`00F]YJfP08F]X01000G]X00000
2Ekj00<005kjG_X00ekj0P001F;j00<006;jH_X016;j00<006<JHaX00f<J00<006LJIaX00fLJ00<0
06LJIaX01FLJ00@006LJIaX000U[>P03001[>V/j00E[>P8000A[FP04001_FVmJ0007KgX01@00KgY_
NVmj00002Goo0P004goo000^Ool00`00Oomoo`0;Ool00`007O`Mo0030006:Q`00`00<S`b?002<S`0
0`00>U`jG004>U`00`00@Wa2O005@W`00`00AW]6N`06AW/01000BY]:VdZK0`000TZK00<004jKCY/0
1DjK0`002E:k00<005JkE[/01eJk00<005ZjF[X00P001e[K00<005[JF]X025[J00<005kjG_X02Ukj
00D005kjG_YNnP0000MRnP03001RnV;j00=RnP03001S6V<J00ES6P03001W6VLJ008000QW6P03001W
6P0000U[>P03001[>P0000I[>P03001[FV]J00=[FP03001_FP0000M_NP03001_NVmj00=_NP03001o
ogoo00Qoo`03001oogoo011oo`00;Goo00<007ooOol03Goo00@001gl7O`Mo0D0008Z7003000b?38l
00<b?003000jG3YL00@jG0030012O49l00E2O0030016NdIk00I6N`<000E:V`04001>VdjKCY/40002
CY/00`00D[]B^`07D[/00`00E[]F^`08E[/20009F]/00`00F]YJfP06F]X200000e[K001NnP0:G_X0
1000G_X000002F;j00<006;jH_X00P0026<J00<006LJ00002fLJ00<006/jJcX01f/j00D006/jJcY[
>P0000A[>P03001[FP0000E[FP03001_NVmj00E_NP03001_NVmj00=_NP03001_V`0000Uoo`03001o
ogoo011oo`00;Goo00<007ooOol03Woo00<001gl7O`00Qgl00<002HL9Q`01@00138l00<003YL>U`0
13YL00<0049l@W`01D9l00<004IkAW/00TIk10001DZK1P001TjK00<005:kD[/025:k00<005JkE[/0
1EJk0P0000=Ff`00F]/02E[K00<005[JF]X015[J00D005[KF]]Jf`0000aNnP03001RnV;j00URnP03
001RnP0000]S6P03001W6VLJ00UW6P03001W>`0000M[>P03001[>V/j009[>P05001[>V/jJcX00003
JeX01`00JeY[FV]J001[N`0000E_NP03001_NVmj00=_NP04001_VfnK000:Ool00`00Oomoo`0?Ool0
02eoo`03001oogoo00moo`03000Mo1gl008Mo003000V72HL00<V70H000HjG0030012O49l00E2O003
0016N`0000800003AW/0000000H000A:W003001>VdjK00I>V`03001B^e:k00QB^`03001F^eJk009F
^`8000=Ff`03001Jfe[K00UJf`04001JfU[JF]X20005F]/00`00G_YNnP07G_X200000ekk001RnP0:
H_X00`00HaYS6P09HaX00`00Ha/00008IaX20002Ic/00`00JcY[>P04JcX00`00JcY[>P04JcX00`00
JcX00005JeX00`00JeX00003Jg/01@00KgY_NVmj00001Fmj00<006nKKi/00VnK00<007ooOol027oo
00<007ooOol00goo00Io<P000000000BIol5Ool002eoo`80011oo`03000Mo1gl008Mo003000V72HL
00<V7003000b?38l008b?1D000A6W003001:W4ZL00E:W003001>VdjK00M>V`03001B^e:k00MB^`03
001F^eJk008000IFf`03001Jfe[K00QJf`04001JfP000008F]/00`00G_YNnP04G_X20003G_/00`00
H_YRnP07H_X200000f<K001S6P07HaX20002Ha/00`00IaYW6P05IaX00`00Ic]W>`03Ic/00`00JcY[
>P02JcX00`00JcY[>P06JcX00`00JeY[FP04JeX20005Jg/00`00KgX00005KgX00`00Ki]_V`04Ki/0
0`00Oomoo`06Ool20006Ool00eVP019Wo`07Ool002eoo`03001oogoo011oo`8000<Mo003000V72HL
00<V7003000b?38l00<b?003000jG3YL00@jG003000nO000008000<nO0030016W4JL00E6W003001:
W4ZL00I:W003001>VdjK00M>V`03001B^e:k00EB^`@000QFf`03001Jfe[K00QJf`8000]Jf`04001N
nUkjG_X20006G_/00`00H_YRnP04H_X20003Ha/00`00HaYS6P05HaX00`00Ha]S6`03Ha/00`00IaYW
6P03IaX00`00Ic]W>`05Ic/01000JcY[>P0026/j00<006]K000016]J0`001V]k00<006mjKgX00fmj
00<006nKKi/016nK00@006nK000000Qoo`03001oogoo00Aoo`03Oc8004/o00Ioo`00;Goo00<007oo
Ool04Goo1P001BHL00<0038l<S`00S8l00<003YL>U`00cYL0`001Sil00<004JLAY`01TJL00<004ZL
BY`01TZL00<004jKCY/01TjK00@005:kD[]B^`@000=B^`03001FfeKK00MFf`03001Jfe[K00EJf`80
009Jf`03001Jfe[K00QJf`04001NnP000009G_/01000H_YRnV;j0P001V<K00<006<JHaX00f<J00<0
06<KHa/01F<K00<006LJIaX00P0026Lk00<006/j00001f/j0P000V]K00D006]JJeY[FP0000=[N`03
001[Nf]k009[N`03001_N`0000=_NP03001_VfnK00A_V`03001_VfnK009_V`03001oogoo00Ioo`03
001oogoo00Aoo`03OoUW?goo00Eoo`00;7oo00<007ooOol04goo00@001Wl6O`Io0<000@V7003000b
?38l008b?003000jG3YL008000<jG003000nO3il00@nO0030016W4JL00E6W003001:W4ZL00M:W003
001>VdjK00E>V`@000MB^`03001FfeKK00QFf`03001Jfe[K009Jf`8000AJf`03001Jfe[K00UJf`03
001Nnekk00UNn`04001RnP000009Ha/00`00HaYS6P020008Ha/00`00IaX0000;Ic/00`00JcY[>P05
JcX00`00Je][F`03Je/00`00JeX00004Jg/01@00Jg][Nf]k00000fmk00<006mj00001VnK00<006nK
Ki/00VnK00<006nk00001goo00X007ooOomoognF=KIoogoiB19Wo`Eoo`00;7oo00<007ooOol057oo
00<001Wl6O`00QWl1P00138l0`001CYL00<003il?W`01Cil00<004JLAY`01DJL00<004ZLBY`01TZL
00@004jKCY]>V`@0009>_003001B^e:k00MB^`03001FfeKK00MFf`03001Jfe[K008000MJf`03001J
fe[K00IJf`800003F_/005kk00YNn`03001S6f<K00US6`03001S6P0000]S6`03001W>fLk00QW>`80
0003Ic/006/j00A[>P03001[Ff]K00E[F`03001[Nf]k00A[N`03001[N`0000E_N`03001_VfnK00=_
V`8000A_V`05001_^fnkKk/00005Ool30003Ool017;=000003KL1Woo000/Ool3000EOol01@006O`I
o1Wl000012HL1@000S8l00<003YL>U`013YL00<003il?W`01Cil00<004JLAY`01DJL00<004ZLBY`0
1DZL10001Tjl00<005:kD[/025:k00<005KKE]/01UKK0`002U[K00<005[KF]/015[K00D005[kF_]J
n`0000YNn`03001O6`0000]S6`03001S6f<K00US6`03001W>`0000QW>`05001W>fLkIc/00003JcX2
0007Je/00`00Jg/00005Jg/20005Kg/00`00Ki/00003Ki/00`00Ki]_V`03Ki/00`00Kk]_^`03Kk/0
0`00Ool0000300000goo001oo`0<Ool00008OomonDP000003E^OOomV@080000<=]aoogooOombc@00
00eKWgooOoU8006f0goo00Abc@000002F@9oo`04FJ000000=]`2Ool01GoiB000000=Fil00Woo00<0
07ooOol05Woo00D001Wl6O`Io000008V70T000LjG003000nO3il00@nO0030016W4JL00E6W004001:
W4ZLBY`40002BY`00`00C[a>_006C[`00`00D[]B^`08D[/00`00E]]Ff`03E]/20002E]/00`00F]]J
f`09F]/01000F]]Jfe[K0P001E[k00<005kkG_/01Ekk0P000elK00<006<KHa/01V<K0P0000=S6`00
Ha/01f<K0P000fLk00<006LkIc/00fLk0P001FLk00<006/j000026]K00D006]kJg][N`0000=[N`04
001_Nfmk0003Kg/01`00Ki]_VfnK001_V`0000E_V`03001_^fnk00=_^`03001_f`0000Eoo`03001o
ogoo00]oo`0000QoofI0BcmoogoiIcmonDYI0Woo00=JEWooOol00Woo00=o<SKLOol01Woo00IoUSFf
OomonDP=Fil4Ool025VbIomoofI0BcmoogoiIcl2Ool00`00Oomoo`0GOol00`006O`Io00300039Q`0
0`00;Sd^?@02;SdK0006BY`00`00C[a>_006C[`00`00D[]B^`08D[/00`00E]]Ff`030004E]/00`00
F]]Jf`09F]/01000F]/0000025[k00<005kkG_/00ekk00<005lKGa/00elK00<006<KHa/01F<K00<0
06<KHa/00V<K00<006<KHa/016<K00<006LkIc/00fLk00<006LkIc/00VLk00<006LkIc/01VLk00<0
06]KJe/01V]K00<006]kJg/00f]k00<006]k00000fmk00@006mkKg/000E_V`03001_VfnK00=_V`03
001_^fnk00=_^`04001_ffoKKm/20003Ool00`00Oomoo`0;Ool0000>OoU803KLOombcD/oOomJEWoo
OoU:FGooOoU80080000300eKWgoo00Moo`03IT0004/o009oo`0;Oc800000001;?goiB00fg7ooL/e;
?`02Ool00`00Oomoo`0GOol300026O`00`009Q`V70029Q`00`00;Sd^?@03;Sd00`00=WdfO@05=Wd0
0`00?WdnO@04?Wd00`00AYa6W005AY`00`00BYa:W006BY`00`00C[a>_006C[`00`00D[]B^`07D[/3
0008E]/00`00F]]Jf`08F]/2000;F_/01@00G_]Nnekk00001elK00<006<KHa/00V<K0P001V<K00<0
06<KHa/00V<K00<006LkIc/01FLk00@006Lk000000QW>`03001WF`0000I[F`03001[Nf]k00E[N`03
001_Nfmk00=_N`8000E_V`03001_V`0000=_V`03001_^fnk00=_^`05001_ffoKKm/00002Km/30000
0goo001oo`0;Ool00005OomI/SFP0001]P02Ool016I0000003KL0Woo00AV@4/oOc8fg0Yoo`0>OoU9
]WooOoU84VOoOombcD/oOomI/SFP0001]P9oo`03001oogoo01Eoo`<0009oo`@000DV7003000^?Bhm
00<^?@03000fOCIm00@fO@03000nOCim00@nO@030016W4JL00E6W003001:W4ZL00I:W003001>_4jl
00M>_003001B^e:k00=B^`<0009Bg003001FfeKK00MFf`03001Jfe[K00EJf`80009Jn`03001Jne[k
00QJn`04001Nn`000009Ga/01000Ha/000002F<K00@006<K000000UW>`03001W>fLk00MW>`05001W
FfMKIe/00004Je/00`00Jg][N`05Jg/00`00Jg/00004Kg/20004Ki/01`00Ki]_VfnK001_V`0000A_
^`8000=_f`05001_ffoKKm/00002Ko/2000<Ool00003Oomo<P6f00=oo`05OoU9]WooOoU9]P02Ool0
17oiB0eJdSKL1goo00monDP=FimonDPBIomonDPBIomooeVbIomooglb0KH017oo0`004Woo0`001Goo
00<0017L4M`00`0012HL00<002hm;Sd00Rhm00<003Im=Wd01CIm00<003im?Wd013im00<004JLAY`0
1DJL00<004ZLBY`01TZL00<004jlC[`01Tjl00<005:kD[/00`001E;L00<005KKE]/025KK00<005[K
F]/00U[K0P0015[k00<005[kF_/025[k0P0035lK00<006<KHa/02V<K00<006LkIc/026Lk00<006Lk
00001fLk00<006MKIe/00VMK00D006]KJe][F`0000M[N`04001[Nf]k0003Kg/01000Ki]_V`000VnK
00<006nKKi/00fnK00<006nkKk/00Vnk00<006oKKm/00VoK00D006oKKm]_f`0000=_n`8000aoo`00
0Woo00Ibc@00001;?gooL/d200001d/oOomoogooOiHd03KL00Qoo`04OiHd0000Bcl2Ool017lb0000
03KL0goo00Ibc@00001;?goo000AOol30009Ool010004M`Ag17L1P001Bhm00<003Im=Wd01CIm00<0
03im?Wd013im00<004JLAY`01DJL00<004ZLBY`01TZL00<004jlC[`01Djl0`002E;L00<005KKE]/0
1eKK00<005[KF]/00P001e[k00<005[kF_/01E[k0P000Ukk00<005lKGa/01elK0P0000=O6`00Ha/0
26<K0P0000=S>`00Ic/01VLk0P000fLk00<006LkIc/00VLk0P001VMK00<006]K00001f]k00<006]k
Jg/00V]k00<006mk00000fnK00<006nK00001FnK00H006nk000006nk0004Km/01@00Km]_ffoK0000
0fok00<007oo000037oo000[Ool00`00Oomoo`0<Ool3000=Ool01@004M`Ag17L00000ahM1@000Rhm
00<003Im=Wd01CIm00<003im?Wd013im00<004JLAY`01DJL00<004ZLBY`01DZL00@004jlC[a>_0@0
009>_003001Bg5;L00QBg003001FfeKK00IFf`<000YJn`03001Jne[k009Jn`8000ENn`03001O6elK
00AO6`8000=O6`03001S6f<K00IS6`03001S>f<k009S>`03001W>fLk00=W>`03001W>fLk00=W>`05
001W>fLkIc/00009Ie/00`00Jg][N`04Jg/20006Jg/00`00Ki]_V`03Ki/00`00Ki]_V`03Ki/00`00
Kk]_^`02Kk/00`00Km]_f`02Km/01@00Km]_ffoK00000fok00@007ooOol000aoo`00:goo00<007oo
Ool02Woo0P004Goo00@0017L4M`000DN7@03000ZGBYM00L000<fO@03000nOCim00@nO@030016W4JL
00E6W003001:W4ZL00=:W0H000M>_003001Bg5;L00QBg003001FfeKK00=Ff`80009Fo003001Jne[k
00QJn`03001Jne[k008000MNn`03001O6elK009O6`8000IO6`03001S6f<K00=S6`8000ES>`03001W
>fLk009W>`03001W>fLk00EW>`03001W>`0000UWF`03001[O00000A[N`03001[Nf]k00E[N`03001[
W00000=_V`03001_V`0000=_V`03001_^fnk009_^`06001_g000001_f`0016oK00@006okKo/000=o
o`03001oogoo00Yoo`00:goo00<007ooOol01goo0`0057oo0P0000<Ag0007Qd011hM00<002YM:Ud0
0bYM00<003Im=Wd0600014Zl00<004jlC[`01Tjl00<005;LD]`025;L00<005KKE]/00`001EKl00<0
05[kF_/025[k0P002Ukk00@005lK000000UO6`05001S6f<KHa/00008Hc/01000Ic/000002FLk00<0
06MKIe/01VMK0P000f]l0P0000=[N`00Jg/01V]k00L006^LJia[W000Ki/00003Ki/00`00Ki/00004
Kk/00`00Kma_g002Km`00`00Km]_f`02Km/01000Ko]_n`0017oo00<007ooOol02Woo000ZOol30005
Ool3000HOol400047Qd00`00:UdZG@04:Ud00`00=WdfO@04=Wd00`00?YdnW@04?Yd00`00@Ye2W@05
@Yd00`00B[a:_006B[`00`00C[a>_006C[`00`00D]aBg006D]`40008E_`00`00F_]Jn`06F_/20000
0e[l001Nn`0:G_/00`00Ga]O6`09Ga/01000Ha/000002V<k00<006LkIc/026Lk00<006ML00001VMK
00<006]lJg`01F]l00<006]kJg/01F]k00<006^LJi`00f^L00<006nKKi/00VnK0P0016nk00<006oL
Km`00VoL00H006oL000006oK0002Ko/00`00Oomoo`03Ool00`00Oomoo`0:Ool002Yoo`03001oogoo
009oo`<001aoo`03000=g000008000<N7@03000ZGBYM00@ZG@03000fOCIm00@fO@03000nWCjM00@n
W@030012WD:M00E2W@03001:_4Zl00E:_003001>_4jl00M>_004001Bg5;LD]`40003D]`00`00E_aF
o007E_`00`00F_]Jn`03F_/20004F_`00`00G_]Nn`06G_/200000elL001O6`0:Ga/00`00Hc]S>`08
Hc/200000f<l001W>`06Ic/20003Ie`00`00Ie]WF`02Ie/00`00Jga[O005Jg`00`00Jg`00004Jg/2
0005Ji`01000Jk`000000VnK0P000fnk00<006oLKm`00VoL00<006oLKm`00VoL00@006okKo/000Mo
o`03001oogoo00Uoo`00:Woo00<007oo00000P0087oo00<000gL3M`01P001RYM00<003Im=Wd00cIm
00<003jM?Yd01CjM00<004:M@Yd014:M00<004ZlB[`01TZl00<004jlC[`01Tjl100025;L00<005Kl
E_`01eKl00<005[kF_/00P001U[l00<005kkG_/01Ekk00<005lLGa`00UlL00<005lKGa/01UlK0P00
00=O?000Hc/01f<k00<006<lHc`00V<l00<006LkIc/00fLk00<006MLIe`016ML00@006MK000000M[
O004001[O6]l0003Jg/00`00Jia[W004Ji`00`00Jka[_002Jk`20002Kk/00`00Kk/00004Km`00`00
Kma_g002Km`01000Jo/0000027oo00<007ooOol02Goo000ZOol2000TOol200000`gL000J7@026Qd5
0003:Ud00`00=WdfO@03=Wd00`00?YdnW@04?Yd00`00@Ye2W@05@Yd00`00B[a:_006B[`01000C[a>
_4jl10000TkM00<005;LD]`01e;L00<005KlE_`01eKl0`002E[l00<005kkG_/00Ukk0P001ElL00<0
05lKGa/01ElK00<005llGc`00Ull00<006<kHc/00f<k0P001F<l00<006LkIc/00VLk00<006MLIe`0
1VML00<006]lJg`01V]l00<006]lJg`00V]l00<006]k00001F^L0P001F^l00<006^l00000`0016oL
00@006oLKma_g080009[n`03001oogoo00Moo`03001oogoo00Uoo`00:goo00<007ooOol08goo1@00
0aXM00<002IM9Ud020000SIm00<003jM?Yd013jM00<004:M@Yd01D:M00<004ZlB[`00dZl1P001dkM
00<005;LD]`01e;L00<005KlE_`015Kl0P000UKl00<005[lF_`025[l00@005kk000000QO7003001O
6elK009O6`8000EO?003001S>f<k009S>`03001S?6<l00IS?004001W>`000008Ie`00`00Ig`00005
Jg`20006Jg`00`00Jia[W003Ji`00`00Jka[_004Jk`00`00Jka[_002Jk`20003Km`01@00Kma_g6oL
00000f_k00<007ooOol027oo00<007ooOol02Goo000/Ool2000TOol00`001M/0000200036Qd00`00
9UdVG@049Ud00`00<WhbOP070003?Yd00`00@Ye2W@02@Yd80004B[d00`00C]e>g@06C]d00`00D]aB
g008D]`00`00E_aFo0030005E_`00`00F_aJo008F_`00`00GaaO7009Ga`01000Ga/0000025ll00@0
06<k000000YS?003001WG6ML00IWG08000=WO005001[O6]lJg`00007Jg`01000Ji`000000V^L00<0
06^lJk`016^l00<006^lJk`00V^l00H006_L000006oL0003Km`00`00Jo][n`02000;Ool00`00Oomo
o`09Ool002ioo`03001oogoo029oo`030005f`GK00<0008J7@03000VGBIM00@VG@03000bOS9n00<b
OP03000jWCZM00P000A2_@03001:_DZm00I:_@03001>gDkM00I>g@03001Bg5;L00IBg0@000QFo003
001Jo5[l00IJo0800003Fa`005lL00UO708000]O?003001S?6<l00QS?0800003He`006ML00EWG003
001WO6Ml00AWO003001[O00000I[O08000A[W08000E[_08000A[_003001[g6_L009[g003001_g6oL
0080009[n`03001oogoo00]oo`03001oogoo00Uoo`00;goo00<007ooOol08Woo00@000GK1M/5f`D0
00DVG@03000bOS9n00@bOP03000jWCZM00@jW@030012_D:m00E2_@03001:_DZm00E:_@03001>gDkM
00M>g@04001Bg5;LD]`40003D_d00`00E_aFo007E_`00`00F_aJo003F_`20004Fa`00`00GaaO7005
Ga`20002Gc`00`00GcaO?006Gc`200000ell001S?007Hc`00`00HeaSG002He`00`00IeaWG002Ie`0
0`00IgaWO006Ig`00`00Jga[O004Jg`00`00Jia[W004Ji`00`00Jk`00003Jk`00`00Jka[_003Jk`0
0`00Jma[g002Jm`50002Jo/00`00Oomoo`0<Ool00`00Oomoo`09Ool0031oo`03001oogoo029oo`80
0085f`03000F7AHM00<000@VG@03000bOS9n00<bOP03000jWCZM00DjW@030012_D:m00A2_@03001:
_DZm00I:_@03001>gDkM00I>g@@000QBo@03001Fo5Kl00MFo003001Jo5[l008000IK7003001O75lL
00=O708000EO?003001O?5ll00AO?003001O?5ll009O?08000AS?08000ISG004001WG0000007Ig`2
00000fMl001[O003Jg`00`00Jia[W004Ji`01`00Jka[_6^l001[_00000A[_08000=[g080009[g003
001[o6_l0080011oo`03001oogoo00Qoo`00<Goo0P008goo0`0000<5f`005Qd00QHM1@0000<VG@00
<Wh0139n00<003ZM>Yd01CZM00<004:m@[d014:m00<004ZmB[d01TZm00@004kMC]e>g@@0009>g@03
001BoE;m00MBo@03001Fo5Kl00IFo0@000UK7003001O75lL008000MO?003001O?5ll009O?08000MO
?004001S?0000009He`00`00IgaWO006Ig`00`00IgaWO002Ig`01000Jg`000001V^L00<006^lJk`0
0f^l00<006^lJk`00V^l00<006_LJm`00V_L00T006_LJma[g000Jo`006_l00004Goo00<007ooOol0
27oo000cOol00`00Oomoo`0QOol500035Qd010008UhRGR9N1P000S9n00<003ZM>Yd01CZM00<004:m
@[d014:m00<004ZmB[d00dZm1P001dkM00<005;mD_d01e;m00@005KlE_aFo0@000=G7@03001K75/L
00QK708000YO?004001O?000000:Gc`00`00HeaSG007He`200000f=m001WO004Ig`20006Ig`00`00
Jia[W004Ji`20005Jk`01P00Jkd00000Jk`000A[g003001[g6_L008000=[o003001oogoo011oo`03
001oogoo00Qoo`00=7oo00<007ooOol08Woo00<0006k00000P000QHM00<0029N8Uh00b9N00<002in
;Wh05`0014KM00<004kMC]d01TkM00<005;mD_d01e;m100025LM00<005/LFa`01E/L0P0000=K7@00
Gc`02Ull00<005llGc`025ll0P0000=OG@00He`01V=L00<006=mHgd00V=m0P0000=WO00000001fMl
00<006NM000016^L00<006^lJk`00f^l0P0016^m0P000V_L0P000V_L00@006_lJoa[o0<0019oo`03
001oogoo00Qoo`00=Goo00<007ooOol08Woo0P0000<1^`0000000`001B9N00<002in;Wh00bin00<0
03JN=Yh01CJN00<004:n@[h014:n00<004KMA]d01TKM00<004kMC]d01TkM00<005;mD_d015;m0P00
0U;m00<005LMEad01eLM00<005/LFa`00e/L0P0015/M00<005llGc`01Ull0P0000=O?@00Gc`01Ull
0P0015mM00<006=LHe`00V=L0P001f=m00<006MlIg`01FMl0P000fNM0P0000=[W000Jk`016^l00<0
06^mJkd00f^m00<006OMImd00`000V_L00D006_lJoa[o00000=oo`03001oogoo00moo`03001oogoo
00Qoo`00=Woo00<007ooOol08Woo1@0000@>7@00000000@RGP03000^ORin00<^OP03000fWSJN00Df
WP030012_T:n00A2_P030016gDKM00I6g@03001>gDkM00I>g@03001BoE;m00<000EBo@03001G7ELM
00MG7@03001K75/L008000MK7@03001O?5ll00=O?08000AO?@03001O?5ll009O?08000MOG@04001S
G0000007Hgd200000f=m001WO004Ig`00`00IieWW@05Iid00`00Jka[_003Jk`00`00Jke[_@02Jkd2
0003Imd00`00ImeWg@030002Jo`00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`08Ool003Mo
o`8002=oo`D0008>7@D000038Uh002in00@^OP03000fWSJN00@fWP030012_T:n00E2_P030016gDKM
00I6g@03001>gDkM00=>g@D000QBo@03001G7ELM00MG7@<000YK7@03001O?5ll008000MO?@04001O
?000000:Ged00`00HgeSO@06Hgd01@00HgeSOF=m000016Ml00<006NMIid016NM0P0000AW_@00001[
_08000A[_@04001WgFOMImd20003Imd00`00IoaWo0020007Ool00`00Oomoo`0=Ool00`00Oomoo`08
Ool003Uoo`03001oogoo029oo`030001VP00008000033Qd00000008NGPH0008^OP03000fWSJN00@f
WP030012_T:n00E2_P030016gDKM00=6g@P000A:oP03001BoE;m00MBo@03001G7ELM00AG7@80009G
7@03001K7E/M00QK7@<000YO?@03001OGEmM00QOG@800003Ggd006=m00ASO@8000ESO@04001WO000
0006Iid00`00IkeW_@03Ikd00`00Jke[_@03Jkd01@00ImeWgFOM00000fOM0P000fOl00<007ooOol0
1Woo00<007ooOol03Goo00<007ooOol027oo000jOol00`00Oomoo`0ROol00`000IX1VP0500047Uh0
0`00:WhZOP0G0004A]h00`00B_i:oP06B_h00`00D_eBo@07D_d00`00EaeG7@030005Ead20006Fad2
0002Fcd00`00GceO?@06Gcd200000emM001OG@06Ged20003Ggd00`00HgeSO@02Hgd00`00HgeSO@06
Hgd00`00IieWW@04Iid20004Ikd2000016Nm000006^m0P000fOM00D006OMImeWg@0000=Wo08000Yo
o`03001oogoo00eoo`03001oogoo00Moo`00>goo00<007ooOol08Woo0P0000@1VP001O`5o0<000<N
GP8000@ZOP03000f_SJn00@f_P03000ngSkN00DngP030016gTKN00I6gP03001:oT[n00I:oP03001B
oE;m00IBo@<000YG7@03001K7E/M00<000EK?@03001O?Elm00=O?@8000AOG@03001OGEmM009OG@80
00IOO@04001SO@000007Hgd200000f>M00000002Iid20005Ikd00`00IkeW_@03Ikd20002Imd20003
Imd01@00IoaWo6Ol00003Goo00<007ooOol037oo00<007ooOol01goo000lOol2000TOol300031O`5
00000aiN000ZOP03:Wh20005=[h00`00?]hngP05?]h00`00A]i6gP06A]h00`00B_i:oP06B_h01000
D_eBoE;m10000U<N00<005LMEad025LM0`002E/m00<005lmGcd00P001emM00@005mM000000UOO@03
001SOF=m00ISO@03001SWF>M00=SW@8000EW_@8000AW_@80009Sg@<0009Wg@8000=Wo003001oogoo
00aoo`03001oogoo00aoo`03001oogoo00Moo`00?Woo00<007ooOol08goo0`000PGl0P000QIM1P00
0RYn00<003Jn=[h00cJn00<003kN?]h01CkN00<004KNA]h01TKN00<004[nB_h00d[n1P001e<N00<0
05LMEad015LM0`000ULn00<005/mFcd01e/m0`002UmM00<005mmGgd01emm0P0000=OO@00Hgd016=m
0P001F>M0P0000AS_@00001W_@8000EW_@04001SgF?MHmd20002Hmd30002Io`2000@Ool00`00Oomo
o`0;Ool00`00Oomoo`07Ool003moo`03001oogoo02=oo`L000@FG@03000VORIn00L0008f_P03000n
gSkN00DngP030016gTKN00=6gPP000A:oP03001C7U<N00MC7P03001G7ELM00<000IG?P03001K?E/m
00AK?@80009KGP03001OGEmM00IOG@800003Ggh005mm00EOO@8000AOO@800003Hgd0000000ISW@03
001S_F>m00=S_@03001W_FNm00AW_@05001SgF?MHmd00003Hmd20002God2000COol00`00Oomoo`0:
Ool00`00Oomoo`07Ool0041oo`03001oogoo02=oo`@000040M/0000000035Ud00`009WhVOP039Wh0
0`00<[lb_`0@0004@_h00`00B_i:oP06B_h00`00DaiC7P06Dah3000:Ech00`00FceK?@030005Feh0
0`00GeeOG@03Ged20004Ggh20002Ggd20008Ggd00`00HieSW@04Hid20004Hkd200000f>n00000002
Ikd20003Hmd01@00HmeSgF?M00000eom0P005Goo00<007ooOol02Goo00<007ooOol01goo0011Ool2
000UOol400000`7K0000000400059Wh20004<[l00`00>]ljg`05>]l00`00@_i2oP06@_h00`00B_i:
oP06B_h01000DaiC7U<N10000TlN00<005LnEch025Ln0`002E]N00<005mMGed00P0025mn0P0025mm
0P0000=OWP0000000V>M0P001F>m00<006>nHkh00f>n0`000V?M0P000f?M00D005omGoeOo@0001Mo
o`03001oogoo00Uoo`03001oogoo00Moo`00@goo00<007ooOol097oo1P000Phm1@000bIn00<003:o
<[l00S:o0P001S[O0P001d;n00<004[nB_h00d[n1P001dlN0P001ULn0P000U<n00<005]NFeh01e]N
0`0025mn0P0000=KOP00Ggd01Emm0P001EnN0P001F>m0P001F>n0P000UoN0`000V?M0P000eom00<0
07ooOol05goo00<007ooOol027oo00<007ooOol01goo0014Ool00`00Oomoo`0UOol500033Sd00`00
7WhNOP080002<[l00`00>]ljg`05>]l00`00@_i2oP02@_h80004Bal00`00Cai?7P08Cah00`00EciG
?P030005Dch00`00FeiKGP04Feh20002Eeh00`00GgiOOP04Ggh20004Fgh20002Ggd20006Gih20000
15nn000006>m0P001V>n00@005oNGmiOgP80009OgP<0009Oo@8001]oo`03001oogoo00Qoo`03001o
ogoo00Ioo`00AGoo00<007ooOol09Woo1@000Phm0P001Ain00<002jo;[l03`0014;o00<004/OBal0
1T/O0P0024lN0`002E<n00<005]NFeh00`001EMN0P000Umn0P0025]n0P001UnN0P001Enn00<006>n
Hkh016>n0P000eoN00@005oNGmiOgP80009Ko@8001ioo`03001oogoo00Moo`03001oogoo00Ioo`00
AWoo00<007ooOol0:7oo1`001Ain00<002jo;[l00bjo00<003KO=]l01CKO00<004;o@_l01D;o0P00
24/O00@004lNCai?7P@0009??`03001C?U<n00MC?P<000UGGP<000QKOP800003Fih0000000=OWP80
00EO_P800003Gkh00000009S_P8000=OgP8000=OgP04001KoE_mFod2000OOol00`00Oomoo`07Ool0
0`00Oomoo`06Ool004Moo`8002Yoo`<000031Q`0000000<0008NOP03000^_bjo00<^_`8000Hfg`03
0012od;o00I2o`03001;7d/O00=;7`H000M??`8000=C?P@0009CG`03001GGUMN00EGGP80009GO`03
001KOU]n00AKOP8000EKWP<000EO_P8000EO_P<0009OgP8000=OgP80009Ko@80029oo`03001oogoo
00Ioo`03001oogoo00Ioo`00BGoo00<007ooOol0:Goo0`0000@67000000JOPL000<^_`03000fgcKO
00@fg`030012od;o00=2o`P000A7?`03001??dlo00M??`@000MCG`80009GGP<000EGO`80009KOP80
00IKWP800003Fil00000009O_P8000IO_P80009KgP<0009OgP80009Ko@8002Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`00BWoo00<007ooOol0:Woo1P000aYn0P0000<V_`0000003P0013lO00<004Lo
Acl01TLo0P000dlo10000T]O00<005=ODel01e=O0`002EMo0`001U^N0P001E^O0P001Unn0P000e_N
0P000UON1P009goo00<007ooOol01Goo00<007ooOol01Woo001;Ool00`00Oomoo`0[Ool800000aYn
000000049[l00`00<_lbo`04<_l20007?al20005Acl60007Bel20003Del40002Dgl00`00EgmGO`05
Egl20002Eil20003Fih20006Fil200000eNo00000002Gkh20003Fmh20002Emh20002Dmd2000ZOol0
0`00Oomoo`04Ool00`00Oomoo`06Ool004aoo`8002ioo`@000033Ud0000000D000039[l0000000Hb
o`8000@o7`P000A3?`8000Q;G`@000MCO`80009GO`<000IGW`<000IKW`8000AG_`<000=KgP80009G
gP80009Cg@8002eoo`03001oogoo00Aoo`03001oogoo00Eoo`00CWoo00<007ooOol0;Goo1@000PiM
00<001jn7[h03`0013/O0P0024<o0P000T]O10000T]O00<005=oDgl01e=o0`001eNO0P000U>O0P00
0e^O0P0015No0P000e>o1`000U?M0P00<7oo00<007ooOol00goo00<007ooOol01Goo001?Ool00`00
Oomoo`0^Ool800057[h20005;_l00`00>alk7`06>al20005@cl50007Bel20003Dgl40002Cgl20003
Eil30006Dil30003Ekl30003Dkl20003Ckh20002Bkd2000bOol00`00Oomoo`03Ool00`00Oomoo`05
Ool0051oo`03001oogoo02mooa800003;_l0000000Dk7`P000@o?`03001;Gd]O00I;G`@000Q?O`<0
00ECW`@000=?_`<000AC_`8000=?_P80009;_@8003Eoo`03001oogoo009oo`03001oogoo00Eoo`00
DGoo0P00<Woo1`001AZN00<002Ko9_l0200013LO00<003lo?cl01Slo0P000T]O10000TMo0P0014mo
10000d^O1@001Dno0P000d^o10000dnn0P0000A;_@00000003Qoo`05001oogooOol00007Ool005=o
o`03001oogoo03=oo`P000036Yh0000000DVo`8000Hg7`8000Do?`D000Q7O`@000I;W`800097W`80
00=?_`8000A;_`8000=7_PH003aoo`04001oogoo0007Ool005Aoo`03001oogoo03Aoo`D000033W`0
000001D000@kG`8000=7O`@00093O`8000=;W`<000I7W`<000=;_`<00003Akh0000000D003moo`04
001oogoo0007Ool005Eoo`03001oogoo03=oo`03001oogoo009oo``000037]h0000000D_7`d000I3
O`D000E7W`@000=3W`X004Aoo`03001oo`0000Moo`00EWoo0P00<goo00<007ooOol01Goo1P0000<6
F`000000200012LN0P001SLo1`0013]o1P000d>O2`00B7oo00<007oo00001Woo001HOol00`00Oomo
o`0`Ool00`00Oomoo`0:OolH0004;ch70004<eh<001=Ool20006Ool005Uoo`03001oogoo02moo`03
001oogoo011ooaH000<W7@l0059oo`8000Ioo`00FWoo00<007ooOol0;Goo00<007ooOol06Woo5`00
FWoo0P001Woo001KOol00`00Oomoo`0/Ool00`00Oomoo`27Ool40008Ool005aoo`8002aoo`03001o
ogoo08=oo`@000aoo`00GWoo00<007ooOol0:Goo00<007ooOol0Ogoo100047oo001OOol00`00Oomo
o`0XOol00`00Oomoo`1kOol4000DOol0061oo`03001oogoo02Moo`03001oogoo07Qoo`<001Qoo`00
HGoo0P009goo00<007ooOol0M7oo10006goo001SOol00`00Oomoo`0TOol00`00Oomoo`1`Ool4000O
Ool006Aoo`03001oogoo02=oo`03001oogoo06aoo`@002=oo`00IGoo00<007ooOol08Woo00<007oo
Ool0JGoo0`009goo001VOol2000ROol00`00Oomoo`1UOol4000ZOol006Qoo`03001oogoo01moo`03
001oogoo065oo`@002ioo`00JGoo00<007ooOol07Woo00<007ooOol0GGoo1000<Woo001ZOol00`00
Oomoo`0MOol00`00Oomoo`1IOol4000fOol006]oo`8001eoo`03001oogoo05Ioo`<003Yoo`00KGoo
00<007ooOol06Woo00<007ooOol0DWoo1000?Goo001^Ool00`00Oomoo`0IOol00`00Oomoo`1>Ool4
0011Ool006moo`03001oogoo01Qoo`03001oogoo04Yoo`@004Eoo`00L7oo00<007ooOol05goo00<0
07ooOol0AWoo1000BGoo001aOol2000GOol00`00Oomoo`13Ool3001=Ool007=oo`03001oogoo01Ao
o`03001oogoo03moo`@0051oo`00M7oo00<007ooOol04goo00<007ooOol0>goo1000E7oo001eOol0
0`00Oomoo`0BOol00`00Oomoo`0gOol4001HOol007Ioo`80019oo`03001oogoo03=oo`@005aoo`00
N7oo00<007ooOol03goo00<007ooOol0<7oo0`00H7oo001iOol00`00Oomoo`0>Ool00`00Oomoo`0/
Ool4001SOol007Yoo`03001oogoo00aoo`03001oogoo02Uoo`@006Moo`00Ngoo0P0037oo00<007oo
Ool09Goo1000Jgoo001mOol00`00Oomoo`09Ool00`00Oomoo`0ROol3001_Ool007ioo`03001oogoo
00Qoo`03001oogoo01ioo`@0079oo`00Ogoo00<007ooOol01goo00<007ooOol06Woo1000MWoo0020
Ool00`00Oomoo`06Ool00`00Oomoo`0FOol4001jOol0085oo`8000Ioo`03001oogoo019oo`@007io
o`00Pgoo00<007ooOol00goo00<007ooOol03goo0`00PWoo0024Ool00`00Oomoo`02Ool00`00Oomo
o`0;Ool40025Ool008Eoo`05001oogooOol00009Ool40029Ool008Ioo`800003Ool007oo00Aoo`@0
08eoo`00R7oo0P0000=oo`0000000P00TGoo0029Ool2002EOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{97.375, 384.375}, {675.563, 443}} -> {-0.560221, \
1.74081, 0.00399277, 0.00399277}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Evaluate the following code to clear symbols", "MathCaption",
  CellTags->"b:0"],

Cell[BoxData[
    \(\(Clear[\ x, y, z, u, a, g];\)\)], "Input",
  CellTags->"b:0"],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[TextData[{
  StyleBox["References\n\n", "SmallText",
    FontSize->12],
  StyleBox["Leser, C. E. V. (1961): 'A Simple Method of Trend Construction.' \
Journal of the Royal Statistical Society Series B (Methodological) Vol. 23, \
pp. 91-107. \n(Online at \
http://links.jstor.org/sici?sici=0035-9246%281961%2923%3Al%3C91%3AASMOTC%3E2.\
0.CO%3B2-K)\n\nLudsteck, Johannes (2005) HPFilter, ", "Notebook"],
  StyleBox["Mathematica", "Notebook",
    FontSlant->"Italic"],
  StyleBox[" package, Wolfram Library Archive Mathsource\n(Online at ", 
    "Notebook"],
  "http://library.wolfram.com/infocenter/Demos/5161/",
  StyleBox[")\n\nSchlicht, Ekkehart and Pauly, Ralf (1983): 'Descriptive \
Seasonal Adjustment by Minimizing Perturbations.' Empirica No. 1, pp. 15-28.\n\
(Online at \
http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/pauly_und_\
schlicht_zerlegung-oekon-zeitreihen.pdf)\n\nSchlicht, Ekkehart (1984): \
'Seasonal Adjustment in a Stochastic Model.' Statistische Hefte Vol. 25, pp. \
1-12. \n(Online at \
http://www.semverteilung.vwl.uni-muenchen.de/mitarbeiter/es/paper/schlicht_\
seasonal-adjustment-in-a-stochastic-model.pdf)\n  \nSchlicht, Ekkehart \
(2005): ' Estimating the Smoothing Parameter in the So-called \
Hodrick-Prescott Filter', ", "Notebook"],
  StyleBox["Journal of the Japan Statistical Society", "Notebook",
    FontSlant->"Italic"],
  StyleBox[", 35(1), 2005, pp. 99-119. \n(Online at ", "Notebook"],
  "http://www.scipress.org/journals/jjss/pdf/3501/35010099.pdf",
  StyleBox[")\n\nSchlicht, Ekkehart (2009):  'Trend Extraction from Time \
Series With Missing Observations and Structural Breaks, Journal of the Japan \
Statistical Society 2009, 38(2), 285-92.\n(Online at ", "Notebook"],
  "https://www.jstage.jst.go.jp/article/jjss/38/2/38_2_285/_pdf",
  StyleBox[")", "Notebook"],
  StyleBox["\n", "SmallText"],
  "\n",
  StyleBox["Acknowledgement\n",
    FontSize->12],
  "\nI thank Johannes Ludsteck for helpimg me with expert advice in preparing \
this package. \n\n\nEkkehart Schlicht,\nDepartment of Economics\nUniversity \
of Munich,\nGermany\nwww.semverteilung.vwl.uni-muenchen.de/ekkehart\n\n\
October 2005\nrevised July 2006\nrevised February 2017\n"
}], "SmallTextSans",
  PageWidth->WindowWidth,
  CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
  CellSize->{499, Inherited},
  TextAlignment->Left,
  CellTags->"b:0"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 679}},
WindowSize->{930, 659},
WindowMargins->{{Automatic, 28}, {Automatic, 78}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Inherited, Inherited, Cell[ 
        TextData[ {"The Season Package for ", 
          StyleBox[ "Mathematica", FontSlant -> "Italic"], 
          " by Ekkehart Schlicht"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The Season Package for ", 
          StyleBox[ "Mathematica", FontSlant -> "Italic"], 
          " by Ekkehart Schlicht"}], "PageHeader"], Inherited, Inherited}},
PrintingOptions->{"PrintingMargins"->{{50.375, 50.375}, {54, 36}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False},
TaggingRules:>{"NextIndexingNumber" -> 2, "IndexEntries" -> {{"i:1", \
"HPFilter"}}},
ImageSize->{288, 288},
StyleDefinitions -> "Notepad.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b:0"->{
    Cell[1776, 53, 77, 1, 95, "Title",
      CellTags->"b:0"],
    Cell[1856, 56, 211, 7, 56, "Text",
      CellTags->"b:0"],
    Cell[2070, 65, 1603, 34, 167, "Text",
      CellTags->"b:0"],
    Cell[3676, 101, 3199, 103, 195, "DefinitionBox",
      CellTags->{"i:1", "b:0"}],
    Cell[9638, 280, 64, 1, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[9705, 283, 63, 2, 30, "Input",
      CellTags->"b:0"],
    Cell[9771, 287, 171, 4, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[9945, 293, 1418, 30, 130, "Input",
      CellTags->"b:0"],
    Cell[11366, 325, 292, 8, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[11661, 335, 122, 3, 30, "Input",
      CellTags->"b:0"],
    Cell[11786, 340, 359, 16, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[12170, 360, 737, 14, 151, "Input",
      CellTags->"b:0"],
    Cell[12910, 376, 28861, 881, 187, 9610, 638, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"b:0"],
    Cell[41774, 1259, 297, 6, 25, "Print",
      CellTags->"b:0"],
    Cell[42074, 1267, 569, 11, 25, "Print",
      CellTags->"b:0"],
    Cell[42658, 1281, 354, 11, 62, "MathCaption",
      CellTags->"b:0"],
    Cell[43015, 1294, 100, 2, 30, "Input",
      CellTags->"b:0"],
    Cell[43118, 1298, 578, 16, 62, "MathCaption",
      CellTags->"b:0"],
    Cell[86575, 2388, 1843, 59, 93, "DefinitionBox",
      CellTags->"b:0"],
    Cell[88421, 2449, 94, 2, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[88915, 2468, 519, 9, 93, "DefinitionBox",
      CellTags->"b:0"],
    Cell[89437, 2479, 94, 2, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[90322, 2507, 497, 19, 42, "DefinitionBox",
      CellTags->"b:0"],
    Cell[90822, 2528, 94, 2, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[91058, 2541, 1788, 59, 93, "DefinitionBox",
      CellTags->"b:0"],
    Cell[92849, 2602, 94, 2, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[171598, 4314, 86, 1, 45, "MathCaption",
      CellTags->"b:0"],
    Cell[171687, 4317, 82, 2, 30, "Input",
      CellTags->"b:0"],
    Cell[171827, 4324, 2389, 46, 607, "SmallTextSans",
      CellTags->"b:0"]},
  "i:1"->{
    Cell[3676, 101, 3199, 103, 195, "DefinitionBox",
      CellTags->{"i:1", "b:0"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b:0", 175588, 4405},
  {"i:1", 177712, 4465}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 77, 1, 95, "Title",
  CellTags->"b:0"],
Cell[1856, 56, 211, 7, 56, "Text",
  CellTags->"b:0"],
Cell[2070, 65, 1603, 34, 167, "Text",
  CellTags->"b:0"],
Cell[3676, 101, 3199, 103, 195, "DefinitionBox",
  CellTags->{"i:1", "b:0"}],
Cell[6878, 206, 2757, 72, 252, "Text"],
Cell[9638, 280, 64, 1, 45, "MathCaption",
  CellTags->"b:0"],
Cell[9705, 283, 63, 2, 30, "Input",
  CellTags->"b:0"],
Cell[9771, 287, 171, 4, 45, "MathCaption",
  CellTags->"b:0"],
Cell[9945, 293, 1418, 30, 130, "Input",
  CellTags->"b:0"],
Cell[11366, 325, 292, 8, 45, "MathCaption",
  CellTags->"b:0"],
Cell[11661, 335, 122, 3, 30, "Input",
  CellTags->"b:0"],
Cell[11786, 340, 359, 16, 45, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[12170, 360, 737, 14, 151, "Input",
  CellTags->"b:0"],
Cell[12910, 376, 28861, 881, 187, 9610, 638, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"b:0"],
Cell[41774, 1259, 297, 6, 25, "Print",
  CellTags->"b:0"],
Cell[42074, 1267, 569, 11, 25, "Print",
  CellTags->"b:0"]
}, Open  ]],
Cell[42658, 1281, 354, 11, 62, "MathCaption",
  CellTags->"b:0"],
Cell[43015, 1294, 100, 2, 30, "Input",
  CellTags->"b:0"],
Cell[43118, 1298, 578, 16, 62, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[43721, 1318, 645, 10, 111, "Input"],
Cell[44369, 1330, 41290, 1034, 186, 9589, 638, "GraphicsData", "PostScript", \
"Graphics"],
Cell[85662, 2366, 351, 7, 25, "Print"],
Cell[86016, 2375, 544, 10, 25, "Print"]
}, Open  ]],
Cell[86575, 2388, 1843, 59, 93, "DefinitionBox",
  CellTags->"b:0"],
Cell[88421, 2449, 94, 2, 45, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[88540, 2455, 202, 5, 50, "Input"],
Cell[88745, 2462, 155, 3, 25, "Message"]
}, Open  ]],
Cell[88915, 2468, 519, 9, 93, "DefinitionBox",
  CellTags->"b:0"],
Cell[89437, 2479, 94, 2, 45, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[89556, 2485, 184, 4, 50, "Input"],
Cell[89743, 2491, 330, 5, 25, "Message"],
Cell[90076, 2498, 186, 3, 44, "Message"],
Cell[90265, 2503, 42, 1, 29, "Output"]
}, Open  ]],
Cell[90322, 2507, 497, 19, 42, "DefinitionBox",
  CellTags->"b:0"],
Cell[90822, 2528, 94, 2, 45, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[90941, 2534, 48, 1, 30, "Input"],
Cell[90992, 2537, 51, 1, 29, "Output"]
}, Open  ]],
Cell[91058, 2541, 1788, 59, 93, "DefinitionBox",
  CellTags->"b:0"],
Cell[92849, 2602, 94, 2, 45, "MathCaption",
  CellTags->"b:0"],

Cell[CellGroupData[{
Cell[92968, 2608, 101, 2, 30, "Input"],
Cell[93072, 2612, 78371, 1694, 242, 34401, 1147, "GraphicsData", \
"PostScript", "Graphics"],
Cell[171446, 4308, 137, 3, 29, "Output"]
}, Open  ]],
Cell[171598, 4314, 86, 1, 45, "MathCaption",
  CellTags->"b:0"],
Cell[171687, 4317, 82, 2, 30, "Input",
  CellTags->"b:0"],
Cell[171772, 4321, 52, 1, 50, "Input"],
Cell[171827, 4324, 2389, 46, 607, "SmallTextSans",
  CellTags->"b:0"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

